/*
 * Decompiled with CFR 0.152.
 */
package br.net.fabiozumbi12.UltimateFancy;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;

class ReflectionUtil {
    private static String versionString;
    private static final Map<String, Class<?>> loadedNMSClasses;
    private static final Map<String, Class<?>> loadedOBCClasses;
    private static final Map<Class<?>, Map<String, Method>> loadedMethods;

    ReflectionUtil() {
    }

    public static String getVersion() {
        if (versionString == null) {
            String name = Bukkit.getServer().getClass().getPackage().getName();
            versionString = name.substring(name.lastIndexOf(46) + 1) + ".";
        }
        return versionString;
    }

    public static Class<?> getNMSClass(String nmsClassName) {
        Class<?> clazz;
        if (loadedNMSClasses.containsKey(nmsClassName)) {
            return loadedNMSClasses.get(nmsClassName);
        }
        String clazzName = "net.minecraft.server." + ReflectionUtil.getVersion() + nmsClassName;
        try {
            clazz = Class.forName(clazzName);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return loadedNMSClasses.put(nmsClassName, null);
        }
        loadedNMSClasses.put(nmsClassName, clazz);
        return clazz;
    }

    public static Class<?> getOBCClass(String obcClassName) {
        Class<?> clazz;
        if (loadedOBCClasses.containsKey(obcClassName)) {
            return loadedOBCClasses.get(obcClassName);
        }
        String clazzName = "org.bukkit.craftbukkit." + ReflectionUtil.getVersion() + obcClassName;
        try {
            clazz = Class.forName(clazzName);
        }
        catch (Throwable t) {
            t.printStackTrace();
            loadedOBCClasses.put(obcClassName, null);
            return null;
        }
        loadedOBCClasses.put(obcClassName, clazz);
        return clazz;
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... params) {
        Map<String, Method> methods;
        if (!loadedMethods.containsKey(clazz)) {
            loadedMethods.put(clazz, new HashMap());
        }
        if ((methods = loadedMethods.get(clazz)).containsKey(methodName)) {
            return methods.get(methodName);
        }
        try {
            Method method = clazz.getMethod(methodName, params);
            methods.put(methodName, method);
            loadedMethods.put(clazz, methods);
            return method;
        }
        catch (Exception e) {
            e.printStackTrace();
            methods.put(methodName, null);
            loadedMethods.put(clazz, methods);
            return null;
        }
    }

    static {
        loadedNMSClasses = new HashMap();
        loadedOBCClasses = new HashMap();
        loadedMethods = new HashMap();
    }
}

