/*
 * Decompiled with CFR 0.152.
 */
package br.net.fabiozumbi12.UltimateFancy;

import br.net.fabiozumbi12.UltimateFancy.ReflectionUtil;
import br.net.fabiozumbi12.UltimateFancy.UChatColor;
import br.net.fabiozumbi12.UltimateFancy.jsonsimple.JSONArray;
import br.net.fabiozumbi12.UltimateFancy.jsonsimple.JSONObject;
import br.net.fabiozumbi12.UltimateFancy.jsonsimple.JSONValue;
import com.google.common.base.Utf8;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class UltimateFancy {
    private String hexColor = "";
    private String lastRGBColor = "";
    private ChatColor lastColor = ChatColor.WHITE;
    private ChatColor last2Color = null;
    private JSONArray constructor;
    private HashMap<String, Boolean> lastFormats;
    private List<JSONObject> workingGroup;
    private List<ExtraElement> pendentElements;
    private final JavaPlugin plugin;

    public UltimateFancy(JavaPlugin plugin) {
        this.plugin = plugin;
        this.constructor = new JSONArray();
        this.workingGroup = new ArrayList<JSONObject>();
        this.lastFormats = new HashMap();
        this.pendentElements = new ArrayList<ExtraElement>();
    }

    public UltimateFancy(JavaPlugin plugin, String text) {
        this.plugin = plugin;
        this.constructor = new JSONArray();
        this.workingGroup = new ArrayList<JSONObject>();
        this.lastFormats = new HashMap();
        this.pendentElements = new ArrayList<ExtraElement>();
        this.text(text);
    }

    public UltimateFancy coloredTextAndNext(String text) {
        text = UChatColor.translateAlternateColorCodes(text);
        return this.textAndNext(text);
    }

    public UltimateFancy textAndNext(String text) {
        this.text(text);
        return this.next();
    }

    public UltimateFancy coloredText(String text) {
        text = UChatColor.translateAlternateColorCodes(text);
        return this.text(text);
    }

    private List<JSONObject> parseColors(String text) {
        ArrayList<JSONObject> jsonList = new ArrayList<JSONObject>();
        ArrayList<String> vanillaColors = new ArrayList<String>();
        int hexCount = 0;
        StringBuilder hexValue = new StringBuilder();
        for (String vColor : text.split("(?=\u00a7)")) {
            if (hexCount > 0) {
                String lastValue;
                if (hexCount >= 7) {
                    lastValue = (String)vanillaColors.get(vanillaColors.size() - 1);
                    vanillaColors.set(vanillaColors.size() - 1, lastValue.replace("%uchathex-color%", hexValue.toString()));
                    hexValue = new StringBuilder();
                    hexCount = 0;
                } else {
                    if (vColor.startsWith("\u00a7")) {
                        hexValue.append(vColor.replace("\u00a7", ""));
                        ++hexCount;
                        continue;
                    }
                    lastValue = (String)vanillaColors.get(vanillaColors.size() - 1);
                    vanillaColors.set(vanillaColors.size() - 1, lastValue.replace("#%uchathex-color%", ""));
                    hexValue = new StringBuilder();
                    hexCount = 0;
                }
            }
            if (vColor.startsWith("\u00a7x")) {
                vanillaColors.add("#%uchathex-color%" + vColor.replaceAll("\u00a7x", ""));
                hexCount = 1;
                continue;
            }
            if (vColor.startsWith("\u00a7#")) {
                vColor = vColor.substring(1);
            }
            vanillaColors.add(vColor);
        }
        for (String part : vanillaColors) {
            JSONObject workingText = new JSONObject();
            Matcher m = Pattern.compile("#[A-Fa-f0-9]{6}|#[A-Fa-f0-9]{3}").matcher(part);
            if (m.find()) {
                this.filterColors(workingText);
                workingText.put("color", m.group());
                workingText.put("text", part.replace(m.group(), ""));
                this.lastRGBColor = this.hexColor = m.group();
                if (this.lastColor.isColor()) {
                    this.lastColor = ChatColor.WHITE;
                }
                if (this.last2Color != null && this.last2Color.isColor()) {
                    this.last2Color = null;
                }
                this.filterColors(workingText);
                if (part.length() == 2) {
                    continue;
                }
            } else {
                this.hexColor = "";
                this.filterColors(workingText);
                Matcher matcher1 = Pattern.compile("^\u00a7([0-9a-fA-Fk-oK-ORr]).*$").matcher(part);
                if (matcher1.find()) {
                    ChatColor color = ChatColor.getByChar((char)matcher1.group(1).charAt(0));
                    if (color.isColor()) {
                        this.lastColor = color;
                        this.last2Color = null;
                        this.lastRGBColor = "";
                    } else {
                        if (this.lastColor.isColor()) {
                            this.last2Color = this.lastColor;
                        }
                        this.lastColor = color;
                        this.lastRGBColor = "";
                    }
                    this.filterColors(workingText);
                    if (part.length() == 2) continue;
                }
                if (UChatColor.stripColor(part).isEmpty()) continue;
                workingText.put("text", UChatColor.stripColor(part));
                this.filterColors(workingText);
            }
            if (!workingText.containsKey("color")) {
                workingText.put("color", "white");
            }
            jsonList.add(workingText);
        }
        return jsonList;
    }

    public UltimateFancy text(String text) {
        this.workingGroup.addAll(this.parseColors(text));
        return this;
    }

    public UltimateFancy textAtStart(String text) {
        JSONArray jarray = new JSONArray();
        jarray.addAll(this.parseColors(text));
        jarray.addAll(this.getStoredElements());
        this.constructor = jarray;
        return this;
    }

    public UltimateFancy appendObject(JSONObject json) {
        this.workingGroup.add(json);
        return this;
    }

    public UltimateFancy appendString(String jsonObject) {
        Object obj = JSONValue.parse(jsonObject);
        if (obj instanceof JSONObject) {
            this.workingGroup.add((JSONObject)obj);
        }
        if (obj instanceof JSONArray) {
            for (Object object : (JSONArray)obj) {
                if (object.toString().isEmpty()) continue;
                if (object instanceof JSONArray) {
                    this.appendString(object.toString());
                    continue;
                }
                this.workingGroup.add((JSONObject)JSONValue.parse(object.toString()));
            }
        }
        return this;
    }

    public List<JSONObject> getWorkingElements() {
        return this.workingGroup;
    }

    public List<JSONObject> getStoredElements() {
        return new ArrayList<JSONObject>(this.constructor);
    }

    public UltimateFancy removeObject(JSONObject json) {
        this.workingGroup.remove(json);
        this.constructor.remove(json);
        return this;
    }

    public UltimateFancy appendAtFirst(String json) {
        Object obj = JSONValue.parse(json);
        if (obj instanceof JSONObject) {
            this.appendAtFirst((JSONObject)obj);
        }
        if (obj instanceof JSONArray) {
            for (Object object : (JSONArray)obj) {
                if (object.toString().isEmpty()) continue;
                this.appendAtFirst((JSONObject)JSONValue.parse(object.toString()));
            }
        }
        return this;
    }

    public UltimateFancy appendAtFirst(JSONObject json) {
        JSONArray jarray = new JSONArray();
        jarray.add(json);
        jarray.addAll(this.getStoredElements());
        this.constructor = jarray;
        return this;
    }

    public UltimateFancy appendAtEnd(String json) {
        Object obj = JSONValue.parse(json);
        if (obj instanceof JSONObject) {
            this.appendAtEnd((JSONObject)obj);
        }
        if (obj instanceof JSONArray) {
            for (Object object : (JSONArray)obj) {
                if (object.toString().isEmpty()) continue;
                this.appendAtEnd((JSONObject)JSONValue.parse(object.toString()));
            }
        }
        return this;
    }

    public UltimateFancy appendAtEnd(JSONObject json) {
        ArrayList<JSONObject> jarray = new ArrayList<JSONObject>(this.getWorkingElements());
        jarray.add(json);
        this.workingGroup = jarray;
        return this;
    }

    public List<UltimateFancy> getFancyElements() {
        this.next();
        ArrayList<UltimateFancy> list = new ArrayList<UltimateFancy>();
        for (Object obj : this.constructor) {
            if (!(obj instanceof JSONObject)) continue;
            list.add(new UltimateFancy(this.plugin).appendAtEnd((JSONObject)obj));
        }
        return list;
    }

    public UltimateFancy appendFancy(UltimateFancy fancy) {
        this.appendAtEnd(fancy.toJson());
        return this;
    }

    private void filterColors(JSONObject obj) {
        for (Map.Entry<String, Boolean> entry : this.lastFormats.entrySet()) {
            obj.put(entry.getKey(), entry.getValue());
        }
        if (!this.hexColor.isEmpty()) {
            obj.put("color", this.hexColor);
        } else if (this.lastColor.isColor()) {
            obj.put("color", this.lastColor.name().toLowerCase());
        }
        if (this.lastColor.equals((Object)ChatColor.RESET) || this.lastColor.isColor() || this.lastColor.isFormat()) {
            for (String string : this.lastFormats.keySet()) {
                if (this.lastColor.isFormat() && string.equalsIgnoreCase("color")) continue;
                obj.remove(string);
            }
            if (this.lastColor.equals((Object)ChatColor.RESET)) {
                this.last2Color = null;
                this.lastRGBColor = "";
            }
            this.lastFormats.clear();
        }
        if (this.lastColor.isFormat()) {
            String formatStr = this.lastColor.name().toLowerCase();
            if (this.lastColor.equals((Object)ChatColor.MAGIC)) {
                formatStr = "obfuscated";
            }
            if (this.lastColor.equals((Object)ChatColor.UNDERLINE)) {
                formatStr = "underlined";
            }
            this.lastFormats.put(formatStr, true);
            obj.put(formatStr, true);
        }
        if (this.last2Color != null) {
            obj.put("color", this.last2Color.name().toLowerCase());
        } else if (!this.lastRGBColor.isEmpty()) {
            obj.put("color", this.lastRGBColor);
        }
    }

    public void send(CommandSender to) {
        this.next();
        if (to instanceof Player) {
            this.performCommand((Player)to);
        } else {
            to.sendMessage(this.toOldFormat());
        }
    }

    public void send(CommandSender to, boolean json) {
        this.next();
        if (to instanceof Player) {
            if (json) {
                this.performCommand((Player)to);
            } else {
                to.sendMessage(this.toOldFormat());
            }
        } else {
            to.sendMessage(this.toOldFormat());
        }
    }

    public String toString() {
        return this.toJson();
    }

    private String toJson() {
        this.next();
        return "[\"\"," + this.constructor.toJSONString().substring(1);
    }

    public UltimateFancy next() {
        if (this.workingGroup.size() > 0) {
            for (JSONObject obj : this.workingGroup) {
                if (!obj.containsKey("text") || obj.get("text").toString().length() <= 0) continue;
                for (ExtraElement element : this.pendentElements) {
                    obj.put(element.getAction(), element.getJson());
                }
                this.constructor.add(obj);
            }
        }
        this.workingGroup = new ArrayList<JSONObject>();
        this.pendentElements = new ArrayList<ExtraElement>();
        return this;
    }

    public UltimateFancy clickRunCmd(String cmd) {
        this.pendentElements.add(new ExtraElement("clickEvent", this.parseJson("run_command", cmd)));
        return this;
    }

    public UltimateFancy clickSuggestCmd(String cmd) {
        this.pendentElements.add(new ExtraElement("clickEvent", this.parseJson("suggest_command", cmd)));
        return this;
    }

    public UltimateFancy clickOpenURL(URL url) {
        this.pendentElements.add(new ExtraElement("clickEvent", this.parseJson("open_url", url.toString())));
        return this;
    }

    public UltimateFancy hoverShowText(String text) {
        this.pendentElements.add(new ExtraElement("hoverEvent", this.parseHoverText(text)));
        return this;
    }

    public UltimateFancy hoverShowItem(ItemStack item) {
        JSONObject jItem = this.parseHoverItem(item);
        if (Utf8.encodedLength((CharSequence)jItem.toJSONString()) > Short.MAX_VALUE) {
            this.pendentElements.add(new ExtraElement("hoverEvent", this.parseHoverItem(new ItemStack(item.getType()))));
        }
        this.pendentElements.add(new ExtraElement("hoverEvent", jItem));
        return this;
    }

    public String toOldFormat() {
        StringBuilder result = new StringBuilder();
        for (Object mjson : this.constructor) {
            JSONObject json = (JSONObject)mjson;
            if (!json.containsKey("text")) continue;
            try {
                String colorStr = json.get("color").toString();
                try {
                    ChatColor color = ChatColor.valueOf((String)colorStr.toUpperCase());
                    if (color.equals((Object)ChatColor.WHITE)) {
                        result.append(ChatColor.RESET);
                    } else {
                        result.append(color);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                for (ChatColor frmt : ChatColor.values()) {
                    if (frmt.isColor()) continue;
                    String frmtStr = frmt.name().toLowerCase();
                    if (frmt.equals((Object)ChatColor.MAGIC)) {
                        frmtStr = "obfuscated";
                    }
                    if (frmt.equals((Object)ChatColor.UNDERLINE)) {
                        frmtStr = "underlined";
                    }
                    if (!json.containsKey(frmtStr)) continue;
                    result.append(frmt);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            result.append(json.get("text").toString());
        }
        return result.toString();
    }

    private void performCommand(Player to) {
        Bukkit.getScheduler().callSyncMethod((Plugin)this.plugin, () -> {
            Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), "tellraw " + to.getName() + " " + this.toJson());
            return null;
        });
    }

    private JSONObject parseHoverText(String text) {
        JSONArray extraArr = this.addColorToArray(UChatColor.translateAlternateColorCodes(text));
        JSONObject objExtra = new JSONObject();
        objExtra.put("text", "");
        objExtra.put("extra", extraArr);
        JSONObject obj = new JSONObject();
        obj.put("action", "show_text");
        obj.put("value", objExtra);
        return obj;
    }

    private JSONObject parseJson(String action, String value) {
        JSONObject obj = new JSONObject();
        obj.put("action", action);
        obj.put("value", value);
        return obj;
    }

    private JSONObject parseHoverItem(ItemStack item) {
        JSONObject obj = new JSONObject();
        obj.put("action", "show_item");
        String jItem = this.convertItemStackToJson(item);
        if (Utf8.encodedLength((CharSequence)jItem) > Short.MAX_VALUE) {
            obj.put("value", this.convertItemStackToJson(new ItemStack(item.getType())));
        }
        obj.put("value", jItem);
        return obj;
    }

    private String convertItemStackToJson(ItemStack itemStack) {
        Object itemAsJsonObject;
        Class<?> craftItemStackClazz = ReflectionUtil.getOBCClass("inventory.CraftItemStack");
        Method asNMSCopyMethod = ReflectionUtil.getMethod(craftItemStackClazz, "asNMSCopy", ItemStack.class);
        Class<?> nmsItemStackClazz = ReflectionUtil.getNMSClass("ItemStack");
        Class<?> nbtTagCompoundClazz = ReflectionUtil.getNMSClass("NBTTagCompound");
        Method saveNmsItemStackMethod = ReflectionUtil.getMethod(nmsItemStackClazz, "save", nbtTagCompoundClazz);
        try {
            Object nmsNbtTagCompoundObj = nbtTagCompoundClazz.newInstance();
            Object nmsItemStackObj = asNMSCopyMethod.invoke(null, itemStack);
            itemAsJsonObject = saveNmsItemStackMethod.invoke(nmsItemStackObj, nmsNbtTagCompoundObj);
        }
        catch (Throwable t) {
            return null;
        }
        return itemAsJsonObject.toString();
    }

    private JSONArray addColorToArray(String text) {
        JSONArray extraArr = new JSONArray();
        ChatColor color = ChatColor.WHITE;
        for (String part : text.split("(?=\u00a7[0-9a-fA-Fk-oK-ORr])")) {
            JSONObject objExtraTxt = new JSONObject();
            Matcher match = Pattern.compile("^\u00a7([0-9a-fA-Fk-oK-ORr]).*$").matcher(part);
            if (match.find()) {
                color = ChatColor.getByChar((char)match.group(1).charAt(0));
                if (part.length() == 2) continue;
            }
            objExtraTxt.put("text", UChatColor.stripColor(part));
            if (color.isColor()) {
                objExtraTxt.put("color", color.name().toLowerCase());
                objExtraTxt.remove("obfuscated");
                objExtraTxt.remove("underlined");
                objExtraTxt.remove(ChatColor.STRIKETHROUGH.name().toLowerCase());
            }
            if (color.equals((Object)ChatColor.RESET)) {
                objExtraTxt.put("color", "white");
                objExtraTxt.remove("obfuscated");
                objExtraTxt.remove("underlined");
                objExtraTxt.remove(ChatColor.STRIKETHROUGH.name().toLowerCase());
            }
            if (color.isFormat()) {
                if (color.equals((Object)ChatColor.MAGIC)) {
                    objExtraTxt.put("obfuscated", true);
                } else if (color.equals((Object)ChatColor.UNDERLINE)) {
                    objExtraTxt.put("underlined", true);
                } else {
                    objExtraTxt.put(color.name().toLowerCase(), true);
                }
            }
            extraArr.add(objExtraTxt);
        }
        return extraArr;
    }

    public void setContructor(JSONArray array) {
        this.constructor = array;
    }

    public UltimateFancy clone() {
        UltimateFancy newFanci = new UltimateFancy(this.plugin);
        newFanci.constructor = this.constructor;
        newFanci.pendentElements = this.pendentElements;
        newFanci.workingGroup = this.workingGroup;
        newFanci.lastFormats = this.lastFormats;
        return newFanci;
    }

    public static class ExtraElement {
        private final String action;
        private final JSONObject json;

        public ExtraElement(String action, JSONObject json) {
            this.action = action;
            this.json = json;
        }

        public String getAction() {
            return this.action;
        }

        public JSONObject getJson() {
            return this.json;
        }
    }
}

