/*
 * Decompiled with CFR 0.152.
 */
package ca.agnate.EconXP;

import ca.agnate.EconXP.EconXPCommands;
import ca.agnate.EconXP.EconXPEntityListener;
import ca.agnate.EconXP.EconXPPlayerListener;
import ca.agnate.EconXP.Node;
import ca.agnate.EconXP.OfflineManager;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class EconXP
extends JavaPlugin {
    protected List<Node> permissionOPs;
    protected Server server;
    public OfflineManager offline;
    public float dropOnDeath;

    public void onDisable() {
        System.out.println("[" + (Object)((Object)this) + "] EconXP is disabled.");
    }

    public void onEnable() {
        this.permissionOPs = new LinkedList<Node>();
        this.permissionOPs.add(Node.ADD);
        this.permissionOPs.add(Node.SUBTRACT);
        this.permissionOPs.add(Node.BALANCE);
        this.permissionOPs.add(Node.BALANCESELF);
        this.permissionOPs.add(Node.CLEAR);
        this.permissionOPs.add(Node.VERSION);
        this.permissionOPs.add(Node.SET);
        this.permissionOPs.add(Node.GIVE);
        this.permissionOPs.add(Node.TRANSFER);
        this.permissionOPs.add(Node.MULTIPLY);
        this.permissionOPs.add(Node.DIVIDE);
        this.offline = new OfflineManager(this);
        this.server = this.getServer();
        this.dropOnDeath = (float)Math.min(100, Math.max(0, this.getConfig().getInt("death-drop-percent", 100))) / 100.0f;
        EconXPCommands commandExecutor = new EconXPCommands(this);
        this.getCommand("econxp").setExecutor((CommandExecutor)commandExecutor);
        this.getCommand("exp").setExecutor((CommandExecutor)commandExecutor);
        PluginManager pm = this.getServer().getPluginManager();
        EconXPEntityListener entityListener = new EconXPEntityListener(this);
        EconXPPlayerListener playerListener = new EconXPPlayerListener(this);
        pm.registerEvent(Event.Type.ENTITY_DEATH, (Listener)entityListener, Event.Priority.Lowest, (Plugin)this);
        pm.registerEvent(Event.Type.PLAYER_RESPAWN, (Listener)playerListener, Event.Priority.Lowest, (Plugin)this);
        pm.registerEvent(Event.Type.PLAYER_JOIN, (Listener)playerListener, Event.Priority.Lowest, (Plugin)this);
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
        System.out.println("[" + (Object)((Object)this) + "] EconXP is enabled.");
    }

    public int setExp(OfflinePlayer p, int value) {
        if (p == null) {
            return -1;
        }
        if (p instanceof Player) {
            return this.setExp((Player)p, value);
        }
        if (this.offline.setBalance(p.getName(), value)) {
            return value;
        }
        return -1;
    }

    public int setExp(Player p, int value) {
        if (p == null) {
            return -1;
        }
        int level = 0;
        int total = value;
        int tnl = this.getExpTolevel(level);
        float exp = (float)total / (float)tnl;
        while (exp >= 1.0f) {
            tnl = this.getExpTolevel(++level);
            exp = (float)(total -= tnl) / (float)tnl;
        }
        p.setTotalExperience(value);
        p.setLevel(level);
        p.setExp(exp);
        return value;
    }

    public int getExpTolevel(int level) {
        return 7 + (level * 7 >> 1);
    }

    public int getExp(OfflinePlayer p) {
        if (p == null) {
            return -1;
        }
        if (p instanceof Player) {
            return this.getExp((Player)p);
        }
        return this.offline.getBalance(p.getName());
    }

    public int getExp(Player p) {
        if (p == null) {
            return -1;
        }
        return p.getTotalExperience();
    }

    public int removeExp(Player p, int value) {
        return this.removeExp((OfflinePlayer)p, value);
    }

    public int removeExp(OfflinePlayer p, int value) {
        int remain = this.getExp(p);
        if (remain >= 0) {
            remain -= value;
        }
        if (remain >= 0) {
            this.setExp(p, remain);
            remain = value;
        } else {
            this.setExp(p, 0);
            remain = value + remain;
        }
        return remain;
    }

    public int addExp(Player p, int value) {
        return this.addExp((OfflinePlayer)p, value);
    }

    public int addExp(OfflinePlayer p, int value) {
        int exp = this.getExp(p);
        if (exp < 0) {
            return 0;
        }
        if (value < 0) {
            return 0;
        }
        this.setExp(p, exp + value);
        return value;
    }

    public int multiplyExp(Player p, float multiplier) {
        return this.multiplyExp((OfflinePlayer)p, multiplier);
    }

    public int multiplyExp(OfflinePlayer p, float multiplier) {
        if (p == null) {
            return 0;
        }
        if (multiplier < 0.0f) {
            return 0;
        }
        int exp = this.getExp(p);
        if (exp < 0) {
            return 0;
        }
        return this.setExp(p, Math.round((float)exp * multiplier));
    }

    public int divideExp(Player p, float divisor) {
        return this.divideExp((OfflinePlayer)p, divisor);
    }

    public int divideExp(OfflinePlayer p, float divisor) {
        if (p == null) {
            return 0;
        }
        if (divisor < 0.0f) {
            return 0;
        }
        int exp = this.getExp(p);
        if (exp < 0) {
            return 0;
        }
        return this.setExp(p, Math.round((float)exp / divisor));
    }

    public int clearExp(Player p) {
        return this.clearExp((OfflinePlayer)p);
    }

    public int clearExp(OfflinePlayer p) {
        int exp = this.getExp(p);
        this.setExp(p, 0);
        return exp;
    }

    public boolean hasExp(Player p, int value) {
        return this.hasExp((OfflinePlayer)p, value);
    }

    public boolean hasExp(OfflinePlayer p, int value) {
        return this.getExp(p) >= value;
    }

    public int giveExp(Player giver, Player receiver, int value) {
        return this.giveExp((OfflinePlayer)giver, (OfflinePlayer)receiver, value);
    }

    public int giveExp(OfflinePlayer giver, Player receiver, int value) {
        return this.giveExp(giver, (OfflinePlayer)receiver, value);
    }

    public int giveExp(Player giver, OfflinePlayer receiver, int value) {
        return this.giveExp((OfflinePlayer)giver, receiver, value);
    }

    public int giveExp(OfflinePlayer giver, OfflinePlayer receiver, int value) {
        if (giver == null || receiver == null) {
            return 0;
        }
        if (value < 0) {
            return 0;
        }
        if (!this.hasExp(giver, value)) {
            return 0;
        }
        return this.addExp(receiver, this.removeExp(giver, value));
    }

    public int calcDroppedExp(Player player) {
        if (player == null) {
            return 0;
        }
        return (int)Math.ceil((float)this.getExp(player) * this.dropOnDeath);
    }

    public int calcRemainingExp(Player player) {
        if (player == null) {
            return 0;
        }
        return this.getExp(player) - this.calcDroppedExp(player);
    }

    public boolean isValidPlayer(String player) {
        if (player.isEmpty()) {
            return false;
        }
        if (this.getOnlinePlayer(player) != null) {
            return true;
        }
        return this.getOfflinePlayer(player) != null;
    }

    public OfflinePlayer getPlayer(String player) {
        if (player.isEmpty()) {
            return null;
        }
        Player target = this.getOnlinePlayer(player);
        if (target != null) {
            return target;
        }
        OfflinePlayer offTarget = this.getOfflinePlayer(player);
        if (offTarget != null) {
            return offTarget;
        }
        return null;
    }

    protected Player getOnlinePlayer(String name) {
        return this.server.getPlayer(name);
    }

    protected OfflinePlayer getOfflinePlayer(String name) {
        return this.server.getOfflinePlayer(name);
    }

    public static boolean sendMsg(CommandSender p, String msg) {
        if (msg.equals("")) {
            return false;
        }
        if (p == null) {
            System.out.println("[EconXP] " + msg);
            return true;
        }
        p.sendMessage(ChatColor.AQUA + "[EconXP] " + ChatColor.WHITE + msg);
        return true;
    }

    public boolean has(Permissible p, Node n) {
        return this.hasSuperPerms(p, n.toString()) || this.hasOPPerm(p, n);
    }

    protected boolean hasOPPerm(Permissible p, Node node) {
        return this.permissionOPs == null || !this.permissionOPs.contains((Object)node) || p.isOp();
    }

    protected boolean hasSuperPerms(Permissible p, String s) {
        String[] nodes = s.split("\\.");
        if (p.hasPermission(s)) {
            return true;
        }
        String perm = "";
        int i = 0;
        while (i < nodes.length) {
            if (p.hasPermission(String.valueOf(perm = String.valueOf(perm) + nodes[i] + ".") + "*")) {
                return true;
            }
            ++i;
        }
        return p.hasPermission(s);
    }
}

