/*
 * Decompiled with CFR 0.152.
 */
package ca.agnate.EconXP;

import ca.agnate.EconXP.EconXP;
import ca.agnate.EconXP.EconXPMsg;
import ca.agnate.EconXP.Node;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class EconXPCommands
implements CommandExecutor {
    private boolean meanAdmins;
    private Server server;
    private EconXP plugin;

    public EconXPCommands(EconXP aPlugin) {
        this.plugin = aPlugin;
        this.server = this.plugin.getServer();
        this.meanAdmins = this.server.getPluginManager().getPlugin("Mean Admins") != null;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String arg3;
        if (args.length == 0) {
            return false;
        }
        String base = args[0].toLowerCase();
        Node cmd = this.getBaseCommand(base);
        if (this.meanAdmins && cmd == null) {
            this.server.getPluginManager().getPlugin("Mean Admins").onCommand(sender, command, label, args);
            return true;
        }
        if (cmd == null) {
            EconXP.sendMsg(sender, EconXPMsg.Msg.COMMAND_NOT_FOUND.get());
            return false;
        }
        boolean console = sender instanceof ConsoleCommandSender;
        String arg1 = args.length > 1 ? args[1].toLowerCase() : "";
        String arg2 = args.length > 2 ? args[2].toLowerCase() : "";
        String string = arg3 = args.length > 3 ? args[3].toLowerCase() : "";
        if (cmd.equals((Object)Node.BALANCE) && (arg1.isEmpty() || arg1.toLowerCase().equals(sender.getName().toLowerCase()))) {
            cmd = Node.BALANCESELF;
        }
        if (!this.plugin.has((Permissible)sender, cmd)) {
            EconXP.sendMsg(sender, EconXPMsg.Msg.COMMAND_NOT_ALLOWED.get(sender.getName()));
            return true;
        }
        if (cmd.equals((Object)Node.ADD)) {
            OfflinePlayer target = this.validatePlayer(sender, arg1);
            if (target == null) {
                return true;
            }
            int amount = this.validateAmount(sender, arg2);
            if (amount < 0) {
                return true;
            }
            EconXP.sendMsg(sender, EconXPMsg.Msg.PLAYER_ADD.get(target.getName(), "" + this.plugin.addExp(target, amount)));
            return true;
        }
        if (cmd.equals((Object)Node.SUBTRACT)) {
            OfflinePlayer target = this.validatePlayer(sender, arg1);
            if (target == null) {
                return true;
            }
            int amount = this.validateAmount(sender, arg2);
            if (amount < 0) {
                return true;
            }
            EconXP.sendMsg(sender, EconXPMsg.Msg.PLAYER_SUBTRACT.get(target.getName(), "" + this.plugin.removeExp(target, amount)));
            return true;
        }
        if (cmd.equals((Object)Node.SET)) {
            OfflinePlayer target = this.validatePlayer(sender, arg1);
            if (target == null) {
                return true;
            }
            int amount = this.validateAmount(sender, arg2);
            if (amount < 0) {
                return true;
            }
            EconXP.sendMsg(sender, EconXPMsg.Msg.PLAYER_SET.get(target.getName(), "" + this.plugin.setExp(target, amount)));
            return true;
        }
        if (cmd.equals((Object)Node.BALANCE)) {
            OfflinePlayer target = this.validatePlayer(sender, arg1);
            if (target == null) {
                return true;
            }
            EconXP.sendMsg(sender, EconXPMsg.Msg.PLAYER_BALANCE.get(target.getName(), "" + this.plugin.getExp(target)));
            return true;
        }
        if (cmd.equals((Object)Node.BALANCESELF)) {
            if (console) {
                EconXP.sendMsg(sender, EconXPMsg.Msg.COMMAND_CONSOLE_BALANCESELF_NOT_ALLOWED.get());
                return true;
            }
            EconXP.sendMsg(sender, EconXPMsg.Msg.PLAYER_BALANCESELF.get(sender.getName(), "" + this.plugin.getExp((Player)sender)));
            return true;
        }
        if (cmd.equals((Object)Node.CLEAR)) {
            OfflinePlayer target = this.validatePlayer(sender, arg1);
            if (target == null) {
                return true;
            }
            EconXP.sendMsg(sender, EconXPMsg.Msg.PLAYER_CLEAR.get(target.getName(), "" + this.plugin.clearExp(target)));
            return true;
        }
        if (cmd.equals((Object)Node.VERSION)) {
            EconXP.sendMsg(sender, "Version #" + this.plugin.getDescription().getVersion());
            return true;
        }
        if (cmd.equals((Object)Node.GIVE)) {
            if (console) {
                EconXP.sendMsg(sender, EconXPMsg.Msg.COMMAND_CONSOLE_GIVE_NOT_ALLOWED.get());
                return true;
            }
            OfflinePlayer target = this.validatePlayer(sender, arg1);
            if (target == null) {
                return true;
            }
            int amount = this.validateAmount(sender, arg2);
            if (amount < 0) {
                return true;
            }
            EconXP.sendMsg(sender, EconXPMsg.Msg.PLAYER_GIVE.get(target.getName(), "" + this.plugin.giveExp((Player)sender, target, amount)));
            return true;
        }
        if (cmd.equals((Object)Node.TRANSFER)) {
            OfflinePlayer giver = this.validatePlayer(sender, arg1);
            if (giver == null) {
                return true;
            }
            int amount = this.validateAmount(sender, arg2);
            if (amount < 0) {
                return true;
            }
            OfflinePlayer receiver = this.validatePlayer(sender, arg3);
            if (receiver == null) {
                return true;
            }
            EconXP.sendMsg(sender, EconXPMsg.Msg.PLAYER_TRANSFER.get(giver.getName(), "" + this.plugin.giveExp(giver, receiver, amount), receiver.getName()));
            return true;
        }
        if (cmd.equals((Object)Node.MULTIPLY)) {
            OfflinePlayer target = this.validatePlayer(sender, arg1);
            if (target == null) {
                return true;
            }
            float multiplier = this.validateFloatAmount(sender, arg2);
            if (multiplier < 0.0f) {
                return true;
            }
            EconXP.sendMsg(sender, EconXPMsg.Msg.PLAYER_MULTIPLY.get(target.getName(), "" + multiplier, "" + this.plugin.multiplyExp(target, multiplier)));
            return true;
        }
        if (cmd.equals((Object)Node.DIVIDE)) {
            OfflinePlayer target = this.validatePlayer(sender, arg1);
            if (target == null) {
                return true;
            }
            float divisor = this.validateFloatAmount(sender, arg2);
            if (divisor < 0.0f) {
                return true;
            }
            EconXP.sendMsg(sender, EconXPMsg.Msg.PLAYER_DIVIDE.get(target.getName(), "" + divisor, "" + this.plugin.divideExp(target, divisor)));
            return true;
        }
        EconXP.sendMsg(sender, EconXPMsg.Msg.COMMAND_UNHANDLED.get(cmd.toString()));
        return true;
    }

    private Node getBaseCommand(String base) {
        List<Node> list = Node.allNodes();
        for (Node node : list) {
            if (!this.contains(base, node.toString())) continue;
            return node;
        }
        return null;
    }

    private OfflinePlayer validatePlayer(CommandSender sender, String player) {
        if (player.isEmpty()) {
            EconXP.sendMsg(sender, EconXPMsg.Msg.PLAYER_NOT_GIVEN.get());
            return null;
        }
        Player target = this.plugin.getOnlinePlayer(player);
        if (target != null) {
            return target;
        }
        OfflinePlayer offTarget = this.plugin.getOfflinePlayer(player);
        if (offTarget != null && offTarget.hasPlayedBefore()) {
            return offTarget;
        }
        EconXP.sendMsg(sender, EconXPMsg.Msg.PLAYER_NOT_EXISTS.get(player));
        return null;
    }

    private int validateAmount(CommandSender sender, String value) {
        if (value.isEmpty()) {
            EconXP.sendMsg(sender, EconXPMsg.Msg.AMOUNT_NOT_GIVEN.get());
            return -1;
        }
        int amount = Integer.parseInt(value);
        if (amount <= 0) {
            EconXP.sendMsg(sender, EconXPMsg.Msg.AMOUNT_INVALID.get(value));
            return -1;
        }
        return amount;
    }

    private float validateFloatAmount(CommandSender sender, String value) {
        if (value.isEmpty()) {
            EconXP.sendMsg(sender, EconXPMsg.Msg.AMOUNT_NOT_GIVEN.get());
            return -1.0f;
        }
        float amount = Float.parseFloat(value);
        if (amount <= 0.0f) {
            EconXP.sendMsg(sender, EconXPMsg.Msg.AMOUNT_INVALID.get(value));
            return -1.0f;
        }
        return amount;
    }

    private boolean contains(String str, String command) {
        return command.toLowerCase().contains(str.toLowerCase());
    }
}

