/*
 * Decompiled with CFR 0.152.
 */
package ca.agnate.EconXP;

import ca.agnate.EconXP.EconXP;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.World;
import org.jnbt.CompoundTag;
import org.jnbt.FloatTag;
import org.jnbt.IntTag;
import org.jnbt.NBTInputStream;
import org.jnbt.NBTOutputStream;
import org.jnbt.Tag;

public class OfflineManager {
    private File dataDir;
    private EconXP plugin;

    public OfflineManager(EconXP aPlugin) {
        this.plugin = aPlugin;
        this.dataDir = new File(((World)this.plugin.getServer().getWorlds().get(0)).getName(), "players");
    }

    public boolean dataExists(String name) {
        return new File(this.dataDir, String.valueOf(name) + ".dat").exists();
    }

    public int getBalance(String name) {
        if (!this.dataExists(name)) {
            System.out.println(String.valueOf(name) + " does not exist.");
            return -1;
        }
        return this.readExperience(name);
    }

    public boolean setBalance(String name, int value) {
        if (!this.dataExists(name)) {
            System.out.println(String.valueOf(name) + " does not exist.");
            return false;
        }
        return this.writeExperience(name, value);
    }

    private int readExperience(String name) {
        try {
            NBTInputStream in = new NBTInputStream(new FileInputStream(new File(this.dataDir, String.valueOf(name) + ".dat")));
            CompoundTag tag = (CompoundTag)in.readTag();
            in.close();
            IntTag exp = (IntTag)tag.getValue().get("XpTotal");
            return exp.getValue();
        }
        catch (IOException ex) {
            System.out.println("[EconXP] Error reading experience for " + name + "[" + ex.getMessage() + "]");
            return -1;
        }
    }

    private boolean writeExperience(String name, int value) {
        try {
            NBTInputStream in = new NBTInputStream(new FileInputStream(new File(this.dataDir, String.valueOf(name) + ".dat")));
            CompoundTag tag = (CompoundTag)in.readTag();
            in.close();
            if (value < 0) {
                value = 0;
            }
            int level = 0;
            int total = value;
            int tnl = this.plugin.getExpTolevel(level);
            float exp = (float)total / (float)tnl;
            while (exp >= 1.0f) {
                tnl = this.plugin.getExpTolevel(++level);
                exp = (float)(total -= tnl) / (float)tnl;
            }
            FloatTag newExpCur = new FloatTag("XpP", exp);
            IntTag newExpLevel = new IntTag("XpLevel", level);
            IntTag newExp = new IntTag("XpTotal", value);
            HashMap<String, Tag> tagCompound = new HashMap<String, Tag>((Map<String, Tag>)tag.getValue());
            tagCompound.put("XpTotal", newExp);
            tagCompound.put("XpLevel", newExpLevel);
            tagCompound.put("XpP", newExpCur);
            tag = new CompoundTag("Player", tagCompound);
            NBTOutputStream out = new NBTOutputStream(new FileOutputStream(new File(this.dataDir, String.valueOf(name) + ".dat")));
            out.writeTag(tag);
            out.close();
            return true;
        }
        catch (IOException ex) {
            System.out.println("[EconXP] Error reading experience for " + name + "[" + ex.getMessage() + "]");
            return false;
        }
    }
}

