/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.command;

import com.boydti.fawe.command.CFICommands;
import com.boydti.fawe.config.Commands;
import com.boydti.fawe.jnbt.anvil.HeightMapMCAGenerator;
import com.boydti.fawe.object.FawePlayer;
import com.boydti.fawe.object.changeset.CFIChangeSet;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.command.MethodCommands;
import com.sk89q.worldedit.util.command.SimpleDispatcher;
import com.sk89q.worldedit.util.command.parametric.ParametricBuilder;
import java.io.IOException;

public class CFICommand
extends MethodCommands {
    private final CFICommands child;
    private final SimpleDispatcher dispatcher = new SimpleDispatcher();

    public CFICommand(WorldEdit worldEdit, ParametricBuilder builder) {
        super(worldEdit);
        this.child = new CFICommands(worldEdit, this.dispatcher);
        builder.registerMethodsAsCommands(this.dispatcher, this.child);
    }

    @Command(aliases={"cfi", "createfromimage"}, usage="", min=0, max=-1, anyFlags=true, desc="Start CreateFromImage")
    @CommandPermissions(value={"worldedit.anvil.cfi"})
    public void cfi(FawePlayer fp, CommandContext context) throws CommandException, IOException {
        CFICommands.CFISettings settings = this.child.getSettings(fp);
        settings.popMessages(fp);
        this.dispatch(fp, settings, context);
        HeightMapMCAGenerator gen = settings.getGenerator();
        if (gen != null && gen.isModified()) {
            gen.update();
            CFIChangeSet set = new CFIChangeSet(gen, fp.getUUID());
            LocalSession session = fp.getSession();
            session.remember(fp.getPlayer(), gen, set, fp.getLimit());
        }
    }

    private void dispatch(FawePlayer fp, CFICommands.CFISettings settings, CommandContext context) throws CommandException {
        if (!settings.hasGenerator()) {
            switch (context.argsLength()) {
                case 0: {
                    String hmCmd = this.child.alias() + " ";
                    hmCmd = settings.image == null ? hmCmd + "image" : Commands.getAlias(CFICommands.class, "heightmap") + " " + settings.imageArg;
                    this.child.msg("What do you want to use as the base?").newline().text("&7[&aHeightMap&7]").cmdTip(hmCmd).text(" - A heightmap like ").text("&7[&athis&7]").linkTip("http://i.imgur.com/qCd30MR.jpg").newline().text("&7[&aEmpty&7]").cmdTip(this.child.alias() + " empty").text("- An empty map of a specific size").send(fp);
                    break;
                }
                default: {
                    String remaining = context.getJoinedStrings(0);
                    if (!this.dispatcher.contains(context.getString(0))) {
                        switch (context.argsLength()) {
                            case 1: {
                                String cmd = Commands.getAlias(CFICommands.class, "heightmap") + " " + context.getJoinedStrings(0);
                                this.dispatcher.call(cmd, context.getLocals(), new String[0]);
                                return;
                            }
                            case 2: {
                                String cmd = Commands.getAlias(CFICommands.class, "empty") + " " + context.getJoinedStrings(0);
                                this.dispatcher.call(cmd, context.getLocals(), new String[0]);
                                return;
                            }
                        }
                    }
                    this.dispatcher.call(remaining, context.getLocals(), new String[0]);
                    break;
                }
            }
        } else {
            switch (context.argsLength()) {
                case 0: {
                    settings.setCategory("");
                    this.child.mainMenu(fp);
                    break;
                }
                default: {
                    this.dispatcher.call(context.getJoinedStrings(0), context.getLocals(), new String[0]);
                }
            }
        }
    }
}

