/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.example;

import com.boydti.fawe.example.IFaweQueueMap;
import com.boydti.fawe.example.MappedFaweQueue;
import com.boydti.fawe.object.FaweChunk;
import com.boydti.fawe.object.FaweQueue;
import com.boydti.fawe.object.RunnableVal;
import com.boydti.fawe.util.MathMan;
import com.boydti.fawe.util.SetQueue;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class DefaultFaweQueueMap
implements IFaweQueueMap {
    private final MappedFaweQueue parent;
    public final Long2ObjectOpenHashMap<FaweChunk> blocks = new Long2ObjectOpenHashMap<FaweChunk>(){

        public FaweChunk put(Long key, FaweChunk value) {
            return this.put((long)key, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FaweChunk put(long key, FaweChunk value) {
            if (DefaultFaweQueueMap.this.parent.getProgressTask() != null) {
                try {
                    DefaultFaweQueueMap.this.parent.getProgressTask().run(FaweQueue.ProgressType.QUEUE, this.size() + 1);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            1 var4_4 = this;
            synchronized (var4_4) {
                return (FaweChunk)super.put(key, (Object)value);
            }
        }
    };
    private volatile FaweChunk lastWrappedChunk;
    private int lastX = Integer.MIN_VALUE;
    private int lastZ = Integer.MIN_VALUE;

    public DefaultFaweQueueMap(MappedFaweQueue parent) {
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<FaweChunk> getFaweCunks() {
        Long2ObjectOpenHashMap<FaweChunk> long2ObjectOpenHashMap = this.blocks;
        synchronized (long2ObjectOpenHashMap) {
            return new HashSet<FaweChunk>((Collection<FaweChunk>)this.blocks.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEachChunk(RunnableVal<FaweChunk> onEach) {
        Long2ObjectOpenHashMap<FaweChunk> long2ObjectOpenHashMap = this.blocks;
        synchronized (long2ObjectOpenHashMap) {
            for (Map.Entry entry : this.blocks.entrySet()) {
                onEach.run((FaweChunk)entry.getValue());
            }
        }
    }

    @Override
    public FaweChunk getFaweChunk(int cx, int cz) {
        if (cx == this.lastX && cz == this.lastZ) {
            return this.lastWrappedChunk;
        }
        long pair = MathMan.pairInt(cx, cz);
        FaweChunk chunk = (FaweChunk)this.blocks.get(pair);
        if (chunk == null) {
            chunk = this.getNewFaweChunk(cx, cz);
            FaweChunk previous = (FaweChunk)this.blocks.put(pair, (Object)chunk);
            if (previous != null) {
                this.blocks.put(pair, (Object)previous);
                return previous;
            }
            this.blocks.put(pair, (Object)chunk);
        }
        return chunk;
    }

    @Override
    public FaweChunk getCachedFaweChunk(int cx, int cz) {
        FaweChunk chunk;
        if (cx == this.lastX && cz == this.lastZ) {
            return this.lastWrappedChunk;
        }
        long pair = MathMan.pairInt(cx, cz);
        this.lastWrappedChunk = chunk = (FaweChunk)this.blocks.get(pair);
        return chunk;
    }

    @Override
    public void add(FaweChunk chunk) {
        long pair = MathMan.pairInt(chunk.getX(), chunk.getZ());
        FaweChunk previous = (FaweChunk)this.blocks.put(pair, (Object)chunk);
        if (previous != null) {
            this.blocks.put(pair, (Object)previous);
        }
    }

    @Override
    public void clear() {
        this.blocks.clear();
    }

    @Override
    public int size() {
        return this.blocks.size();
    }

    private FaweChunk getNewFaweChunk(int cx, int cz) {
        return this.parent.getFaweChunk(cx, cz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean next(int amount, long time) {
        Long2ObjectOpenHashMap<FaweChunk> long2ObjectOpenHashMap = this.blocks;
        synchronized (long2ObjectOpenHashMap) {
            block13: {
                try {
                    Future future;
                    boolean skip = this.parent.getStage() == SetQueue.QueueStage.INACTIVE;
                    int added = 0;
                    ObjectIterator iter = this.blocks.entrySet().iterator();
                    if (amount == 1) {
                        long start = System.currentTimeMillis();
                        while (iter.hasNext()) {
                            FaweChunk chunk = (FaweChunk)((Map.Entry)iter.next()).getValue();
                            if (!skip || chunk != this.lastWrappedChunk) {
                                iter.remove();
                                this.parent.start(chunk);
                                chunk.call();
                                this.parent.end(chunk);
                            }
                            if (System.currentTimeMillis() - start < time) continue;
                            break block13;
                        }
                        break block13;
                    }
                    ExecutorCompletionService service = SetQueue.IMP.getCompleterService();
                    ForkJoinPool pool = SetQueue.IMP.getForkJoinPool();
                    boolean result = true;
                    for (int i = 0; i < amount && (result = iter.hasNext()); ++i) {
                        Map.Entry item = (Map.Entry)iter.next();
                        FaweChunk chunk = (FaweChunk)item.getValue();
                        if (skip && chunk == this.lastWrappedChunk) {
                            --i;
                            continue;
                        }
                        iter.remove();
                        this.parent.start(chunk);
                        service.submit(chunk);
                        ++added;
                    }
                    if (result) {
                        long start = System.currentTimeMillis();
                        while (System.currentTimeMillis() - start < time && result) {
                            result = iter.hasNext();
                            if (!result) continue;
                            Map.Entry item = (Map.Entry)iter.next();
                            FaweChunk chunk = (FaweChunk)item.getValue();
                            if (skip && chunk == this.lastWrappedChunk) continue;
                            iter.remove();
                            this.parent.start(chunk);
                            service.submit(chunk);
                            Future future2 = service.poll(50L, TimeUnit.MILLISECONDS);
                            if (future2 == null) continue;
                            FaweChunk fc = (FaweChunk)future2.get();
                            this.parent.end(fc);
                        }
                    }
                    pool.awaitQuiescence(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
                    while ((future = service.poll()) != null) {
                        FaweChunk fc = (FaweChunk)future.get();
                        this.parent.end(fc);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            return !this.blocks.isEmpty();
        }
    }
}

