/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.example;

import com.boydti.fawe.FaweCache;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.example.NMSMappedFaweQueue;
import com.boydti.fawe.example.Relighter;
import com.boydti.fawe.object.FaweChunk;
import com.boydti.fawe.object.FaweQueue;
import com.boydti.fawe.object.IntegerTrio;
import com.boydti.fawe.object.RunnableVal;
import com.boydti.fawe.object.collection.BlockVectorSet;
import com.boydti.fawe.util.MathMan;
import com.boydti.fawe.util.TaskManager;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public class NMSRelighter
implements Relighter {
    private final NMSMappedFaweQueue queue;
    private final Map<Long, RelightSkyEntry> skyToRelight;
    private final Object present = new Object();
    private final Map<Long, Integer> chunksToSend;
    private final ConcurrentLinkedQueue<RelightSkyEntry> queuedSkyToRelight = new ConcurrentLinkedQueue();
    private final Map<Long, long[][][]> lightQueue;
    private final AtomicBoolean lightLock = new AtomicBoolean(false);
    private final ConcurrentHashMap<Long, long[][][]> concurrentLightQueue;
    private final int maxY;
    private volatile boolean relighting = false;
    public final IntegerTrio mutableBlockPos = new IntegerTrio();
    private static final int DISPATCH_SIZE = 64;
    private boolean removeFirst;

    public NMSRelighter(NMSMappedFaweQueue queue) {
        this.queue = queue;
        this.skyToRelight = new Long2ObjectOpenHashMap();
        this.lightQueue = new Long2ObjectOpenHashMap();
        this.chunksToSend = new Long2ObjectOpenHashMap();
        this.concurrentLightQueue = new ConcurrentHashMap();
        this.maxY = queue.getMaxY();
    }

    @Override
    public boolean isEmpty() {
        return this.skyToRelight.isEmpty() && this.lightQueue.isEmpty() && this.queuedSkyToRelight.isEmpty() && this.concurrentLightQueue.isEmpty();
    }

    @Override
    public synchronized void removeAndRelight(boolean sky) {
        this.removeFirst = true;
        this.fixLightingSafe(sky);
        this.removeFirst = false;
    }

    private void set(int x, int y, int z, long[][][] map) {
        long[] m2;
        Object m1 = map[z];
        if (m1 == null) {
            long[][] lArrayArray = new long[16][];
            map[z] = lArrayArray;
            m1 = lArrayArray;
        }
        if ((m2 = m1[x]) == null) {
            m1[x] = new long[4];
            m2 = m1[x];
        }
        int n = y >> 6;
        long l = m2[n] | 1L << y;
        m2[n] = l;
        long value = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLightUpdate(int x, int y, int z) {
        long index = MathMan.pairInt(x >> 4, z >> 4);
        if (this.lightLock.compareAndSet(false, true)) {
            Map<Long, long[][][]> map = this.lightQueue;
            synchronized (map) {
                try {
                    Object currentMap = this.lightQueue.get(index);
                    if (currentMap == null) {
                        currentMap = new long[16][][];
                        this.lightQueue.put(index, (long[][][])currentMap);
                    }
                    this.set(x & 0xF, y, z & 0xF, (long[][][])currentMap);
                }
                finally {
                    this.lightLock.set(false);
                }
            }
        }
        Object currentMap = this.concurrentLightQueue.get(index);
        if (currentMap == null) {
            currentMap = new long[16][][];
            this.concurrentLightQueue.put(index, (long[][][])currentMap);
        }
        this.set(x & 0xF, y, z & 0xF, (long[][][])currentMap);
    }

    @Override
    public synchronized void clear() {
        this.queuedSkyToRelight.clear();
        this.skyToRelight.clear();
        this.chunksToSend.clear();
        this.lightQueue.clear();
        this.concurrentLightQueue.clear();
    }

    @Override
    public boolean addChunk(int cx, int cz, byte[] fix, int bitmask) {
        RelightSkyEntry toPut = new RelightSkyEntry(cx, cz, fix, bitmask);
        this.queuedSkyToRelight.add(toPut);
        return true;
    }

    private synchronized Map<Long, RelightSkyEntry> getSkyMap() {
        RelightSkyEntry entry;
        while ((entry = this.queuedSkyToRelight.poll()) != null) {
            long pair = MathMan.pairInt(entry.x, entry.z);
            RelightSkyEntry existing = this.skyToRelight.put(pair, entry);
            if (existing == null) continue;
            entry.bitmask |= existing.bitmask;
            if (entry.fix == null) continue;
            for (int i = 0; i < entry.fix.length; ++i) {
                int n = i;
                entry.fix[n] = (byte)(entry.fix[n] & existing.fix[i]);
            }
        }
        return this.skyToRelight;
    }

    @Override
    public synchronized void removeLighting() {
        Iterator<Map.Entry<Long, RelightSkyEntry>> iter = this.getSkyMap().entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Long, RelightSkyEntry> entry = iter.next();
            RelightSkyEntry chunk = entry.getValue();
            long pair = entry.getKey();
            Integer existing = this.chunksToSend.get(pair);
            this.chunksToSend.put(pair, chunk.bitmask | (existing != null ? existing : 0));
            this.queue.ensureChunkLoaded(chunk.x, chunk.z);
            Object sections = this.queue.getCachedSections(this.queue.getWorld(), chunk.x, chunk.z);
            this.queue.removeLighting(sections, FaweQueue.RelightMode.ALL, this.queue.hasSky());
            iter.remove();
        }
    }

    public void updateBlockLight(Map<Long, long[][][]> map) {
        int size = map.size();
        if (size == 0) {
            return;
        }
        ArrayDeque<IntegerTrio> lightPropagationQueue = new ArrayDeque<IntegerTrio>();
        ArrayDeque<Object[]> lightRemovalQueue = new ArrayDeque<Object[]>();
        HashMap<IntegerTrio, Object> visited = new HashMap<IntegerTrio, Object>();
        HashMap<IntegerTrio, Object> removalVisited = new HashMap<IntegerTrio, Object>();
        Iterator<Map.Entry<Long, long[][][]>> iter = map.entrySet().iterator();
        while (iter.hasNext() && size-- > 0) {
            Map.Entry<Long, long[][][]> entry = iter.next();
            long index = entry.getKey();
            long[][][] blocks = entry.getValue();
            int chunkX = MathMan.unpairIntX(index);
            int chunkZ = MathMan.unpairIntY(index);
            int bx = chunkX << 4;
            int bz = chunkZ << 4;
            for (int lz = 0; lz < blocks.length; ++lz) {
                long[][] m1 = blocks[lz];
                if (m1 == null) continue;
                for (int lx = 0; lx < m1.length; ++lx) {
                    long[] m2 = m1[lx];
                    if (m2 == null) continue;
                    for (int i = 0; i < m2.length; ++i) {
                        int yStart = i << 6;
                        long value = m2[i];
                        if (value == 0L) continue;
                        for (int j = 0; j < 64; ++j) {
                            int newLevel;
                            int z;
                            int y;
                            int x;
                            int oldLevel;
                            if ((value >> j & 1L) != 1L || (oldLevel = this.queue.getEmmittedLight(x = lx + bx, y = yStart + j, z = lz + bz)) == (newLevel = this.queue.getBrightness(x, y, z))) continue;
                            this.queue.setBlockLight(x, y, z, newLevel);
                            IntegerTrio node = new IntegerTrio(x, y, z);
                            if (newLevel < oldLevel) {
                                removalVisited.put(node, this.present);
                                lightRemovalQueue.add(new Object[]{node, oldLevel});
                                continue;
                            }
                            visited.put(node, this.present);
                            lightPropagationQueue.add(node);
                        }
                    }
                }
            }
            iter.remove();
        }
        while (!lightRemovalQueue.isEmpty()) {
            Object[] val = (Object[])lightRemovalQueue.poll();
            IntegerTrio node = (IntegerTrio)val[0];
            int lightLevel = (Integer)val[1];
            this.computeRemoveBlockLight(node.x - 1, node.y, node.z, lightLevel, lightRemovalQueue, lightPropagationQueue, removalVisited, visited);
            this.computeRemoveBlockLight(node.x + 1, node.y, node.z, lightLevel, lightRemovalQueue, lightPropagationQueue, removalVisited, visited);
            if (node.y > 0) {
                this.computeRemoveBlockLight(node.x, node.y - 1, node.z, lightLevel, lightRemovalQueue, lightPropagationQueue, removalVisited, visited);
            }
            if (node.y < 255) {
                this.computeRemoveBlockLight(node.x, node.y + 1, node.z, lightLevel, lightRemovalQueue, lightPropagationQueue, removalVisited, visited);
            }
            this.computeRemoveBlockLight(node.x, node.y, node.z - 1, lightLevel, lightRemovalQueue, lightPropagationQueue, removalVisited, visited);
            this.computeRemoveBlockLight(node.x, node.y, node.z + 1, lightLevel, lightRemovalQueue, lightPropagationQueue, removalVisited, visited);
        }
        while (!lightPropagationQueue.isEmpty()) {
            IntegerTrio node = (IntegerTrio)lightPropagationQueue.poll();
            int lightLevel = this.queue.getEmmittedLight(node.x, node.y, node.z);
            if (lightLevel <= 1) continue;
            this.computeSpreadBlockLight(node.x - 1, node.y, node.z, lightLevel, lightPropagationQueue, visited);
            this.computeSpreadBlockLight(node.x + 1, node.y, node.z, lightLevel, lightPropagationQueue, visited);
            if (node.y > 0) {
                this.computeSpreadBlockLight(node.x, node.y - 1, node.z, lightLevel, lightPropagationQueue, visited);
            }
            if (node.y < 255) {
                this.computeSpreadBlockLight(node.x, node.y + 1, node.z, lightLevel, lightPropagationQueue, visited);
            }
            this.computeSpreadBlockLight(node.x, node.y, node.z - 1, lightLevel, lightPropagationQueue, visited);
            this.computeSpreadBlockLight(node.x, node.y, node.z + 1, lightLevel, lightPropagationQueue, visited);
        }
    }

    private void computeRemoveBlockLight(int x, int y, int z, int currentLight, Queue<Object[]> queue, Queue<IntegerTrio> spreadQueue, Map<IntegerTrio, Object> visited, Map<IntegerTrio, Object> spreadVisited) {
        int current = this.queue.getEmmittedLight(x, y, z);
        if (current != 0 && current < currentLight) {
            this.queue.setBlockLight(x, y, z, 0);
            if (current > 1 && !visited.containsKey(this.mutableBlockPos)) {
                IntegerTrio index = new IntegerTrio(x, y, z);
                visited.put(index, this.present);
                queue.add(new Object[]{index, current});
            }
        } else if (current >= currentLight) {
            this.mutableBlockPos.set(x, y, z);
            if (!spreadVisited.containsKey(this.mutableBlockPos)) {
                IntegerTrio index = new IntegerTrio(x, y, z);
                spreadVisited.put(index, this.present);
                spreadQueue.add(index);
            }
        }
    }

    private void computeSpreadBlockLight(int x, int y, int z, int currentLight, Queue<IntegerTrio> queue, Map<IntegerTrio, Object> visited) {
        int current;
        if ((currentLight -= Math.max(1, this.queue.getOpacity(x, y, z))) > 0 && (current = this.queue.getEmmittedLight(x, y, z)) < currentLight) {
            this.queue.setBlockLight(x, y, z, currentLight);
            this.mutableBlockPos.set(x, y, z);
            if (!visited.containsKey(this.mutableBlockPos)) {
                visited.put(new IntegerTrio(x, y, z), this.present);
                if (currentLight > 1) {
                    queue.add(new IntegerTrio(x, y, z));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fixLightingSafe(boolean sky) {
        if (this.isEmpty()) {
            return;
        }
        try {
            if (sky) {
                this.fixSkyLighting();
            } else {
                NMSRelighter nMSRelighter = this;
                synchronized (nMSRelighter) {
                    Map<Long, RelightSkyEntry> map = this.getSkyMap();
                    Iterator<Map.Entry<Long, RelightSkyEntry>> iter = map.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry<Long, RelightSkyEntry> entry = iter.next();
                        this.chunksToSend.put(entry.getKey(), entry.getValue().bitmask);
                        iter.remove();
                    }
                }
            }
            this.fixBlockLighting();
            this.sendChunks();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fixBlockLighting() {
        Map<Long, long[][][]> map = this.lightQueue;
        synchronized (map) {
            while (!this.lightLock.compareAndSet(false, true)) {
            }
            try {
                this.updateBlockLight(this.lightQueue);
            }
            finally {
                this.lightLock.set(false);
            }
        }
    }

    public synchronized void sendChunks() {
        RunnableVal<Object> runnable = new RunnableVal<Object>(){

            @Override
            public void run(Object value) {
                Iterator iter = NMSRelighter.this.chunksToSend.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    long pair = (Long)entry.getKey();
                    int bitMask = (Integer)entry.getValue();
                    int x = MathMan.unpairIntX(pair);
                    int z = MathMan.unpairIntY(pair);
                    NMSRelighter.this.queue.sendChunk(x, z, bitMask);
                    iter.remove();
                }
            }
        };
        if (Settings.IMP.LIGHTING.ASYNC) {
            runnable.run();
        } else {
            TaskManager.IMP.sync(runnable);
        }
    }

    private boolean isTransparent(int x, int y, int z) {
        return this.queue.getOpacity(x, y, z) < 15;
    }

    @Override
    public synchronized void fixSkyLighting() {
        Map<Long, RelightSkyEntry> map = this.getSkyMap();
        ArrayList<RelightSkyEntry> chunksList = new ArrayList<RelightSkyEntry>(map.size());
        Iterator<Map.Entry<Long, RelightSkyEntry>> iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Long, RelightSkyEntry> entry = iter.next();
            this.chunksToSend.put(entry.getKey(), entry.getValue().bitmask);
            chunksList.add(entry.getValue());
            iter.remove();
        }
        Collections.sort(chunksList);
        int size = chunksList.size();
        if (size > 64) {
            int amount = (size + 64 - 1) / 64;
            for (int i = 0; i < amount; ++i) {
                int start = i * 64;
                int end = Math.min(size, start + 64);
                List<RelightSkyEntry> sub = chunksList.subList(start, end);
                this.fixSkyLighting(sub);
            }
        } else {
            this.fixSkyLighting(chunksList);
        }
    }

    public void fill(byte[] mask, int chunkX, int y, int chunkZ, byte reason) {
        if (y >= FaweChunk.HEIGHT) {
            Arrays.fill(mask, (byte)15);
            return;
        }
        switch (reason) {
            case 2: {
                Arrays.fill(mask, (byte)0);
                return;
            }
            case 1: {
                int bx = chunkX << 4;
                int bz = chunkZ << 4;
                int index = 0;
                for (int z = 0; z < 16; ++z) {
                    for (int x = 0; x < 16; ++x) {
                        mask[index++] = (byte)this.queue.getSkyLight(bx + x, y, bz + z);
                    }
                }
                break;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void fixSkyLighting(List<RelightSkyEntry> sorted) {
        RelightSkyEntry[] chunks = sorted.toArray(new RelightSkyEntry[sorted.size()]);
        boolean remove = this.removeFirst;
        BlockVectorSet chunkSet = null;
        if (remove) {
            chunkSet = new BlockVectorSet();
            BlockVectorSet tmpSet = new BlockVectorSet();
            for (RelightSkyEntry chunk : chunks) {
                tmpSet.add(chunk.x, 0, chunk.z);
            }
            for (RelightSkyEntry chunk : chunks) {
                int x = chunk.x;
                int z = chunk.z;
                if (!tmpSet.contains(x + 1, 0, z) || !tmpSet.contains(x - 1, 0, z) || !tmpSet.contains(x, 0, z + 1) || !tmpSet.contains(x, 0, z - 1)) continue;
                chunkSet.add(x, 0, z);
            }
        }
        byte[] cacheX = FaweCache.CACHE_X[0];
        byte[] cacheZ = FaweCache.CACHE_Z[0];
        int y = FaweChunk.HEIGHT - 1;
        block7: while (y > 0) {
            RelightSkyEntry[] relightSkyEntryArray = chunks;
            int chunk = relightSkyEntryArray.length;
            int n = 0;
            while (true) {
                block21: {
                    Object section;
                    Object chunkObj;
                    int bz;
                    int bx;
                    byte[] mask;
                    block22: {
                        block19: {
                            int layer;
                            RelightSkyEntry chunk2;
                            block20: {
                                if (n >= chunk) break block19;
                                chunk2 = relightSkyEntryArray[n];
                                layer = y >> 4;
                                mask = chunk2.mask;
                                if (chunk2.fix[layer] == 0) break block20;
                                if ((y & 0xF) == 0 && layer != 0 && chunk2.fix[layer - 1] == 0) {
                                    this.fill(mask, chunk2.x, y, chunk2.z, chunk2.fix[layer]);
                                }
                                break block21;
                            }
                            bx = chunk2.x << 4;
                            bz = chunk2.z << 4;
                            chunkObj = this.queue.ensureChunkLoaded(chunk2.x, chunk2.z);
                            Object sections = this.queue.getCachedSections(this.queue.getWorld(), chunk2.x, chunk2.z);
                            if (sections == null || (section = this.queue.getCachedSection(sections, layer)) == null) break block21;
                            chunk2.smooth = false;
                            if (!remove || (y & 0xF) != 15 || !chunkSet.contains(chunk2.x, 0, chunk2.z)) break block22;
                            this.queue.removeSectionLighting(section, y >> 4, true);
                            break block22;
                        }
                        for (RelightSkyEntry chunk2 : chunks) {
                            if (!chunk2.smooth) continue;
                            this.smoothSkyLight(chunk2, y, true);
                        }
                        for (int i = chunks.length - 1; i >= 0; --i) {
                            RelightSkyEntry chunk3 = chunks[i];
                            if (!chunk3.smooth) continue;
                            this.smoothSkyLight(chunk3, y, false);
                        }
                        --y;
                        continue block7;
                    }
                    block11: for (int j = 0; j <= this.maxY; ++j) {
                        byte x = cacheX[j];
                        byte z = cacheZ[j];
                        byte value = mask[j];
                        byte pair = (byte)this.queue.getOpacityBrightnessPair(section, x, y, z);
                        byte opacity = MathMan.unpair16x(pair);
                        byte brightness = MathMan.unpair16y(pair);
                        if (brightness > 1 && (brightness != 15 || opacity != 15)) {
                            this.addLightUpdate(bx + x, y, bz + z);
                        }
                        switch (value) {
                            case 0: {
                                if (opacity <= 1) break;
                                this.queue.setSkyLight(section, x, y, z, 0);
                                continue block11;
                            }
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 10: 
                            case 11: 
                            case 12: 
                            case 13: 
                            case 14: {
                                if (opacity >= value) {
                                    mask[j] = 0;
                                    this.queue.setSkyLight(section, x, y, z, 0);
                                    continue block11;
                                }
                                if (opacity <= 1) {
                                    mask[j] = value = (byte)(value - 1);
                                    break;
                                }
                                mask[j] = value = (byte)Math.max(0, value - opacity);
                                break;
                            }
                            case 15: {
                                if (opacity > 1) {
                                    mask[j] = value = (byte)(value - opacity);
                                }
                                this.queue.setSkyLight(section, x, y, z, value);
                                continue block11;
                            }
                        }
                        chunk2.smooth = true;
                        this.queue.setSkyLight(section, x, y, z, value);
                    }
                    this.queue.saveChunk(chunkObj);
                }
                ++n;
            }
            break;
        }
        return;
    }

    public void smoothSkyLight(RelightSkyEntry chunk, int y, boolean direction) {
        byte[] mask = chunk.mask;
        int bx = chunk.x << 4;
        int bz = chunk.z << 4;
        this.queue.ensureChunkLoaded(chunk.x, chunk.z);
        Object sections = this.queue.getCachedSections(this.queue.getWorld(), chunk.x, chunk.z);
        if (sections == null) {
            return;
        }
        Object section = this.queue.getCachedSection(sections, y >> 4);
        if (section == null) {
            return;
        }
        if (direction) {
            for (int j = 0; j < 256; ++j) {
                int x = j & 0xF;
                int z = j >> 4;
                if (mask[j] >= 14 || mask[j] == 0 && this.queue.getOpacity(section, x, y, z) > 1) continue;
                byte value = mask[j];
                value = (byte)Math.max(this.queue.getSkyLight(bx + x - 1, y, bz + z) - 1, value);
                if (value >= 14 || (value = (byte)Math.max(this.queue.getSkyLight(bx + x, y, bz + z - 1) - 1, value)) >= 14) {
                    // empty if block
                }
                if (value <= mask[j]) continue;
                mask[j] = value;
                this.queue.setSkyLight(section, x, y, z, mask[j]);
            }
        } else {
            for (int j = 255; j >= 0; --j) {
                int x = j & 0xF;
                int z = j >> 4;
                if (mask[j] >= 14 || mask[j] == 0 && this.queue.getOpacity(section, x, y, z) > 1) continue;
                byte value = mask[j];
                value = (byte)Math.max(this.queue.getSkyLight(bx + x + 1, y, bz + z) - 1, value);
                if (value >= 14 || (value = (byte)Math.max(this.queue.getSkyLight(bx + x, y, bz + z + 1) - 1, value)) >= 14) {
                    // empty if block
                }
                if (value <= mask[j]) continue;
                mask[j] = value;
                this.queue.setSkyLight(section, x, y, z, mask[j]);
            }
        }
    }

    public boolean isUnlit(byte[] array) {
        for (byte val : array) {
            if (val == 0) continue;
            return false;
        }
        return true;
    }

    private class RelightSkyEntry
    implements Comparable {
        public final int x;
        public final int z;
        public final byte[] mask;
        public final byte[] fix;
        public int bitmask;
        public boolean smooth;

        public RelightSkyEntry(int x, int z, byte[] fix, int bitmask) {
            this.x = x;
            this.z = z;
            byte[] array = new byte[256];
            Arrays.fill(array, (byte)15);
            this.mask = array;
            this.bitmask = bitmask;
            if (fix == null) {
                this.fix = new byte[NMSRelighter.this.maxY + 1 >> 4];
                Arrays.fill(this.fix, (byte)0);
            } else {
                this.fix = fix;
            }
        }

        public String toString() {
            return this.x + "," + this.z;
        }

        public int compareTo(Object o) {
            RelightSkyEntry other = (RelightSkyEntry)o;
            if (other.x < this.x) {
                return 1;
            }
            if (other.x > this.x) {
                return -1;
            }
            if (other.z < this.z) {
                return 1;
            }
            if (other.z > this.z) {
                return -1;
            }
            return 0;
        }
    }
}

