/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.example;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.example.IFaweQueueMap;
import com.boydti.fawe.example.MappedFaweQueue;
import com.boydti.fawe.object.FaweChunk;
import com.boydti.fawe.object.FaweQueue;
import com.boydti.fawe.object.RunnableVal;
import com.boydti.fawe.util.MathMan;
import com.boydti.fawe.util.SetQueue;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class WeakFaweQueueMap
implements IFaweQueueMap {
    private final MappedFaweQueue parent;
    public final Long2ObjectOpenHashMap<Reference<FaweChunk>> blocks = new Long2ObjectOpenHashMap<Reference<FaweChunk>>(){

        public Reference<FaweChunk> put(Long key, Reference<FaweChunk> value) {
            return this.put((long)key, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Reference<FaweChunk> put(long key, Reference<FaweChunk> value) {
            if (WeakFaweQueueMap.this.parent.getProgressTask() != null) {
                try {
                    WeakFaweQueueMap.this.parent.getProgressTask().run(FaweQueue.ProgressType.QUEUE, this.size());
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            1 var4_4 = this;
            synchronized (var4_4) {
                return (Reference)super.put(key, value);
            }
        }
    };
    private FaweChunk lastWrappedChunk;
    private int lastX = Integer.MIN_VALUE;
    private int lastZ = Integer.MIN_VALUE;

    public WeakFaweQueueMap(MappedFaweQueue parent) {
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<FaweChunk> getFaweCunks() {
        HashSet<FaweChunk> set = new HashSet<FaweChunk>();
        Long2ObjectOpenHashMap<Reference<FaweChunk>> long2ObjectOpenHashMap = this.blocks;
        synchronized (long2ObjectOpenHashMap) {
            ObjectIterator iter = this.blocks.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                FaweChunk value = (FaweChunk)((Reference)entry.getValue()).get();
                if (value != null) {
                    set.add(value);
                    continue;
                }
                Fawe.debug("Skipped modifying chunk due to low memory (1)");
                iter.remove();
            }
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEachChunk(RunnableVal<FaweChunk> onEach) {
        Long2ObjectOpenHashMap<Reference<FaweChunk>> long2ObjectOpenHashMap = this.blocks;
        synchronized (long2ObjectOpenHashMap) {
            ObjectIterator iter = this.blocks.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                FaweChunk value = (FaweChunk)((Reference)entry.getValue()).get();
                if (value != null) {
                    onEach.run(value);
                    continue;
                }
                Fawe.debug("Skipped modifying chunk due to low memory (2)");
                iter.remove();
            }
        }
    }

    @Override
    public FaweChunk getFaweChunk(int cx, int cz) {
        FaweChunk tmp;
        Reference previous;
        FaweChunk chunk;
        if (cx == this.lastX && cz == this.lastZ) {
            return this.lastWrappedChunk;
        }
        long pair = MathMan.pairInt(cx, cz);
        Reference chunkReference = (Reference)this.blocks.get(pair);
        if ((chunkReference == null || (chunk = (FaweChunk)chunkReference.get()) == null) && (previous = (Reference)this.blocks.put(pair, new SoftReference<FaweChunk>(chunk = this.getNewFaweChunk(cx, cz)))) != null && (tmp = (FaweChunk)previous.get()) != null) {
            chunk = tmp;
            this.blocks.put(pair, (Object)previous);
        }
        return chunk;
    }

    @Override
    public FaweChunk getCachedFaweChunk(int cx, int cz) {
        if (cx == this.lastX && cz == this.lastZ) {
            return this.lastWrappedChunk;
        }
        long pair = MathMan.pairInt(cx, cz);
        Reference reference = (Reference)this.blocks.get(pair);
        if (reference != null) {
            return (FaweChunk)reference.get();
        }
        return null;
    }

    @Override
    public void add(FaweChunk chunk) {
        FaweChunk previousChunk;
        long pair = MathMan.pairInt(chunk.getX(), chunk.getZ());
        Reference previous = (Reference)this.blocks.put(pair, new SoftReference<FaweChunk>(chunk));
        if (previous != null && (previousChunk = (FaweChunk)previous.get()) != null) {
            this.blocks.put(pair, (Object)previous);
        }
    }

    @Override
    public void clear() {
        this.blocks.clear();
    }

    @Override
    public int size() {
        return this.blocks.size();
    }

    private FaweChunk getNewFaweChunk(int cx, int cz) {
        return this.parent.getFaweChunk(cx, cz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean next(int amount, long time) {
        Long2ObjectOpenHashMap<Reference<FaweChunk>> long2ObjectOpenHashMap = this.blocks;
        synchronized (long2ObjectOpenHashMap) {
            try {
                Future future;
                boolean skip = this.parent.getStage() == SetQueue.QueueStage.INACTIVE;
                int added = 0;
                ObjectIterator iter = this.blocks.entrySet().iterator();
                if (amount == 1) {
                    long start = System.currentTimeMillis();
                    while (iter.hasNext()) {
                        Map.Entry entry = (Map.Entry)iter.next();
                        Reference chunkReference = (Reference)entry.getValue();
                        FaweChunk chunk = (FaweChunk)chunkReference.get();
                        if (!skip || chunk != this.lastWrappedChunk) {
                            iter.remove();
                            if (chunk != null) {
                                this.parent.start(chunk);
                                chunk.call();
                                this.parent.end(chunk);
                            } else {
                                Fawe.debug("Skipped modifying chunk due to low memory (3)");
                            }
                        }
                        if (System.currentTimeMillis() - start < time) continue;
                    }
                    return !this.blocks.isEmpty();
                }
                ExecutorCompletionService service = SetQueue.IMP.getCompleterService();
                ForkJoinPool pool = SetQueue.IMP.getForkJoinPool();
                boolean result = true;
                int i = 0;
                while (i < amount && (result = iter.hasNext())) {
                    Map.Entry item = (Map.Entry)iter.next();
                    Reference chunkReference = (Reference)item.getValue();
                    FaweChunk chunk = (FaweChunk)chunkReference.get();
                    if (skip && chunk == this.lastWrappedChunk) continue;
                    iter.remove();
                    if (chunk != null) {
                        this.parent.start(chunk);
                        service.submit(chunk);
                        ++added;
                        ++i;
                        continue;
                    }
                    Fawe.debug("Skipped modifying chunk due to low memory (4)");
                }
                if (result) {
                    long start = System.currentTimeMillis();
                    while (System.currentTimeMillis() - start < time && result) {
                        result = iter.hasNext();
                        if (!result) continue;
                        Map.Entry item = (Map.Entry)iter.next();
                        Reference chunkReference = (Reference)item.getValue();
                        FaweChunk chunk = (FaweChunk)chunkReference.get();
                        if (skip && chunk == this.lastWrappedChunk) continue;
                        iter.remove();
                        if (chunk == null) continue;
                        this.parent.start(chunk);
                        service.submit(chunk);
                        Future future2 = service.poll(50L, TimeUnit.MILLISECONDS);
                        if (future2 == null) continue;
                        FaweChunk fc = (FaweChunk)future2.get();
                        this.parent.end(fc);
                    }
                }
                pool.awaitQuiescence(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
                while ((future = service.poll()) != null) {
                    FaweChunk fc = (FaweChunk)future.get();
                    this.parent.end(fc);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            return !this.blocks.isEmpty();
        }
    }
}

