/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.installer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JFileChooser;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import sun.swing.FilePane;

public class JSystemFileChooser
extends JFileChooser {
    @Override
    public void updateUI() {
        LookAndFeel old = UIManager.getLookAndFeel();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Throwable ex) {
            old = null;
        }
        super.updateUI();
        if (old != null) {
            FilePane filePane = JSystemFileChooser.findFilePane(this);
            filePane.setViewType(1);
            filePane.setViewType(0);
            Color background = UIManager.getColor("Label.background");
            this.setBackground(background);
            this.setOpaque(true);
            try {
                UIManager.setLookAndFeel(old);
            }
            catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                // empty catch block
            }
        }
    }

    private static FilePane findFilePane(Container parent) {
        for (Component comp : parent.getComponents()) {
            FilePane found;
            Container cont;
            if (FilePane.class.isInstance(comp)) {
                return (FilePane)comp;
            }
            if (!(comp instanceof Container) || (cont = (Container)comp).getComponentCount() <= 0 || (found = JSystemFileChooser.findFilePane(cont)) == null) continue;
            return found;
        }
        return null;
    }
}

