/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.jnbt.anvil;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.FaweCache;
import com.boydti.fawe.example.SimpleIntFaweChunk;
import com.boydti.fawe.jnbt.anvil.HeightMapMCADrawer;
import com.boydti.fawe.jnbt.anvil.MCAChunk;
import com.boydti.fawe.jnbt.anvil.MCAWriter;
import com.boydti.fawe.object.FaweChunk;
import com.boydti.fawe.object.FaweInputStream;
import com.boydti.fawe.object.FaweLocation;
import com.boydti.fawe.object.FaweOutputStream;
import com.boydti.fawe.object.FawePlayer;
import com.boydti.fawe.object.FaweQueue;
import com.boydti.fawe.object.Metadatable;
import com.boydti.fawe.object.PseudoRandom;
import com.boydti.fawe.object.RunnableVal2;
import com.boydti.fawe.object.brush.visualization.VirtualWorld;
import com.boydti.fawe.object.change.StreamChange;
import com.boydti.fawe.object.changeset.CFIChangeSet;
import com.boydti.fawe.object.collection.DifferentialArray;
import com.boydti.fawe.object.collection.DifferentialBlockBuffer;
import com.boydti.fawe.object.collection.IterableThreadLocal;
import com.boydti.fawe.object.collection.LocalBlockVector2DSet;
import com.boydti.fawe.object.collection.SummedAreaTable;
import com.boydti.fawe.object.exception.FaweException;
import com.boydti.fawe.object.queue.LazyFaweChunk;
import com.boydti.fawe.object.schematic.Schematic;
import com.boydti.fawe.util.CachedTextureUtil;
import com.boydti.fawe.util.RandomTextureUtil;
import com.boydti.fawe.util.ReflectionUtils;
import com.boydti.fawe.util.SetQueue;
import com.boydti.fawe.util.TaskManager;
import com.boydti.fawe.util.TextureUtil;
import com.boydti.fawe.util.image.Drawable;
import com.boydti.fawe.util.image.ImageViewer;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.MutableBlockVector;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.Vector2D;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.transform.AffineTransform;
import com.sk89q.worldedit.math.transform.Transform;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.session.ClipboardHolder;
import com.sk89q.worldedit.util.TreeGenerator;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BaseBiome;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;

public class HeightMapMCAGenerator
extends MCAWriter
implements StreamChange,
Drawable,
VirtualWorld {
    private final MutableBlockVector mutable = new MutableBlockVector();
    private final ThreadLocal<int[]> indexStore = new ThreadLocal<int[]>(){

        @Override
        protected int[] initialValue() {
            return new int[256];
        }
    };
    private final DifferentialBlockBuffer blocks;
    protected final DifferentialArray<byte[]> heights;
    protected final DifferentialArray<byte[]> biomes;
    protected final DifferentialArray<int[]> floor;
    protected final DifferentialArray<int[]> main;
    protected DifferentialArray<int[]> overlay;
    protected final CFIPrimtives primtives = new CFIPrimtives();
    private CFIPrimtives oldPrimitives = new CFIPrimtives();
    protected Metadatable metaData = new Metadatable();
    protected TextureUtil textureUtil;
    private ImageViewer viewer;
    private FawePlayer player;
    private Vector2D chunkOffset = Vector2D.ZERO;
    private EditSession editSession;

    @Override
    public void flushChanges(FaweOutputStream out) throws IOException {
        this.heights.flushChanges(out);
        this.biomes.flushChanges(out);
        this.floor.flushChanges(out);
        this.main.flushChanges(out);
        out.writeBoolean(this.overlay != null);
        if (this.overlay != null) {
            this.overlay.flushChanges(out);
        }
        try {
            for (Field field : ReflectionUtils.sortFields(CFIPrimtives.class.getDeclaredFields())) {
                Object now = field.get(this.primtives);
                Object old = field.get(this.oldPrimitives);
                boolean diff = old != now;
                out.writeBoolean(diff);
                if (!diff) continue;
                out.writePrimitive(old);
                out.writePrimitive(now);
            }
            this.resetPrimtives();
        }
        catch (Throwable neverHappens) {
            neverHappens.printStackTrace();
        }
        this.blocks.flushChanges(out);
    }

    public boolean isModified() {
        return this.blocks.isModified() || this.heights.isModified() || this.biomes.isModified() || this.overlay != null && this.overlay.isModified() || !this.primtives.equals(this.oldPrimitives);
    }

    private void resetPrimtives() throws CloneNotSupportedException {
        this.oldPrimitives = (CFIPrimtives)this.primtives.clone();
    }

    @Override
    public void undoChanges(FaweInputStream in) throws IOException {
        this.heights.undoChanges(in);
        this.biomes.undoChanges(in);
        this.floor.undoChanges(in);
        this.main.undoChanges(in);
        if (in.readBoolean()) {
            this.overlay.undoChanges(in);
        }
        try {
            for (Field field : ReflectionUtils.sortFields(CFIPrimtives.class.getDeclaredFields())) {
                if (!in.readBoolean()) continue;
                field.set(this.primtives, in.readPrimitive(field.getType()));
                in.readPrimitive(field.getType());
            }
            this.resetPrimtives();
        }
        catch (Throwable neverHappens) {
            neverHappens.printStackTrace();
        }
        this.blocks.undoChanges(in);
    }

    @Override
    public void redoChanges(FaweInputStream in) throws IOException {
        this.heights.redoChanges(in);
        this.biomes.redoChanges(in);
        this.floor.redoChanges(in);
        this.main.redoChanges(in);
        if (in.readBoolean()) {
            this.overlay.redoChanges(in);
        }
        try {
            for (Field field : ReflectionUtils.sortFields(CFIPrimtives.class.getDeclaredFields())) {
                if (!in.readBoolean()) continue;
                in.readPrimitive(field.getType());
                field.set(this.primtives, in.readPrimitive(field.getType()));
            }
            this.resetPrimtives();
        }
        catch (Throwable neverHappens) {
            neverHappens.printStackTrace();
        }
        this.blocks.clearChanges();
    }

    @Override
    public void addEditSession(EditSession session) {
        session.setFastMode(true);
        this.editSession = session;
    }

    @Override
    public boolean supports(FaweQueue.Capability capability) {
        return false;
    }

    public HeightMapMCAGenerator(BufferedImage img, File regionFolder) {
        this(img.getWidth(), img.getHeight(), regionFolder);
        this.setHeight(img);
    }

    public HeightMapMCAGenerator(int width, int length, File regionFolder) {
        super(width, length, regionFolder);
        int area = this.getArea();
        this.blocks = new DifferentialBlockBuffer(width, length);
        this.heights = new DifferentialArray<byte[]>(new byte[this.getArea()]);
        this.biomes = new DifferentialArray<byte[]>(new byte[this.getArea()]);
        this.floor = new DifferentialArray<int[]>(new int[this.getArea()]);
        this.main = new DifferentialArray<int[]>(new int[this.getArea()]);
        int stone = BlockTypes.STONE.getInternalId();
        int grass = BlockTypes.GRASS_BLOCK.getInternalId();
        Arrays.fill(this.main.getIntArray(), stone);
        Arrays.fill(this.floor.getIntArray(), grass);
    }

    public Metadatable getMetaData() {
        return this.metaData;
    }

    @Override
    public FaweQueue getQueue() {
        throw new UnsupportedOperationException("Not supported: Queue is not backed by a real world");
    }

    @Override
    public Vector getOrigin() {
        return new BlockVector(this.chunkOffset.getBlockX() << 4, 0, this.chunkOffset.getBlockZ() << 4);
    }

    public boolean hasPacketViewer() {
        return this.player != null;
    }

    public void setPacketViewer(FawePlayer player) {
        this.player = player;
        if (player != null) {
            FaweLocation pos = player.getLocation();
            this.chunkOffset = new Vector2D(1 + (pos.x >> 4), 1 + (pos.z >> 4));
        }
    }

    public FawePlayer getOwner() {
        return this.player;
    }

    private int[][][] getChunkArray(int x, int z) {
        int[][][][][] blocksData = this.blocks.get();
        if (blocksData == null) {
            return null;
        }
        int[][][][] arr = blocksData[z];
        return arr != null ? arr[x] : (int[][][])null;
    }

    public void setImageViewer(ImageViewer viewer) {
        this.viewer = viewer;
    }

    public ImageViewer getImageViewer() {
        return this.viewer;
    }

    @Override
    public void update() {
        if (this.viewer != null) {
            this.viewer.view(this);
        }
        if (this.chunkOffset != null && this.player != null) {
            FaweQueue packetQueue = SetQueue.IMP.getNewQueue(this.player.getWorld(), true, false);
            if (!packetQueue.supports(FaweQueue.Capability.CHUNK_PACKETS)) {
                return;
            }
            int lenCX = this.getWidth() + 15 >> 4;
            int lenCZ = this.getLength() + 15 >> 4;
            int OX = this.chunkOffset.getBlockX();
            int OZ = this.chunkOffset.getBlockZ();
            FaweLocation position = this.player.getLocation();
            int pcx = (position.x >> 4) - OX;
            int pcz = (position.z >> 4) - OZ;
            int scx = Math.max(0, pcx - 15);
            int scz = Math.max(0, pcz - 15);
            int ecx = Math.min(lenCX - 1, pcx + 15);
            int ecz = Math.min(lenCZ - 1, pcz + 15);
            MCAChunk chunk = new MCAChunk(this, 0, 0);
            for (int cz = scz; cz <= ecz; ++cz) {
                int cx = scx;
                while (cx <= ecx) {
                    int finalCX = cx++;
                    int finalCZ = cz;
                    TaskManager.IMP.getPublicForkJoinPool().submit(() -> {
                        try {
                            FaweChunk toSend = this.getSnapshot(finalCX, finalCZ);
                            toSend.setLoc(this, finalCX + OX, finalCZ + OZ);
                            packetQueue.sendChunkUpdate(toSend, this.player);
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    });
                }
            }
        }
    }

    public TextureUtil getRawTextureUtil() {
        if (this.textureUtil == null) {
            this.textureUtil = Fawe.get().getTextureUtil();
        }
        return this.textureUtil;
    }

    public TextureUtil getTextureUtil() {
        if (this.textureUtil == null) {
            this.textureUtil = Fawe.get().getTextureUtil();
        }
        try {
            if (this.primtives.randomVariation) {
                return new RandomTextureUtil(this.textureUtil);
            }
            if (this.textureUtil instanceof CachedTextureUtil) {
                return this.textureUtil;
            }
            return new CachedTextureUtil(this.textureUtil);
        }
        catch (FileNotFoundException neverHappens) {
            neverHappens.printStackTrace();
            return null;
        }
    }

    public void setBedrockId(int bedrockId) {
        this.primtives.bedrockId = bedrockId;
    }

    public void setFloorThickness(int floorThickness) {
        this.primtives.floorThickness = floorThickness;
    }

    public void setWorldThickness(int height) {
        this.primtives.worldThickness = height;
    }

    public void setWaterHeight(int waterHeight) {
        this.primtives.waterHeight = waterHeight;
    }

    public void setWaterId(int waterId) {
        this.primtives.waterId = waterId;
    }

    public void setTextureRandomVariation(boolean randomVariation) {
        this.primtives.randomVariation = randomVariation;
    }

    public boolean getTextureRandomVariation() {
        return this.primtives.randomVariation;
    }

    public void setTextureUtil(TextureUtil textureUtil) {
        this.textureUtil = textureUtil;
    }

    public void smooth(BufferedImage img, boolean white, int radius, int iterations) {
        this.smooth(img, null, white, radius, iterations);
    }

    public void smooth(Mask mask, int radius, int iterations) {
        this.smooth(null, mask, false, radius, iterations);
    }

    public void smooth(Vector2D min, Vector2D max, int radius, int iterations) {
        int snowLayer = BlockTypes.SNOW.getInternalId();
        int snowBlock = BlockTypes.SNOW_BLOCK.getInternalId();
        int[] floor = this.floor.get();
        byte[] heights = this.heights.get();
        int width = this.getWidth();
        int length = this.getLength();
        int minX = min.getBlockX();
        int minZ = min.getBlockZ();
        int maxX = max.getBlockX();
        int maxZ = max.getBlockZ();
        int tableWidth = maxX - minX + 1;
        int tableLength = maxZ - minZ + 1;
        int smoothArea = tableWidth * tableLength;
        long[] copy = new long[smoothArea];
        char[] layers = new char[smoothArea];
        SummedAreaTable table = new SummedAreaTable(copy, layers, tableWidth, radius);
        for (int j = 0; j < iterations; ++j) {
            int localIndex = 0;
            int zIndex = minZ * this.getWidth();
            int z = minZ;
            while (z <= maxZ) {
                int index = zIndex + minX;
                int x = minX;
                while (x <= maxX) {
                    int combined = floor[index];
                    layers[localIndex] = BlockTypes.getFromStateId(combined) == BlockTypes.SNOW ? (char)(((heights[index] & 0xFF) << 3) + (floor[index] >> BlockTypes.BIT_OFFSET) - 7) : (char)((heights[index] & 0xFF) << 3);
                    ++x;
                    ++index;
                    ++localIndex;
                }
                ++z;
                zIndex += this.getWidth();
            }
            table.processSummedAreaTable();
            localIndex = 0;
            zIndex = minZ * this.getWidth();
            z = minZ;
            int localZ = 0;
            while (z <= maxZ) {
                int index = zIndex + minX;
                int x = minX;
                int localX = 0;
                while (x <= maxX) {
                    int y = heights[index] & 0xFF;
                    int newHeight = table.average(localX, localZ, localIndex);
                    this.setLayerHeight(index, newHeight);
                    ++x;
                    ++localX;
                    ++index;
                    ++localIndex;
                }
                ++z;
                ++localZ;
                zIndex += this.getWidth();
            }
        }
    }

    private final void setLayerHeight(int index, int height) {
        int blockHeight = height >> 3;
        int layerHeight = height & 7;
        this.setLayerHeight(index, blockHeight, layerHeight);
    }

    private final void setLayerHeight(int index, int blockHeight, int layerHeight) {
        int floorState = this.floor.get()[index];
        switch (BlockTypes.getFromStateId(floorState)) {
            case SNOW: 
            case SNOW_BLOCK: {
                if (layerHeight != 0) {
                    this.heights.setByte(index, (byte)(blockHeight + 1));
                    this.floor.setInt(index, BlockTypes.SNOW.getInternalId() + layerHeight);
                    break;
                }
                this.heights.setByte(index, (byte)blockHeight);
                this.floor.setInt(index, BlockTypes.SNOW_BLOCK.getInternalId());
                break;
            }
            default: {
                this.heights.setByte(index, (byte)blockHeight);
            }
        }
    }

    private final void setLayerHeightRaw(int index, int height) {
        int blockHeight = height >> 3;
        int layerHeight = height & 7;
        this.setLayerHeightRaw(index, blockHeight, layerHeight);
    }

    private final void setLayerHeightRaw(int index, int blockHeight, int layerHeight) {
        int floorState = this.floor.get()[index];
        switch (BlockTypes.getFromStateId(floorState)) {
            case SNOW: 
            case SNOW_BLOCK: {
                if (layerHeight != 0) {
                    this.heights.getByteArray()[index] = (byte)(blockHeight + 1);
                    this.floor.getIntArray()[index] = BlockTypes.SNOW.getInternalId() + layerHeight;
                    break;
                }
                this.heights.getByteArray()[index] = (byte)blockHeight;
                this.floor.getIntArray()[index] = BlockTypes.SNOW_BLOCK.getInternalId();
                break;
            }
            default: {
                this.heights.getByteArray()[index] = (byte)blockHeight;
            }
        }
    }

    private void smooth(BufferedImage img, Mask mask, boolean white, int radius, int iterations) {
        int[] floor = this.floor.get();
        byte[] heights = this.heights.get();
        long[] copy = new long[heights.length];
        char[] layers = new char[heights.length];
        this.floor.record(() -> this.heights.record(() -> {
            int width = this.getWidth();
            int length = this.getLength();
            SummedAreaTable table = new SummedAreaTable(copy, layers, width, radius);
            for (int j = 0; j < iterations; ++j) {
                int newHeight;
                int x;
                int z;
                for (int i = 0; i < heights.length; ++i) {
                    int combined = floor[i];
                    layers[i] = BlockTypes.getFromStateId(combined) == BlockTypes.SNOW ? (char)(((heights[i] & 0xFF) << 3) + (floor[i] >> BlockTypes.BIT_OFFSET) - 7) : (char)((heights[i] & 0xFF) << 3);
                }
                int index = 0;
                table.processSummedAreaTable();
                if (img != null) {
                    for (z = 0; z < this.getLength(); ++z) {
                        x = 0;
                        while (x < this.getWidth()) {
                            int height = img.getRGB(x, z) & 0xFF;
                            if (height == 255 || height > 0 && !white && PseudoRandom.random.nextInt(256) <= height) {
                                newHeight = table.average(x, z, index);
                                this.setLayerHeightRaw(index, newHeight);
                            }
                            ++x;
                            ++index;
                        }
                    }
                    continue;
                }
                if (mask != null) {
                    for (z = 0; z < this.getLength(); ++z) {
                        this.mutable.mutZ(z);
                        x = 0;
                        while (x < this.getWidth()) {
                            int y = heights[index] & 0xFF;
                            this.mutable.mutX(x);
                            this.mutable.mutY(y);
                            if (mask.test(this.mutable)) {
                                newHeight = table.average(x, z, index);
                                this.setLayerHeightRaw(index, newHeight);
                            }
                            ++x;
                            ++index;
                        }
                    }
                    continue;
                }
                for (z = 0; z < this.getLength(); ++z) {
                    x = 0;
                    while (x < this.getWidth()) {
                        int newHeight2 = table.average(x, z, index);
                        this.setLayerHeightRaw(index, newHeight2);
                        ++x;
                        ++index;
                    }
                }
            }
        }));
    }

    public void setHeight(BufferedImage img) {
        int index = 0;
        for (int z = 0; z < this.getLength(); ++z) {
            int x = 0;
            while (x < this.getWidth()) {
                this.heights.setByte(index, (byte)(img.getRGB(x, z) >> 8));
                ++x;
                ++index;
            }
        }
    }

    public void addCaves() throws WorldEditException {
        CuboidRegion region = new CuboidRegion(new Vector(0, 0, 0), new Vector(this.getWidth() - 1, 255, this.getLength() - 1));
        this.addCaves(region);
    }

    @Deprecated
    public void addSchems(Mask mask, List<ClipboardHolder> clipboards, int rarity, boolean rotate) throws WorldEditException {
        CuboidRegion region = new CuboidRegion(new Vector(0, 0, 0), new Vector(this.getWidth() - 1, 255, this.getLength() - 1));
        this.addSchems(region, mask, clipboards, rarity, rotate);
    }

    public void addSchems(BufferedImage img, Mask mask, List<ClipboardHolder> clipboards, int rarity, int distance, boolean randomRotate) throws WorldEditException {
        if (img.getWidth() != this.getWidth() || img.getHeight() != this.getLength()) {
            throw new IllegalArgumentException("Input image dimensions do not match the current height map!");
        }
        double doubleRarity = (double)rarity / 100.0;
        int index = 0;
        AffineTransform identity = new AffineTransform();
        LocalBlockVector2DSet placed = new LocalBlockVector2DSet();
        block0: for (int z = 0; z < this.getLength(); ++z) {
            this.mutable.mutZ(z);
            int x = 0;
            while (x < this.getWidth()) {
                int y = this.heights.getByte(index) & 0xFF;
                int height = img.getRGB(x, z) & 0xFF;
                if (height != 0 && !((double)PseudoRandom.random.nextInt(256) > (double)height * doubleRarity)) {
                    this.mutable.mutX(x);
                    this.mutable.mutY(y);
                    if (mask.test(this.mutable) && !placed.containsRadius(x, z, distance)) {
                        placed.add(x, z);
                        ClipboardHolder holder = clipboards.get(PseudoRandom.random.random(clipboards.size()));
                        if (randomRotate) {
                            int rotate = PseudoRandom.random.random(4) * 90;
                            if (rotate != 0) {
                                holder.setTransform(new AffineTransform().rotateY(PseudoRandom.random.random(4) * 90));
                            } else {
                                holder.setTransform(identity);
                            }
                        }
                        Clipboard clipboard = holder.getClipboard();
                        Schematic schematic = new Schematic(clipboard);
                        Transform transform = holder.getTransform();
                        if (transform.isIdentity()) {
                            schematic.paste(this, this.mutable, false);
                        } else {
                            schematic.paste(this, this.mutable, false, transform);
                        }
                        if (x + distance >= this.getWidth()) continue block0;
                        x += distance;
                        index += distance;
                    }
                }
                ++x;
                ++index;
            }
        }
    }

    public void addSchems(Mask mask, List<ClipboardHolder> clipboards, int rarity, int distance, boolean randomRotate) throws WorldEditException {
        int scaledRarity = 256 * rarity / 100;
        int index = 0;
        AffineTransform identity = new AffineTransform();
        LocalBlockVector2DSet placed = new LocalBlockVector2DSet();
        block0: for (int z = 0; z < this.getLength(); ++z) {
            this.mutable.mutZ(z);
            int x = 0;
            while (x < this.getWidth()) {
                int y = this.heights.getByte(index) & 0xFF;
                if (PseudoRandom.random.nextInt(256) <= scaledRarity) {
                    this.mutable.mutX(x);
                    this.mutable.mutY(y);
                    if (mask.test(this.mutable) && !placed.containsRadius(x, z, distance)) {
                        this.mutable.mutY(y + 1);
                        placed.add(x, z);
                        ClipboardHolder holder = clipboards.get(PseudoRandom.random.random(clipboards.size()));
                        if (randomRotate) {
                            int rotate = PseudoRandom.random.random(4) * 90;
                            if (rotate != 0) {
                                holder.setTransform(new AffineTransform().rotateY(PseudoRandom.random.random(4) * 90));
                            } else {
                                holder.setTransform(identity);
                            }
                        }
                        Clipboard clipboard = holder.getClipboard();
                        Schematic schematic = new Schematic(clipboard);
                        Transform transform = holder.getTransform();
                        if (transform.isIdentity()) {
                            schematic.paste(this, this.mutable, false);
                        } else {
                            schematic.paste(this, this.mutable, false, transform);
                        }
                        if (x + distance >= this.getWidth()) continue block0;
                        x += distance;
                        index += distance;
                    }
                }
                ++x;
                ++index;
            }
        }
    }

    public void addOre(Mask mask, Pattern material, int size, int frequency, int rarity, int minY, int maxY) throws WorldEditException {
        CuboidRegion region = new CuboidRegion(new Vector(0, 0, 0), new Vector(this.getWidth() - 1, 255, this.getLength() - 1));
        this.addOre(region, mask, material, size, frequency, rarity, minY, maxY);
    }

    public void addDefaultOres(Mask mask) throws WorldEditException {
        this.addOres(new CuboidRegion(new Vector(0, 0, 0), new Vector(this.getWidth() - 1, 255, this.getLength() - 1)), mask);
    }

    @Override
    public Vector getMinimumPoint() {
        return new Vector(0, 0, 0);
    }

    @Override
    public FawePlayer getPlayer() {
        return this.player;
    }

    @Override
    public Vector getMaximumPoint() {
        return new Vector(this.getWidth() - 1, 255, this.getLength() - 1);
    }

    @Override
    public boolean setBlock(Vector position, BlockStateHolder block) throws WorldEditException {
        return this.setBlock(position.getBlockX(), position.getBlockY(), position.getBlockZ(), block);
    }

    @Override
    public boolean setBiome(Vector2D position, BaseBiome biome) {
        return this.setBiome(position.getBlockX(), position.getBlockZ(), biome);
    }

    @Override
    public boolean setBlock(int x, int y, int z, int combined) {
        int index = z * this.getWidth() + x;
        if (index < 0 || index >= this.getArea()) {
            return false;
        }
        int height = this.heights.getByte(index) & 0xFF;
        switch (y - height) {
            case 0: {
                this.floor.setInt(index, combined);
                return true;
            }
            case 1: {
                int mainId = this.main.getInt(index);
                int floorId = this.floor.getInt(index);
                this.floor.setInt(index, combined);
                byte currentHeight = this.heights.getByte(index);
                currentHeight = (byte)(currentHeight + 1);
                this.heights.setByte(index, currentHeight);
                if (mainId == floorId) {
                    return true;
                }
                --y;
                combined = floorId;
            }
        }
        try {
            short chunkX = (short)(x >> 4);
            short chunkZ = (short)(z >> 4);
            this.blocks.set(x, y, z, combined);
            return true;
        }
        catch (IndexOutOfBoundsException ignore) {
            return false;
        }
    }

    @Override
    public void setTile(int x, int y, int z, CompoundTag tag) {
    }

    @Override
    public void setEntity(int x, int y, int z, CompoundTag tag) {
    }

    @Override
    public void removeEntity(int x, int y, int z, UUID uuid) {
    }

    @Override
    public boolean setBiome(int x, int z, BaseBiome biome) {
        int index = z * this.getWidth() + x;
        if (index < 0 || index >= this.getArea()) {
            return false;
        }
        this.biomes.setByte(index, (byte)biome.getId());
        return true;
    }

    @Override
    public FaweChunk getFaweChunk(int chunkX, int chunkZ) {
        return new SimpleIntFaweChunk(this, chunkX, chunkZ);
    }

    @Override
    public FaweChunk getSnapshot(int chunkX, int chunkZ) {
        return this.getSnapshot(null, chunkX, chunkZ);
    }

    private FaweChunk getSnapshot(final MCAChunk chunk, final int chunkX, final int chunkZ) {
        return new LazyFaweChunk<MCAChunk>((FaweQueue)this, chunkX, chunkZ){

            @Override
            public MCAChunk getChunk() {
                MCAChunk tmp = chunk;
                if (tmp == null) {
                    tmp = new MCAChunk(HeightMapMCAGenerator.this, chunkX, chunkZ);
                } else {
                    tmp.setLoc(HeightMapMCAGenerator.this, chunkX, chunkZ);
                }
                int cbx = chunkX << 4;
                int cbz = chunkZ << 4;
                int csx = Math.max(0, cbx);
                int csz = Math.max(0, cbz);
                int cex = Math.min(HeightMapMCAGenerator.this.getWidth(), cbx + 15);
                int cez = Math.min(HeightMapMCAGenerator.this.getLength(), cbz + 15);
                HeightMapMCAGenerator.this.write(tmp, csx, cex, csz, cez);
                tmp.setLoc(HeightMapMCAGenerator.this, this.getX(), this.getZ());
                return tmp;
            }

            @Override
            public void addToQueue() {
                MCAChunk cached = (MCAChunk)this.getCachedChunk();
                if (cached != null) {
                    HeightMapMCAGenerator.this.setChunk(cached);
                }
            }
        };
    }

    @Override
    public Collection<FaweChunk> getFaweChunks() {
        return Collections.emptyList();
    }

    @Override
    public void setChunk(FaweChunk chunk) {
        int[][] src = chunk.getCombinedIdArrays();
        for (int i = 0; i < src.length; ++i) {
            if (src[i] == null) continue;
            int bx = chunk.getX() << 4;
            int bz = chunk.getZ() << 4;
            int by = i << 4;
            for (int layer = i; layer < src.length; ++layer) {
                int[] srcLayer = src[layer];
                if (srcLayer == null) continue;
                int index = 0;
                for (int y = 0; y < 16; ++y) {
                    int yy = by + y;
                    for (int z = 0; z < 16; ++z) {
                        int zz = bz + z;
                        int x = 0;
                        while (x < 16) {
                            int combined = srcLayer[index];
                            if (combined != 0) {
                                this.setBlock(bx + x, yy, zz, combined);
                            }
                            ++x;
                            ++index;
                        }
                    }
                }
            }
            break;
        }
    }

    @Override
    public File getSaveFolder() {
        return this.getFolder();
    }

    @Override
    public boolean regenerateChunk(int x, int z, @Nullable BaseBiome biome, @Nullable Long seed) {
        return false;
    }

    @Override
    public void sendBlockUpdate(FaweChunk chunk, FawePlayer ... players) {
    }

    @Override
    public void flush(int time) {
        this.next(0, time);
    }

    @Override
    public boolean next(int amount, long time) {
        EditSession curES = this.editSession;
        if (curES != null && this.isModified()) {
            try {
                this.update();
                FawePlayer esPlayer = curES.getPlayer();
                UUID uuid = esPlayer != null ? esPlayer.getUUID() : EditSession.CONSOLE;
                try {
                    curES.setRawChangeSet(new CFIChangeSet(this, uuid));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        this.clear();
        return false;
    }

    @Override
    public void sendChunk(FaweChunk chunk) {
    }

    @Override
    public void sendChunk(int x, int z, int bitMask) {
    }

    @Override
    public void clear() {
        this.editSession = null;
    }

    @Override
    public void close(boolean update) {
        this.clear();
        if (this.chunkOffset != null && this.player != null && update) {
            FaweQueue packetQueue = SetQueue.IMP.getNewQueue(this.player.getWorld(), true, false);
            int lenCX = this.getWidth() + 15 >> 4;
            int lenCZ = this.getLength() + 15 >> 4;
            int OX = this.chunkOffset.getBlockX();
            int OZ = this.chunkOffset.getBlockZ();
            FaweLocation position = this.player.getLocation();
            int pcx = (position.x >> 4) - OX;
            int pcz = (position.z >> 4) - OZ;
            int scx = Math.max(0, pcx - 10);
            int scz = Math.max(0, pcz - 10);
            int ecx = Math.min(lenCX - 1, pcx + 10);
            int ecz = Math.min(lenCZ - 1, pcz + 10);
            for (int cz = scz; cz <= ecz; ++cz) {
                for (int cx = scx; cx <= ecx; ++cx) {
                    packetQueue.sendChunk(cx + OX, cz + OZ, 0);
                }
            }
        }
        if (this.player != null) {
            this.player.deleteMeta("CFISettings");
            LocalSession session = this.player.getSession();
            session.clearHistory();
        }
        this.player = null;
        this.chunkOffset = null;
    }

    @Override
    public void addNotifyTask(int x, int z, Runnable runnable) {
        if (runnable != null) {
            runnable.run();
        }
    }

    @Override
    public int getBiomeId(int x, int z) throws FaweException.FaweChunkLoadException {
        int index = z * this.getWidth() + x;
        if (index < 0 || index >= this.getArea()) {
            index = Math.floorMod(index, this.getArea());
        }
        return this.biomes.getByte(index) & 0xFF;
    }

    @Override
    public int getCombinedId4Data(int x, int y, int z) throws FaweException.FaweChunkLoadException {
        int combined;
        short chunkZ;
        short chunkX;
        int[][][] map;
        int index = z * this.getWidth() + x;
        if (y < 0) {
            return 0;
        }
        if (index < 0 || index >= this.getArea() || x < 0 || x >= this.getWidth()) {
            return 0;
        }
        int height = this.heights.getByte(index) & 0xFF;
        if (y > height) {
            int combined2;
            short chunkZ2;
            short chunkX2;
            int[][][] map2;
            if (y == height + 1) {
                return this.overlay != null ? this.overlay.getInt(index) : 0;
            }
            if (this.blocks != null && (map2 = this.getChunkArray(chunkX2 = (short)(x >> 4), chunkZ2 = (short)(z >> 4))) != null && (combined2 = this.get(map2, x, y, z)) != 0) {
                return combined2;
            }
            if (y <= this.primtives.waterHeight) {
                return this.primtives.waterId << 4;
            }
            return 0;
        }
        if (y == height) {
            return this.floor.getInt(index);
        }
        if (this.blocks != null && (map = this.getChunkArray(chunkX = (short)(x >> 4), chunkZ = (short)(z >> 4))) != null && (combined = this.get(map, x, y, z)) != 0) {
            return combined;
        }
        return this.main.getInt(index);
    }

    @Override
    public int getCombinedId4Data(int x, int y, int z, int def) {
        return this.getCombinedId4Data(x, y, z);
    }

    @Override
    public int getCachedCombinedId4Data(int x, int y, int z) throws FaweException.FaweChunkLoadException {
        return this.getCombinedId4Data(x, y, z);
    }

    @Override
    public boolean hasSky() {
        return true;
    }

    @Override
    public int getSkyLight(int x, int y, int z) {
        return this.getNearestSurfaceTerrainBlock(x, z, y, 0, 255) < y ? 15 : 0;
    }

    @Override
    public int getEmmittedLight(int x, int y, int z) {
        return 0;
    }

    @Override
    public CompoundTag getTileEntity(int x, int y, int z) throws FaweException.FaweChunkLoadException {
        return null;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean setBlock(int x, int y, int z, BlockStateHolder block) throws WorldEditException {
        return this.setBlock(x, y, z, block.getInternalId());
    }

    @Override
    public BaseBiome getBiome(Vector2D position) {
        return FaweCache.CACHE_BIOME[this.getBiomeId(position.getBlockX(), position.getBlockZ())];
    }

    @Override
    public BlockState getBlock(Vector position) {
        return this.getLazyBlock(position);
    }

    public BlockState getFloor(int x, int z) {
        int index = z * this.getWidth() + x;
        return BlockState.getFromInternalId(this.floor.getInt(index));
    }

    public int getHeight(int x, int z) {
        int index = z * this.getWidth() + x;
        return this.heights.getByte(index) & 0xFF;
    }

    public int getHeight(int index) {
        return this.heights.getByte(index) & 0xFF;
    }

    public void setFloor(int x, int z, BlockStateHolder block) {
        int index = z * this.getWidth() + x;
        this.floor.setInt(index, block.getInternalId());
    }

    @Override
    public BlockState getLazyBlock(Vector position) {
        return this.getLazyBlock(position.getBlockX(), position.getBlockY(), position.getBlockZ());
    }

    @Override
    public BlockState getLazyBlock(int x, int y, int z) {
        return BlockState.getFromInternalId(this.getCombinedId4Data(x, y, z));
    }

    @Override
    public int getNearestSurfaceLayer(int x, int z, int y, int minY, int maxY) {
        int index = z * this.getWidth() + x;
        if (index < 0 || index >= this.getArea()) {
            index = Math.floorMod(index, this.getArea());
        }
        return ((this.heights.getByte(index) & 0xFF) << 3) + (this.floor.getInt(index) & 0xFF) + 1;
    }

    @Override
    public int getNearestSurfaceTerrainBlock(int x, int z, int y, int minY, int maxY) {
        int index = z * this.getWidth() + x;
        if (index < 0 || index >= this.getArea()) {
            index = Math.floorMod(index, this.getArea());
        }
        return this.heights.getByte(index) & 0xFF;
    }

    @Override
    public int getNearestSurfaceTerrainBlock(int x, int z, int y, int minY, int maxY, int failedMin, int failedMax) {
        int index = z * this.getWidth() + x;
        if (index < 0 || index >= this.getArea()) {
            index = Math.floorMod(index, this.getArea());
        }
        return this.heights.getByte(index) & 0xFF;
    }

    public void setBiome(final BufferedImage img, final byte biome, final boolean white) {
        if (img.getWidth() != this.getWidth() || img.getHeight() != this.getLength()) {
            throw new IllegalArgumentException("Input image dimensions do not match the current height map!");
        }
        this.biomes.record(new Runnable(){

            @Override
            public void run() {
                byte[] biomeArr = HeightMapMCAGenerator.this.biomes.get();
                int index = 0;
                for (int z = 0; z < HeightMapMCAGenerator.this.getLength(); ++z) {
                    int x = 0;
                    while (x < HeightMapMCAGenerator.this.getWidth()) {
                        int height = img.getRGB(x, z) & 0xFF;
                        if (height == 255 || height > 0 && !white && PseudoRandom.random.nextInt(256) <= height) {
                            biomeArr[index] = biome;
                        }
                        ++x;
                        ++index;
                    }
                }
            }
        });
    }

    @Override
    public BufferedImage draw() {
        return new HeightMapMCADrawer(this).draw();
    }

    public void setBiomePriority(int value) {
        this.primtives.biomePriority = value * 65536 / 100 - 32768;
    }

    public int getBiomePriority() {
        return (this.primtives.biomePriority + 32768) * 100 / 65536;
    }

    public void setBlockAndBiomeColor(BufferedImage img, Mask mask, BufferedImage imgMask, boolean whiteOnly) {
        if (mask == null && imgMask == null) {
            this.setBlockAndBiomeColor(img);
            return;
        }
        if (img.getWidth() != this.getWidth() || img.getHeight() != this.getLength()) {
            throw new IllegalArgumentException("Input image dimensions do not match the current height map!");
        }
        TextureUtil textureUtil = this.getTextureUtil();
        int widthIndex = img.getWidth() - 1;
        int heightIndex = img.getHeight() - 1;
        int maxIndex = this.getArea() - 1;
        this.biomes.record(() -> this.floor.record(() -> this.main.record(() -> {
            int[] mainArr = this.main.get();
            int[] floorArr = this.floor.get();
            byte[] biomesArr = this.biomes.get();
            int index = 0;
            int[] buffer = new int[2];
            for (int z = 0; z < img.getHeight(); ++z) {
                this.mutable.mutZ(z);
                int x = 0;
                while (x < img.getWidth()) {
                    block8: {
                        int height;
                        block7: {
                            if (mask == null) break block7;
                            this.mutable.mutX(z);
                            this.mutable.mutY(this.heights.getByte(index) & 0xFF);
                            if (!mask.test(this.mutable)) break block8;
                        }
                        if (imgMask == null || (height = imgMask.getRGB(x, z) & 0xFF) == 255 || height > 0 && whiteOnly && PseudoRandom.random.nextInt(256) <= height) {
                            int color = img.getRGB(x, z);
                            if (textureUtil.getIsBlockCloserThanBiome(buffer, color, this.primtives.biomePriority)) {
                                int combined;
                                mainArr[index] = combined = buffer[0];
                                floorArr[index] = combined;
                            }
                            biomesArr[index] = (byte)buffer[1];
                        }
                    }
                    ++x;
                    ++index;
                }
            }
        })));
    }

    public void setBlockAndBiomeColor(BufferedImage img) {
        if (img.getWidth() != this.getWidth() || img.getHeight() != this.getLength()) {
            throw new IllegalArgumentException("Input image dimensions do not match the current height map!");
        }
        TextureUtil textureUtil = this.getTextureUtil();
        int widthIndex = img.getWidth() - 1;
        int heightIndex = img.getHeight() - 1;
        int maxIndex = this.getArea() - 1;
        this.biomes.record(() -> this.floor.record(() -> this.main.record(() -> {
            int[] mainArr = this.main.get();
            int[] floorArr = this.floor.get();
            byte[] biomesArr = this.biomes.get();
            int[] buffer = new int[2];
            int index = 0;
            for (int y = 0; y < img.getHeight(); ++y) {
                boolean yBiome = y > 0 && y < heightIndex;
                int x = 0;
                while (x < img.getWidth()) {
                    int color = img.getRGB(x, y);
                    if (textureUtil.getIsBlockCloserThanBiome(buffer, color, this.primtives.biomePriority)) {
                        int combined;
                        mainArr[index] = combined = buffer[0];
                        floorArr[index] = combined;
                    }
                    biomesArr[index] = (byte)buffer[1];
                    ++x;
                    ++index;
                }
            }
        })));
    }

    public void setBiomeColor(final BufferedImage img) {
        if (img.getWidth() != this.getWidth() || img.getHeight() != this.getLength()) {
            throw new IllegalArgumentException("Input image dimensions do not match the current height map!");
        }
        final TextureUtil textureUtil = this.getTextureUtil();
        this.biomes.record(new Runnable(){

            @Override
            public void run() {
                byte[] biomesArr = HeightMapMCAGenerator.this.biomes.get();
                int index = 0;
                for (int y = 0; y < img.getHeight(); ++y) {
                    for (int x = 0; x < img.getWidth(); ++x) {
                        int color = img.getRGB(x, y);
                        TextureUtil.BiomeColor biome = textureUtil.getNearestBiome(color);
                        if (biome != null) {
                            biomesArr[index] = (byte)biome.id;
                        }
                        ++index;
                    }
                }
            }
        });
    }

    public void setColor(BufferedImage img, BufferedImage mask, boolean white) {
        if (img.getWidth() != this.getWidth() || img.getHeight() != this.getLength()) {
            throw new IllegalArgumentException("Input image dimensions do not match the current height map!");
        }
        if (mask.getWidth() != this.getWidth() || mask.getHeight() != this.getLength()) {
            throw new IllegalArgumentException("Input image dimensions do not match the current height map!");
        }
        this.primtives.modifiedMain = true;
        TextureUtil textureUtil = this.getTextureUtil();
        this.floor.record(() -> this.main.record(() -> {
            int[] mainArr = this.main.get();
            int[] floorArr = this.floor.get();
            int index = 0;
            for (int z = 0; z < this.getLength(); ++z) {
                int x = 0;
                while (x < this.getWidth()) {
                    int color;
                    BlockTypes block;
                    int height = mask.getRGB(x, z) & 0xFF;
                    if ((height == 255 || height > 0 && !white && PseudoRandom.random.nextInt(256) <= height) && (block = textureUtil.getNearestBlock(color = img.getRGB(x, z))) != null) {
                        int combined;
                        mainArr[index] = combined = block.getInternalId();
                        floorArr[index] = combined;
                    }
                    ++x;
                    ++index;
                }
            }
        }));
    }

    public void setColor(BufferedImage img, Mask mask) {
        if (img.getWidth() != this.getWidth() || img.getHeight() != this.getLength()) {
            throw new IllegalArgumentException("Input image dimensions do not match the current height map!");
        }
        this.primtives.modifiedMain = true;
        TextureUtil textureUtil = this.getTextureUtil();
        this.floor.record(() -> this.main.record(() -> {
            int[] mainArr = this.main.get();
            int[] floorArr = this.floor.get();
            int index = 0;
            for (int z = 0; z < this.getLength(); ++z) {
                this.mutable.mutZ(z);
                int x = 0;
                while (x < this.getWidth()) {
                    this.mutable.mutX(x);
                    this.mutable.mutY(this.heights.getByte(index) & 0xFF);
                    if (mask.test(this.mutable)) {
                        int color = img.getRGB(x, z);
                        BlockTypes block = textureUtil.getNearestBlock(color);
                        if (block != null) {
                            int combined;
                            mainArr[index] = combined = block.getInternalId();
                            floorArr[index] = combined;
                        } else {
                            System.out.println("Block is null: " + color);
                        }
                    }
                    ++x;
                    ++index;
                }
            }
        }));
    }

    public void setColor(BufferedImage img) {
        if (img.getWidth() != this.getWidth() || img.getHeight() != this.getLength()) {
            throw new IllegalArgumentException("Input image dimensions do not match the current height map!");
        }
        this.primtives.modifiedMain = true;
        TextureUtil textureUtil = this.getTextureUtil();
        this.floor.record(() -> this.main.record(() -> {
            int[] mainArr = this.main.get();
            int[] floorArr = this.floor.get();
            int index = 0;
            for (int z = 0; z < img.getHeight(); ++z) {
                for (int x = 0; x < img.getWidth(); ++x) {
                    int color = img.getRGB(x, z);
                    BlockTypes block = textureUtil.getNearestBlock(color);
                    if (block != null) {
                        int combined;
                        mainArr[index] = combined = block.getInternalId();
                        floorArr[index] = combined;
                    } else {
                        System.out.println("Block is null " + color + " | " + textureUtil.getClass());
                    }
                    ++index;
                }
            }
        }));
    }

    public void setColorWithGlass(BufferedImage img) {
        if (img.getWidth() != this.getWidth() || img.getHeight() != this.getLength()) {
            throw new IllegalArgumentException("Input image dimensions do not match the current height map!");
        }
        TextureUtil textureUtil = this.getTextureUtil();
        this.floor.record(() -> this.main.record(() -> {
            int[] mainArr = this.main.get();
            int[] floorArr = this.floor.get();
            int index = 0;
            for (int y = 0; y < img.getHeight(); ++y) {
                for (int x = 0; x < img.getWidth(); ++x) {
                    int color = img.getRGB(x, y);
                    BlockTypes[] layer = textureUtil.getNearestLayer(color);
                    if (layer != null) {
                        floorArr[index] = layer[0].getInternalId();
                        mainArr[index] = layer[1].getInternalId();
                    }
                    ++index;
                }
            }
        }));
    }

    public void setBiome(Mask mask, byte biome) {
        int index = 0;
        for (int z = 0; z < this.getLength(); ++z) {
            this.mutable.mutZ(z);
            int x = 0;
            while (x < this.getWidth()) {
                int y = this.heights.getByte(index) & 0xFF;
                this.mutable.mutX(x);
                this.mutable.mutY(y);
                if (mask.test(this.mutable)) {
                    this.biomes.setByte(index, biome);
                }
                ++x;
                ++index;
            }
        }
    }

    public void setOverlay(BufferedImage img, Pattern pattern, boolean white) {
        if (pattern instanceof BlockStateHolder) {
            this.setOverlay(img, ((BlockStateHolder)pattern).getInternalId(), white);
        } else if (pattern instanceof BlockType) {
            this.setOverlay(img, ((BlockType)pattern).getInternalId(), white);
        } else {
            if (img.getWidth() != this.getWidth() || img.getHeight() != this.getLength()) {
                throw new IllegalArgumentException("Input image dimensions do not match the current height map!");
            }
            if (this.overlay == null) {
                this.overlay = new DifferentialArray<int[]>(new int[this.getArea()]);
            }
            this.overlay.record(() -> {
                int[] overlayArr = this.overlay.get();
                int index = 0;
                for (int z = 0; z < this.getLength(); ++z) {
                    this.mutable.mutZ(z);
                    int x = 0;
                    while (x < this.getWidth()) {
                        int height = img.getRGB(x, z) & 0xFF;
                        if (height == 255 || height > 0 && !white && PseudoRandom.random.nextInt(256) <= height) {
                            this.mutable.mutX(x);
                            this.mutable.mutY(height);
                            overlayArr[index] = pattern.apply(this.mutable).getInternalId();
                        }
                        ++x;
                        ++index;
                    }
                }
            });
        }
    }

    public void setMain(BufferedImage img, Pattern pattern, boolean white) {
        if (pattern instanceof BlockStateHolder) {
            this.setMain(img, ((BlockStateHolder)pattern).getInternalId(), white);
        } else {
            if (img.getWidth() != this.getWidth() || img.getHeight() != this.getLength()) {
                throw new IllegalArgumentException("Input image dimensions do not match the current height map!");
            }
            this.primtives.modifiedMain = true;
            this.main.record(() -> {
                int[] mainArr = this.main.get();
                int index = 0;
                for (int z = 0; z < this.getLength(); ++z) {
                    this.mutable.mutZ(z);
                    int x = 0;
                    while (x < this.getWidth()) {
                        int height = img.getRGB(x, z) & 0xFF;
                        if (height == 255 || height > 0 && !white && PseudoRandom.random.nextInt(256) <= height) {
                            this.mutable.mutX(x);
                            this.mutable.mutY(height);
                            mainArr[index] = pattern.apply(this.mutable).getInternalId();
                        }
                        ++x;
                        ++index;
                    }
                }
            });
        }
    }

    public void setFloor(BufferedImage img, Pattern pattern, boolean white) {
        if (pattern instanceof BlockStateHolder) {
            this.setFloor(img, ((BlockStateHolder)pattern).getInternalId(), white);
        } else {
            if (img.getWidth() != this.getWidth() || img.getHeight() != this.getLength()) {
                throw new IllegalArgumentException("Input image dimensions do not match the current height map!");
            }
            this.floor.record(() -> {
                int[] floorArr = this.floor.get();
                int index = 0;
                for (int z = 0; z < this.getLength(); ++z) {
                    this.mutable.mutZ(z);
                    int x = 0;
                    while (x < this.getWidth()) {
                        int height = img.getRGB(x, z) & 0xFF;
                        if (height == 255 || height > 0 && !white && PseudoRandom.random.nextInt(256) <= height) {
                            this.mutable.mutX(x);
                            this.mutable.mutY(height);
                            floorArr[index] = pattern.apply(this.mutable).getInternalId();
                        }
                        ++x;
                        ++index;
                    }
                }
            });
        }
    }

    public void setColumn(BufferedImage img, Pattern pattern, boolean white) {
        if (pattern instanceof BlockStateHolder) {
            this.setColumn(img, ((BlockStateHolder)pattern).getInternalId(), white);
        } else {
            if (img.getWidth() != this.getWidth() || img.getHeight() != this.getLength()) {
                throw new IllegalArgumentException("Input image dimensions do not match the current height map!");
            }
            this.primtives.modifiedMain = true;
            this.main.record(() -> this.floor.record(() -> {
                int[] floorArr = this.floor.get();
                int[] mainArr = this.main.get();
                int index = 0;
                for (int z = 0; z < this.getLength(); ++z) {
                    this.mutable.mutZ(z);
                    int x = 0;
                    while (x < this.getWidth()) {
                        int height = img.getRGB(x, z) & 0xFF;
                        if (height == 255 || height > 0 && !white && PseudoRandom.random.nextInt(256) <= height) {
                            int combined;
                            this.mutable.mutX(x);
                            this.mutable.mutY(height);
                            mainArr[index] = combined = pattern.apply(this.mutable).getInternalId();
                            floorArr[index] = combined;
                        }
                        ++x;
                        ++index;
                    }
                }
            }));
        }
    }

    public void setOverlay(Mask mask, Pattern pattern) {
        if (pattern instanceof BlockStateHolder) {
            this.setOverlay(mask, ((BlockStateHolder)pattern).getInternalId());
        } else {
            int index = 0;
            if (this.overlay == null) {
                this.overlay = new DifferentialArray<int[]>(new int[this.getArea()]);
            }
            for (int z = 0; z < this.getLength(); ++z) {
                this.mutable.mutZ(z);
                int x = 0;
                while (x < this.getWidth()) {
                    int y = this.heights.getByte(index) & 0xFF;
                    this.mutable.mutX(x);
                    this.mutable.mutY(y);
                    if (mask.test(this.mutable)) {
                        this.overlay.setInt(index, pattern.apply(this.mutable).getInternalId());
                    }
                    ++x;
                    ++index;
                }
            }
        }
    }

    public void setFloor(Mask mask, Pattern pattern) {
        if (pattern instanceof BlockStateHolder) {
            this.setFloor(mask, ((BlockStateHolder)pattern).getInternalId());
        } else {
            int index = 0;
            for (int z = 0; z < this.getLength(); ++z) {
                this.mutable.mutZ(z);
                int x = 0;
                while (x < this.getWidth()) {
                    int y = this.heights.getByte(index) & 0xFF;
                    this.mutable.mutX(x);
                    this.mutable.mutY(y);
                    if (mask.test(this.mutable)) {
                        this.floor.setInt(index, pattern.apply(this.mutable).getInternalId());
                    }
                    ++x;
                    ++index;
                }
            }
        }
    }

    public void setMain(Mask mask, Pattern pattern) {
        if (pattern instanceof BlockStateHolder) {
            this.setMain(mask, ((BlockStateHolder)pattern).getInternalId());
        } else {
            this.primtives.modifiedMain = true;
            int index = 0;
            for (int z = 0; z < this.getLength(); ++z) {
                this.mutable.mutZ(z);
                int x = 0;
                while (x < this.getWidth()) {
                    int y = this.heights.getByte(index) & 0xFF;
                    this.mutable.mutX(x);
                    this.mutable.mutY(y);
                    if (mask.test(this.mutable)) {
                        this.main.setInt(index, pattern.apply(this.mutable).getInternalId());
                    }
                    ++x;
                    ++index;
                }
            }
        }
    }

    public void setColumn(Mask mask, Pattern pattern) {
        if (pattern instanceof BlockStateHolder) {
            this.setColumn(mask, ((BlockStateHolder)pattern).getInternalId());
        } else {
            this.primtives.modifiedMain = true;
            int index = 0;
            for (int z = 0; z < this.getLength(); ++z) {
                this.mutable.mutZ(z);
                int x = 0;
                while (x < this.getWidth()) {
                    int y = this.heights.getByte(index) & 0xFF;
                    this.mutable.mutX(x);
                    this.mutable.mutY(y);
                    if (mask.test(this.mutable)) {
                        int combined = pattern.apply(this.mutable).getInternalId();
                        this.floor.setInt(index, combined);
                        this.main.setInt(index, combined);
                    }
                    ++x;
                    ++index;
                }
            }
        }
    }

    public void setBiome(int biome) {
        this.biomes.record(() -> Arrays.fill(this.biomes.get(), (byte)biome));
    }

    public void setFloor(Pattern value) {
        if (value instanceof BlockStateHolder) {
            this.setFloor(((BlockStateHolder)value).getInternalId());
        } else {
            this.floor.record(() -> {
                int[] floorArr = this.floor.get();
                int index = 0;
                for (int z = 0; z < this.getLength(); ++z) {
                    this.mutable.mutZ(z);
                    int x = 0;
                    while (x < this.getWidth()) {
                        int y = this.heights.getByte(index) & 0xFF;
                        this.mutable.mutX(x);
                        this.mutable.mutY(y);
                        floorArr[index] = value.apply(this.mutable).getInternalId();
                        ++x;
                        ++index;
                    }
                }
            });
        }
    }

    public void setColumn(Pattern value) {
        if (value instanceof BlockStateHolder) {
            this.setColumn(((BlockStateHolder)value).getInternalId());
        } else {
            this.main.record(() -> this.floor.record(() -> {
                int[] floorArr = this.floor.get();
                int[] mainArr = this.main.get();
                int index = 0;
                for (int z = 0; z < this.getLength(); ++z) {
                    this.mutable.mutZ(z);
                    int x = 0;
                    while (x < this.getWidth()) {
                        int combined;
                        int y = this.heights.getByte(index) & 0xFF;
                        this.mutable.mutX(x);
                        this.mutable.mutY(y);
                        mainArr[index] = combined = value.apply(this.mutable).getInternalId();
                        floorArr[index] = combined;
                        ++x;
                        ++index;
                    }
                }
            }));
        }
    }

    public void setMain(Pattern value) {
        if (value instanceof BlockStateHolder) {
            this.setMain(((BlockStateHolder)value).getInternalId());
        } else {
            this.main.record(() -> {
                int[] mainArr = this.main.get();
                int index = 0;
                for (int z = 0; z < this.getLength(); ++z) {
                    this.mutable.mutZ(z);
                    int x = 0;
                    while (x < this.getWidth()) {
                        int y = this.heights.getByte(index) & 0xFF;
                        this.mutable.mutX(x);
                        this.mutable.mutY(y);
                        mainArr[index] = value.apply(this.mutable).getInternalId();
                        ++x;
                        ++index;
                    }
                }
            });
        }
    }

    public void setOverlay(Pattern value) {
        if (this.overlay == null) {
            this.overlay = new DifferentialArray<int[]>(new int[this.getArea()]);
        }
        if (value instanceof BlockStateHolder) {
            this.setOverlay(((BlockStateHolder)value).getInternalId());
        } else {
            this.overlay.record(() -> {
                int[] overlayArr = this.overlay.get();
                int index = 0;
                for (int z = 0; z < this.getLength(); ++z) {
                    this.mutable.mutZ(z);
                    int x = 0;
                    while (x < this.getWidth()) {
                        int y = this.heights.getByte(index) & 0xFF;
                        this.mutable.mutX(x);
                        this.mutable.mutY(y);
                        overlayArr[index] = value.apply(this.mutable).getInternalId();
                        ++x;
                        ++index;
                    }
                }
            });
        }
    }

    public void setHeight(int x, int z, int height) {
        int index = z * this.getWidth() + x;
        if (index < 0 || index >= this.getArea()) {
            return;
        }
        this.heights.setByte(index, (byte)height);
    }

    public void setHeight(int index, int height) {
        this.heights.setByte(index, (byte)height);
    }

    public void setHeights(int value) {
        this.heights.record(() -> Arrays.fill(this.heights.get(), (byte)value));
    }

    @Override
    public boolean shouldWrite(int chunkX, int chunkZ) {
        return true;
    }

    @Override
    public MCAChunk write(MCAChunk chunk, int csx, int cex, int csz, int cez) {
        return chunk;
    }

    private void setUnsafe(int[][][] map, int combined, int x, int y, int z) {
        int[] zMap;
        Object yMap = map[y];
        if (yMap == null) {
            int[][] nArrayArray = new int[16][];
            yMap = nArrayArray;
            map[y] = nArrayArray;
        }
        if ((zMap = yMap[z]) == null) {
            zMap = new int[16];
            yMap[z] = zMap;
        }
        zMap[x] = combined;
    }

    private int get(int[][][] map, int x, int y, int z) {
        int[][] yMap = map[y];
        if (yMap == null) {
            return 0;
        }
        int[] zMap = yMap[z & 0xF];
        if (zMap == null) {
            return 0;
        }
        return zMap[x & 0xF];
    }

    private void setOverlay(Mask mask, int combined) {
        int index = 0;
        if (this.overlay == null) {
            this.overlay = new DifferentialArray<int[]>(new int[this.getArea()]);
        }
        for (int z = 0; z < this.getLength(); ++z) {
            this.mutable.mutZ(z);
            int x = 0;
            while (x < this.getWidth()) {
                int y = this.heights.getByte(index) & 0xFF;
                this.mutable.mutX(x);
                this.mutable.mutY(y);
                if (mask.test(this.mutable)) {
                    this.overlay.setInt(index, combined);
                }
                ++x;
                ++index;
            }
        }
    }

    private void setFloor(Mask mask, int combined) {
        int index = 0;
        for (int z = 0; z < this.getLength(); ++z) {
            this.mutable.mutZ(z);
            int x = 0;
            while (x < this.getWidth()) {
                int y = this.heights.getByte(index) & 0xFF;
                this.mutable.mutX(x);
                this.mutable.mutY(y);
                if (mask.test(this.mutable)) {
                    this.floor.setInt(index, combined);
                }
                ++x;
                ++index;
            }
        }
    }

    private void setMain(Mask mask, int combined) {
        this.primtives.modifiedMain = true;
        int index = 0;
        for (int z = 0; z < this.getLength(); ++z) {
            this.mutable.mutZ(z);
            int x = 0;
            while (x < this.getWidth()) {
                int y = this.heights.getByte(index) & 0xFF;
                this.mutable.mutX(x);
                this.mutable.mutY(y);
                if (mask.test(this.mutable)) {
                    this.main.setInt(index, combined);
                }
                ++x;
                ++index;
            }
        }
    }

    private void setColumn(Mask mask, int combined) {
        this.primtives.modifiedMain = true;
        int index = 0;
        for (int z = 0; z < this.getLength(); ++z) {
            this.mutable.mutZ(z);
            int x = 0;
            while (x < this.getWidth()) {
                int y = this.heights.getByte(index) & 0xFF;
                this.mutable.mutX(x);
                this.mutable.mutY(y);
                if (mask.test(this.mutable)) {
                    this.floor.setInt(index, combined);
                    this.main.setInt(index, combined);
                }
                ++x;
                ++index;
            }
        }
    }

    private void setFloor(int value) {
        this.floor.record(() -> Arrays.fill(this.floor.get(), value));
    }

    private void setColumn(int value) {
        this.setFloor(value);
        this.setMain(value);
    }

    private void setMain(int value) {
        this.primtives.modifiedMain = true;
        this.main.record(() -> Arrays.fill(this.main.get(), value));
    }

    private void setOverlay(int value) {
        if (this.overlay == null) {
            this.overlay = new DifferentialArray<int[]>(new int[this.getArea()]);
        }
        this.overlay.record(() -> Arrays.fill(this.overlay.get(), value));
    }

    private void setOverlay(BufferedImage img, int combined, boolean white) {
        if (img.getWidth() != this.getWidth() || img.getHeight() != this.getLength()) {
            throw new IllegalArgumentException("Input image dimensions do not match the current height map!");
        }
        if (this.overlay == null) {
            this.overlay = new DifferentialArray<int[]>(new int[this.getArea()]);
        }
        this.overlay.record(() -> {
            int index = 0;
            for (int z = 0; z < this.getLength(); ++z) {
                int x = 0;
                while (x < this.getWidth()) {
                    int height = img.getRGB(x, z) & 0xFF;
                    if (height == 255 || height > 0 && white && PseudoRandom.random.nextInt(256) <= height) {
                        this.overlay.get()[index] = combined;
                    }
                    ++x;
                    ++index;
                }
            }
        });
    }

    private void setMain(BufferedImage img, int combined, boolean white) {
        if (img.getWidth() != this.getWidth() || img.getHeight() != this.getLength()) {
            throw new IllegalArgumentException("Input image dimensions do not match the current height map!");
        }
        this.primtives.modifiedMain = true;
        this.main.record(() -> {
            int index = 0;
            for (int z = 0; z < this.getLength(); ++z) {
                int x = 0;
                while (x < this.getWidth()) {
                    int height = img.getRGB(x, z) & 0xFF;
                    if (height == 255 || height > 0 && !white && PseudoRandom.random.nextInt(256) <= height) {
                        this.main.get()[index] = combined;
                    }
                    ++x;
                    ++index;
                }
            }
        });
    }

    private void setFloor(BufferedImage img, int combined, boolean white) {
        if (img.getWidth() != this.getWidth() || img.getHeight() != this.getLength()) {
            throw new IllegalArgumentException("Input image dimensions do not match the current height map!");
        }
        this.floor.record(() -> {
            int index = 0;
            for (int z = 0; z < this.getLength(); ++z) {
                int x = 0;
                while (x < this.getWidth()) {
                    int height = img.getRGB(x, z) & 0xFF;
                    if (height == 255 || height > 0 && !white && PseudoRandom.random.nextInt(256) <= height) {
                        this.floor.get()[index] = combined;
                    }
                    ++x;
                    ++index;
                }
            }
        });
    }

    private void setColumn(BufferedImage img, int combined, boolean white) {
        if (img.getWidth() != this.getWidth() || img.getHeight() != this.getLength()) {
            throw new IllegalArgumentException("Input image dimensions do not match the current height map!");
        }
        this.primtives.modifiedMain = true;
        this.main.record(() -> this.floor.record(() -> {
            int index = 0;
            for (int z = 0; z < this.getLength(); ++z) {
                int x = 0;
                while (x < this.getWidth()) {
                    int height = img.getRGB(x, z) & 0xFF;
                    if (height == 255 || height > 0 && !white && PseudoRandom.random.nextInt(256) <= height) {
                        this.main.get()[index] = combined;
                        this.floor.get()[index] = combined;
                    }
                    ++x;
                    ++index;
                }
            }
        }));
    }

    protected void finalize() throws Throwable {
        IterableThreadLocal.clean(this.indexStore);
        super.finalize();
    }

    @Override
    public int getMaxY() {
        return 255;
    }

    @Override
    public void setWorld(String world) {
    }

    @Override
    public World getWEWorld() {
        return this;
    }

    @Override
    public String getWorldName() {
        return this.getName();
    }

    @Override
    public long getModified() {
        return 0L;
    }

    @Override
    public void setModified(long modified) {
    }

    @Override
    public RunnableVal2<FaweQueue.ProgressType, Integer> getProgressTask() {
        return null;
    }

    @Override
    public void setProgressTask(RunnableVal2<FaweQueue.ProgressType, Integer> progressTask) {
    }

    @Override
    public void setChangeTask(RunnableVal2<FaweChunk, FaweChunk> changeTask) {
    }

    @Override
    public RunnableVal2<FaweChunk, FaweChunk> getChangeTask() {
        return null;
    }

    @Override
    public SetQueue.QueueStage getStage() {
        return SetQueue.QueueStage.NONE;
    }

    @Override
    public void setStage(SetQueue.QueueStage stage) {
    }

    @Override
    public void addNotifyTask(Runnable runnable) {
        runnable.run();
    }

    @Override
    public void runTasks() {
    }

    @Override
    public void addTask(Runnable whenFree) {
        whenFree.run();
    }

    @Override
    public boolean isEmpty() {
        return !this.isModified();
    }

    @Override
    @Nullable
    public Operation commit() {
        return null;
    }

    @Override
    public String getName() {
        File folder = this.getFolder();
        if (folder != null) {
            String name = folder.getName();
            if (name.equalsIgnoreCase("region")) {
                return folder.getParentFile().getName();
            }
            return name;
        }
        return Integer.toString(this.hashCode());
    }

    @Override
    public boolean setBlock(Vector position, BlockStateHolder block, boolean notifyAndLight) throws WorldEditException {
        return this.setBlock(position, block);
    }

    @Override
    public int getBlockLightLevel(Vector position) {
        return 0;
    }

    @Override
    public boolean clearContainerBlockContents(Vector position) {
        return false;
    }

    @Override
    public void dropItem(Vector position, BaseItemStack item) {
    }

    @Override
    public boolean regenerate(Region region, EditSession editSession) {
        return false;
    }

    @Override
    public boolean generateTree(TreeGenerator.TreeType type, EditSession editSession, Vector position) throws MaxChangedBlocksException {
        return false;
    }

    public final class CFIPrimtives
    implements Cloneable {
        protected int waterHeight = 0;
        protected int floorThickness = 0;
        protected int worldThickness = 0;
        protected boolean randomVariation = true;
        protected int biomePriority = 0;
        protected int waterId = BlockTypes.WATER.getInternalId();
        protected int bedrockId = 7;
        protected boolean modifiedMain = false;

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof CFIPrimtives)) {
                return false;
            }
            try {
                for (Field field : CFIPrimtives.class.getDeclaredFields()) {
                    if (field.get(this) == field.get(obj)) continue;
                    return false;
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            return true;
        }

        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }
}

