/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.jnbt.anvil;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.jnbt.NBTStreamer;
import com.boydti.fawe.jnbt.anvil.MCAChunk;
import com.boydti.fawe.object.FaweQueue;
import com.boydti.fawe.object.RunnableVal;
import com.boydti.fawe.object.RunnableVal4;
import com.boydti.fawe.object.collection.IterableThreadLocal;
import com.boydti.fawe.object.exception.FaweException;
import com.boydti.fawe.object.io.BufferedRandomAccessFile;
import com.boydti.fawe.object.io.FastByteArrayInputStream;
import com.boydti.fawe.util.MainUtil;
import com.boydti.fawe.util.MathMan;
import com.sk89q.jnbt.NBTInputStream;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class MCAFile {
    private static Field fieldBuf2;
    private static Field fieldBuf3;
    private final FaweQueue queue;
    private final File file;
    private RandomAccessFile raf;
    private byte[] locations;
    private boolean deleted;
    private final int X;
    private final int Z;
    private final Int2ObjectOpenHashMap<MCAChunk> chunks = new Int2ObjectOpenHashMap();
    final ThreadLocal<byte[]> byteStore1 = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[4096];
        }
    };
    final ThreadLocal<byte[]> byteStore2 = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[4096];
        }
    };
    final ThreadLocal<byte[]> byteStore3 = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[1024];
        }
    };

    public MCAFile(FaweQueue parent, File file) {
        this.queue = parent;
        this.file = file;
        if (!file.exists()) {
            throw new FaweException.FaweChunkLoadException();
        }
        String[] split = file.getName().split("\\.");
        this.X = Integer.parseInt(split[1]);
        this.Z = Integer.parseInt(split[2]);
    }

    public MCAFile(FaweQueue parent, int mcrX, int mcrZ) throws Exception {
        this(parent, mcrX, mcrZ, new File(parent.getSaveFolder(), "r." + mcrX + "." + mcrZ + ".mca"));
    }

    public MCAFile(FaweQueue parent, int mcrX, int mcrZ, File file) {
        this.queue = parent;
        this.file = file;
        this.X = mcrX;
        this.Z = mcrZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.raf != null) {
            try {
                this.raf.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Int2ObjectOpenHashMap<MCAChunk> int2ObjectOpenHashMap = this.chunks;
        synchronized (int2ObjectOpenHashMap) {
            this.chunks.clear();
        }
        this.locations = null;
        IterableThreadLocal.clean(this.byteStore1);
        IterableThreadLocal.clean(this.byteStore2);
        IterableThreadLocal.clean(this.byteStore3);
    }

    protected void finalize() throws Throwable {
        IterableThreadLocal.clean(this.byteStore1);
        IterableThreadLocal.clean(this.byteStore2);
        IterableThreadLocal.clean(this.byteStore3);
        super.finalize();
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public FaweQueue getParent() {
        return this.queue;
    }

    public void init() {
        try {
            if (this.raf == null) {
                this.locations = new byte[4096];
                if (this.file != null) {
                    this.raf = new RandomAccessFile(this.file, "rw");
                    if (this.raf.length() < 8192L) {
                        this.raf.setLength(8192L);
                    } else {
                        this.raf.seek(0L);
                        this.raf.readFully(this.locations);
                    }
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public int getX() {
        return this.X;
    }

    public int getZ() {
        return this.Z;
    }

    public RandomAccessFile getRandomAccessFile() {
        return this.raf;
    }

    public File getFile() {
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MCAChunk getCachedChunk(int cx, int cz) {
        int pair = MathMan.pair((short)(cx & 0x1F), (short)(cz & 0x1F));
        Int2ObjectOpenHashMap<MCAChunk> int2ObjectOpenHashMap = this.chunks;
        synchronized (int2ObjectOpenHashMap) {
            return (MCAChunk)this.chunks.get(pair);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChunk(MCAChunk chunk) {
        int cx = chunk.getX();
        int cz = chunk.getZ();
        int pair = MathMan.pair((short)(cx & 0x1F), (short)(cz & 0x1F));
        Int2ObjectOpenHashMap<MCAChunk> int2ObjectOpenHashMap = this.chunks;
        synchronized (int2ObjectOpenHashMap) {
            this.chunks.put(pair, (Object)chunk);
        }
    }

    public MCAChunk getChunk(int cx, int cz) throws IOException {
        MCAChunk cached = this.getCachedChunk(cx, cz);
        if (cached != null) {
            return cached;
        }
        return this.readChunk(cx, cz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MCAChunk readChunk(int cx, int cz) throws IOException {
        int i = ((cx & 0x1F) << 2) + ((cz & 0x1F) << 7);
        int offset = ((this.locations[i] & 0xFF) << 16) + ((this.locations[i + 1] & 0xFF) << 8) + (this.locations[i + 2] & 0xFF) << 12;
        int size = (this.locations[i + 3] & 0xFF) << 12;
        if (offset == 0) {
            return null;
        }
        NBTInputStream nis = this.getChunkIS(offset);
        MCAChunk chunk = new MCAChunk(nis, this.queue, cx, cz, false);
        nis.close();
        int pair = MathMan.pair((short)(cx & 0x1F), (short)(cz & 0x1F));
        Int2ObjectOpenHashMap<MCAChunk> int2ObjectOpenHashMap = this.chunks;
        synchronized (int2ObjectOpenHashMap) {
            this.chunks.put(pair, (Object)chunk);
        }
        return chunk;
    }

    public void forEachSortedChunk(RunnableVal4<Integer, Integer, Integer, Integer> onEach) throws IOException {
        char[] offsets = new char[(int)(this.raf.length() / 4096L) - 2];
        Arrays.fill(offsets, '\uffff');
        int i = 0;
        for (int z = 0; z < 32; ++z) {
            int x = 0;
            while (x < 32) {
                int offset = ((this.locations[i] & 0xFF) << 16) + ((this.locations[i + 1] & 0xFF) << 8) + (this.locations[i + 2] & 0xFF) - 2;
                int size = this.locations[i + 3] & 0xFF;
                if (size != 0) {
                    if (offset < offsets.length) {
                        offsets[offset] = i;
                    } else {
                        Fawe.debug("Ignoring invalid offset " + offset);
                    }
                }
                ++x;
                i = (char)(i + 4);
            }
        }
        for (i = 0; i < offsets.length; i = (int)((char)(i + 1))) {
            char index = offsets[i];
            if (index == '\uffff') continue;
            int offset = i + 2;
            int size = this.locations[index + 3] & 0xFF;
            int index2 = index >> 2;
            int x = index2 & 0x1F;
            int z = index2 >> 5;
            onEach.run(x, z, offset << 12, size << 12);
        }
    }

    public void forEachChunk(RunnableVal4<Integer, Integer, Integer, Integer> onEach) {
        int i = 0;
        for (int z = 0; z < 32; ++z) {
            int x = 0;
            while (x < 32) {
                int offset = ((this.locations[i] & 0xFF) << 16) + ((this.locations[i + 1] & 0xFF) << 8) + (this.locations[i + 2] & 0xFF);
                int size = this.locations[i + 3] & 0xFF;
                if (size != 0) {
                    onEach.run(x, z, offset << 12, size << 12);
                }
                ++x;
                i += 4;
            }
        }
    }

    public void forEachChunk(RunnableVal<MCAChunk> onEach) {
        int i = 0;
        for (int z = 0; z < 32; ++z) {
            int x = 0;
            while (x < 32) {
                int offset = ((this.locations[i] & 0xFF) << 16) + ((this.locations[i + 1] & 0xFF) << 8) + (this.locations[i + 2] & 0xFF);
                int size = this.locations[i + 3] & 0xFF;
                if (size != 0) {
                    try {
                        onEach.run(this.getChunk(x, z));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                ++x;
                i += 4;
            }
        }
    }

    public int getOffset(int cx, int cz) {
        int i = ((cx & 0x1F) << 2) + ((cz & 0x1F) << 7);
        int offset = ((this.locations[i] & 0xFF) << 16) + ((this.locations[i + 1] & 0xFF) << 8) + (this.locations[i + 2] & 0xFF);
        return offset << 12;
    }

    public int getSize(int cx, int cz) {
        int i = ((cx & 0x1F) << 2) + ((cz & 0x1F) << 7);
        return (this.locations[i + 3] & 0xFF) << 12;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> getChunks() {
        ArrayList<Integer> values;
        Int2ObjectOpenHashMap<MCAChunk> int2ObjectOpenHashMap = this.chunks;
        synchronized (int2ObjectOpenHashMap) {
            values = new ArrayList<Integer>(this.chunks.size());
        }
        for (int i = 0; i < this.locations.length; i += 4) {
            int offset = ((this.locations[i] & 0xFF) << 16) + ((this.locations[i + 1] & 0xFF) << 8) + (this.locations[i + 2] & 0xFF);
            values.add(offset);
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getChunkCompressedBytes(int offset) throws IOException {
        if (offset == 0) {
            return null;
        }
        RandomAccessFile randomAccessFile = this.raf;
        synchronized (randomAccessFile) {
            this.raf.seek(offset);
            int size = this.raf.readInt();
            int compression = this.raf.read();
            byte[] data = new byte[size];
            this.raf.readFully(data);
            return data;
        }
    }

    private NBTInputStream getChunkIS(int offset) throws IOException {
        try {
            byte[] data = this.getChunkCompressedBytes(offset);
            FastByteArrayInputStream bais = new FastByteArrayInputStream(data);
            InflaterInputStream iis = new InflaterInputStream(bais, new Inflater(), 1);
            fieldBuf2.set(iis, this.byteStore2.get());
            BufferedInputStream bis = new BufferedInputStream(iis);
            NBTInputStream nis = new NBTInputStream(bis);
            fieldBuf3.set(nis, this.byteStore3.get());
            return nis;
        }
        catch (IllegalAccessException unlikely) {
            unlikely.printStackTrace();
            return null;
        }
    }

    public void streamChunk(int cx, int cz, RunnableVal<NBTStreamer> addReaders) throws IOException {
        this.streamChunk(this.getOffset(cx, cz), addReaders);
    }

    public void streamChunk(int offset, RunnableVal<NBTStreamer> withStream) throws IOException {
        byte[] data = this.getChunkCompressedBytes(offset);
        this.streamChunk(data, withStream);
    }

    public void streamChunk(byte[] data, RunnableVal<NBTStreamer> withStream) throws IOException {
        if (data != null) {
            try {
                FastByteArrayInputStream nbtIn = new FastByteArrayInputStream(data);
                FastByteArrayInputStream bais = new FastByteArrayInputStream(data);
                InflaterInputStream iis = new InflaterInputStream(bais, new Inflater(), 1);
                fieldBuf2.set(iis, this.byteStore2.get());
                BufferedInputStream bis = new BufferedInputStream(iis);
                NBTInputStream nis = new NBTInputStream(bis);
                fieldBuf3.set(nis, this.byteStore3.get());
                NBTStreamer streamer = new NBTStreamer(nis);
                withStream.run(streamer);
                streamer.readQuick();
            }
            catch (IllegalAccessException unlikely) {
                unlikely.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachCachedChunk(RunnableVal<MCAChunk> onEach) {
        Int2ObjectOpenHashMap<MCAChunk> int2ObjectOpenHashMap = this.chunks;
        synchronized (int2ObjectOpenHashMap) {
            for (Map.Entry entry : this.chunks.entrySet()) {
                onEach.run((MCAChunk)entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MCAChunk> getCachedChunks() {
        Int2ObjectOpenHashMap<MCAChunk> int2ObjectOpenHashMap = this.chunks;
        synchronized (int2ObjectOpenHashMap) {
            return new ArrayList<MCAChunk>((Collection<MCAChunk>)this.chunks.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uncache(int cx, int cz) {
        int pair = MathMan.pair((short)(cx & 0x1F), (short)(cz & 0x1F));
        Int2ObjectOpenHashMap<MCAChunk> int2ObjectOpenHashMap = this.chunks;
        synchronized (int2ObjectOpenHashMap) {
            this.chunks.remove(pair);
        }
    }

    private byte[] toBytes(MCAChunk chunk) throws Exception {
        if (chunk.isDeleted()) {
            return null;
        }
        byte[] uncompressed = chunk.toBytes(this.byteStore3.get());
        byte[] compressed = MainUtil.compress(uncompressed, this.byteStore2.get(), null);
        return compressed;
    }

    private byte[] getChunkBytes(int cx, int cz) throws Exception {
        MCAChunk mca = this.getCachedChunk(cx, cz);
        if (mca == null) {
            int offset = this.getOffset(cx, cz);
            if (offset == 0) {
                return null;
            }
            return this.getChunkCompressedBytes(offset);
        }
        return this.toBytes(mca);
    }

    private void writeSafe(RandomAccessFile raf, int offset, byte[] data) throws IOException {
        int len = data.length + 5;
        raf.seek(offset);
        if (raf.length() - (long)offset < (long)len) {
            raf.setLength((offset + len + 4095) / 4096 * 4096);
        }
        raf.writeInt(data.length + 1);
        raf.write(2);
        raf.write(data);
    }

    private void writeHeader(RandomAccessFile raf, int cx, int cz, int offsetMedium, int sizeByte, boolean writeTime) throws IOException {
        int i = ((cx & 0x1F) << 2) + ((cz & 0x1F) << 7);
        this.locations[i] = (byte)(offsetMedium >> 16);
        this.locations[i + 1] = (byte)(offsetMedium >> 8);
        this.locations[i + 2] = (byte)offsetMedium;
        this.locations[i + 3] = (byte)sizeByte;
        raf.seek(i);
        raf.write(offsetMedium >> 16);
        raf.write(offsetMedium >> 8);
        raf.write(offsetMedium >> 0);
        raf.write(sizeByte);
        raf.seek(i + 4096);
        if (offsetMedium == 0 && sizeByte == 0) {
            raf.writeInt(0);
        } else {
            raf.writeInt((int)(System.currentTimeMillis() / 1000L));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(ForkJoinPool pool) {
        if (this.raf == null) {
            return;
        }
        RandomAccessFile randomAccessFile = this.raf;
        synchronized (randomAccessFile) {
            if (this.raf != null) {
                this.flush(pool);
                try {
                    this.raf.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.raf = null;
                this.locations = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isModified() {
        if (this.isDeleted()) {
            return true;
        }
        Int2ObjectOpenHashMap<MCAChunk> int2ObjectOpenHashMap = this.chunks;
        synchronized (int2ObjectOpenHashMap) {
            for (Int2ObjectMap.Entry entry : this.chunks.int2ObjectEntrySet()) {
                MCAChunk chunk = (MCAChunk)entry.getValue();
                if (!chunk.isModified() && !chunk.isDeleted()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(ForkJoinPool pool) {
        RandomAccessFile randomAccessFile = this.raf;
        synchronized (randomAccessFile) {
            boolean wait;
            if (this.isDeleted()) {
                this.clear();
                this.file.delete();
                return;
            }
            if (pool == null) {
                wait = true;
                pool = new ForkJoinPool();
            } else {
                wait = false;
            }
            Int2ObjectOpenHashMap relocate = new Int2ObjectOpenHashMap();
            final Int2ObjectOpenHashMap offsetMap = new Int2ObjectOpenHashMap();
            final Int2ObjectOpenHashMap compressedMap = new Int2ObjectOpenHashMap();
            final Int2ObjectOpenHashMap append = new Int2ObjectOpenHashMap();
            boolean modified = false;
            long now = System.currentTimeMillis();
            for (final MCAChunk chunk : this.getCachedChunks()) {
                if (!chunk.isModified() && !chunk.isDeleted()) continue;
                modified = true;
                chunk.setLastUpdate(now);
                if (chunk.isDeleted()) continue;
                pool.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            byte[] compressed = MCAFile.this.toBytes(chunk);
                            int pair = MathMan.pair((short)(chunk.getX() & 0x1F), (short)(chunk.getZ() & 0x1F));
                            Int2ObjectOpenHashMap map = MCAFile.this.getOffset(chunk.getX(), chunk.getZ()) == 0 ? append : compressedMap;
                            Int2ObjectOpenHashMap int2ObjectOpenHashMap = map;
                            synchronized (int2ObjectOpenHashMap) {
                                map.put(pair, (Object)compressed);
                            }
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
            if (modified) {
                int start;
                this.file.setLastModified(now);
                this.forEachChunk(new RunnableVal4<Integer, Integer, Integer, Integer>(){

                    @Override
                    public void run(Integer cx, Integer cz, Integer offset, Integer size) {
                        short pair1 = MathMan.pairByte((byte)(cx & 0x1F), (byte)(cz & 0x1F));
                        short pair2 = (short)(size >> 12);
                        offsetMap.put(offset.intValue(), (Object)MathMan.pair(pair1, pair2));
                    }
                });
                pool.awaitQuiescence(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
                int written = start = 8192;
                int end = 8192;
                int nextOffset = 8192;
                try {
                    for (int count = 0; count < offsetMap.size(); ++count) {
                        Integer loc = (Integer)offsetMap.get(nextOffset);
                        while (loc == null) {
                            loc = (Integer)offsetMap.get(nextOffset += 4096);
                        }
                        int offset = nextOffset;
                        short cxz = MathMan.unpairX(loc);
                        byte cx = MathMan.unpairShortX(cxz);
                        byte cz = MathMan.unpairShortY(cxz);
                        int size = MathMan.unpairY(loc) << 12;
                        nextOffset += size;
                        end = Math.min(start + size, end);
                        int pair = MathMan.pair((short)(cx & 0x1F), (short)(cz & 0x1F));
                        byte[] newBytes = (byte[])relocate.get(pair);
                        if (newBytes == null) {
                            MCAChunk cached = this.getCachedChunk(cx, cz);
                            if (offset == start) {
                                if (cached == null || !cached.isModified()) {
                                    this.writeHeader(this.raf, cx, cz, start >> 12, size >> 12, true);
                                    written = (start += size) + size;
                                    continue;
                                }
                                newBytes = (byte[])compressedMap.get(pair);
                            } else {
                                newBytes = (byte[])compressedMap.get(pair);
                                if (!(newBytes != null || cached != null && cached.isDeleted())) {
                                    newBytes = this.getChunkCompressedBytes(this.getOffset(cx, cz));
                                }
                            }
                        }
                        if (newBytes == null) {
                            this.writeHeader(this.raf, cx, cz, 0, 0, false);
                            continue;
                        }
                        int len = newBytes.length + 5;
                        int oldSize = size + 4095 >> 12;
                        int newSize = len + 4095 >> 12;
                        int nextOffset2 = end;
                        while (start + len > end) {
                            Integer nextLoc = (Integer)offsetMap.get(nextOffset2);
                            if (nextLoc != null) {
                                byte nextCZ;
                                short nextCXZ = MathMan.unpairX(nextLoc);
                                byte nextCX = MathMan.unpairShortX(nextCXZ);
                                MCAChunk cached = this.getCachedChunk(nextCX, nextCZ = MathMan.unpairShortY(nextCXZ));
                                if (cached == null || !cached.isModified()) {
                                    byte[] nextBytes = this.getChunkCompressedBytes(nextOffset2);
                                    relocate.put(MathMan.pair((short)(nextCX & 0x1F), (short)(nextCZ & 0x1F)), (Object)nextBytes);
                                }
                                int nextSize = MathMan.unpairY(nextLoc) << 12;
                                end += nextSize;
                                nextOffset2 += nextSize;
                                continue;
                            }
                            end += 4096;
                            nextOffset2 += 4096;
                        }
                        this.writeSafe(this.raf, start, newBytes);
                        this.writeHeader(this.raf, cx, cz, start >> 12, newSize, true);
                        written = start + newBytes.length + 5;
                        start += newSize << 12;
                    }
                    if (!append.isEmpty()) {
                        for (Int2ObjectMap.Entry entry : append.int2ObjectEntrySet()) {
                            int pair = entry.getIntKey();
                            short cx = MathMan.unpairX(pair);
                            short cz = MathMan.unpairY(pair);
                            byte[] bytes = (byte[])entry.getValue();
                            int len = bytes.length + 5;
                            int newSize = len + 4095 >> 12;
                            this.writeSafe(this.raf, start, bytes);
                            this.writeHeader(this.raf, cx, cz, start >> 12, newSize, true);
                            written = start + bytes.length + 5;
                            start += newSize << 12;
                        }
                    }
                    this.raf.setLength(4096 * ((written + 4095) / 4096));
                    if (this.raf instanceof BufferedRandomAccessFile) {
                        ((BufferedRandomAccessFile)this.raf).flush();
                    }
                    this.raf.close();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                if (wait) {
                    pool.shutdown();
                    pool.awaitQuiescence(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
                }
            }
        }
        IterableThreadLocal.clean(this.byteStore1);
        IterableThreadLocal.clean(this.byteStore2);
        IterableThreadLocal.clean(this.byteStore3);
    }

    static {
        try {
            fieldBuf2 = InflaterInputStream.class.getDeclaredField("buf");
            fieldBuf2.setAccessible(true);
            fieldBuf3 = NBTInputStream.class.getDeclaredField("buf");
            fieldBuf3.setAccessible(true);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

