/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.jnbt.anvil.generator;

import com.boydti.fawe.jnbt.anvil.generator.Resource;
import com.boydti.fawe.object.PseudoRandom;
import com.boydti.fawe.object.schematic.Schematic;
import com.sk89q.worldedit.MutableBlockVector;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.math.transform.AffineTransform;
import com.sk89q.worldedit.math.transform.Transform;
import com.sk89q.worldedit.session.ClipboardHolder;
import java.util.List;
import java.util.Random;

public class SchemGen
extends Resource {
    private final Extent extent;
    private final List<ClipboardHolder> clipboards;
    private final boolean randomRotate;
    private final Mask mask;
    private MutableBlockVector mutable = new MutableBlockVector();

    public SchemGen(Mask mask, Extent extent, List<ClipboardHolder> clipboards, boolean randomRotate) {
        this.mask = mask;
        this.extent = extent;
        this.clipboards = clipboards;
        this.randomRotate = randomRotate;
    }

    @Override
    public boolean spawn(Random random, int x, int z) throws WorldEditException {
        this.mutable.mutX(x);
        this.mutable.mutZ(z);
        int y = this.extent.getNearestSurfaceTerrainBlock(x, z, this.mutable.getBlockY(), 0, 255);
        if (y == -1) {
            return false;
        }
        this.mutable.mutY(y);
        if (!this.mask.test(this.mutable)) {
            return false;
        }
        this.mutable.mutY(y + 1);
        ClipboardHolder holder = this.clipboards.get(PseudoRandom.random.random(this.clipboards.size()));
        if (this.randomRotate) {
            holder.setTransform(new AffineTransform().rotateY(PseudoRandom.random.random(4) * 90));
        }
        Clipboard clipboard = holder.getClipboard();
        Schematic schematic = new Schematic(clipboard);
        Transform transform = holder.getTransform();
        if (transform.isIdentity()) {
            schematic.paste(this.extent, this.mutable, false);
        } else {
            schematic.paste(this.extent, this.mutable, false, transform);
        }
        this.mutable.mutY(y);
        return true;
    }
}

