/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object;

import com.boydti.fawe.object.extent.ExtentHeightCacher;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.pattern.AbstractPattern;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;

public class DataAnglePattern
extends AbstractPattern {
    public final double FACTOR;
    public final Extent extent;
    public final int maxY;
    public final int distance;

    public DataAnglePattern(Extent extent, int distance) {
        this.extent = new ExtentHeightCacher(extent);
        this.maxY = extent.getMaximumPoint().getBlockY();
        this.distance = distance;
        this.FACTOR = 1.0 / (double)distance * 0.00392156862745098;
    }

    public int getSlope(BlockStateHolder block, Vector vector) {
        int x = vector.getBlockX();
        int y = vector.getBlockY();
        int z = vector.getBlockZ();
        if (!block.getBlockType().getMaterial().isMovementBlocker()) {
            return -1;
        }
        int slope = Math.abs(this.extent.getNearestSurfaceTerrainBlock(x + this.distance, z, y, 0, this.maxY) - this.extent.getNearestSurfaceTerrainBlock(x - this.distance, z, y, 0, this.maxY)) * 7;
        slope += Math.abs(this.extent.getNearestSurfaceTerrainBlock(x, z + this.distance, y, 0, this.maxY) - this.extent.getNearestSurfaceTerrainBlock(x, z - this.distance, y, 0, this.maxY)) * 7;
        slope += Math.abs(this.extent.getNearestSurfaceTerrainBlock(x + this.distance, z + this.distance, y, 0, this.maxY) - this.extent.getNearestSurfaceTerrainBlock(x - this.distance, z - this.distance, y, 0, this.maxY)) * 5;
        return slope += Math.abs(this.extent.getNearestSurfaceTerrainBlock(x - this.distance, z + this.distance, y, 0, this.maxY) - this.extent.getNearestSurfaceTerrainBlock(x + this.distance, z - this.distance, y, 0, this.maxY)) * 5;
    }

    @Override
    public BlockStateHolder apply(Vector position) {
        BlockState block = this.extent.getBlock(position);
        int slope = this.getSlope(block, position);
        if (slope == -1) {
            return block;
        }
        int data = Math.min(slope, 255) >> 4;
        return block.withPropertyId(data);
    }

    @Override
    public boolean apply(Extent extent, Vector setPosition, Vector getPosition) throws WorldEditException {
        BlockState block = extent.getBlock(getPosition);
        int slope = this.getSlope(block, getPosition);
        if (slope == -1) {
            return false;
        }
        int data = Math.min(slope, 255) >> 4;
        return extent.setBlock(setPosition, block.withPropertyId(data));
    }
}

