/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object;

import com.boydti.fawe.object.FaweQueue;
import com.boydti.fawe.object.visitor.FaweChunkVisitor;
import com.boydti.fawe.util.MainUtil;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.world.biome.BaseBiome;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;

public abstract class FaweChunk<T>
implements Callable<FaweChunk> {
    private FaweQueue parent;
    private int x;
    private int z;
    public static int HEIGHT = 256;
    private final ArrayDeque<Runnable> tasks = new ArrayDeque(0);

    public FaweChunk(FaweQueue parent, int x, int z) {
        this.parent = parent;
        this.x = x;
        this.z = z;
    }

    public void setLoc(FaweQueue parent, int x, int z) {
        this.parent = parent;
        this.x = x;
        this.z = z;
    }

    public FaweQueue getParent() {
        return this.parent;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public long longHash() {
        return (long)this.x << 32 | (long)this.z & 0xFFFFFFFFL;
    }

    public int hashCode() {
        return this.x << 16 | this.z & 0xFFFF;
    }

    public void addToQueue() {
        this.parent.setChunk(this);
    }

    public abstract int getBitMask();

    public abstract int getBlockCombinedId(int var1, int var2, int var3);

    public void setBlock(int x, int y, int z, BlockStateHolder block) {
        this.setBlock(x, y, z, block.getInternalId());
        if (block.hasNbtData()) {
            this.setTile(x & 0xF, y, z & 0xF, block.getNbtData());
        }
    }

    public BlockState getBlock(int x, int y, int z) {
        int combined = this.getBlockCombinedId(x, y, z);
        try {
            CompoundTag tile = this.getTile(x & 0xF, y, z & 0xF);
            if (tile != null) {
                return BaseBlock.getFromInternalId(combined, tile);
            }
        }
        catch (Throwable e) {
            MainUtil.handleError(e);
        }
        return BlockState.getFromInternalId(combined);
    }

    public int[][] getCombinedIdArrays() {
        int[][] ids = new int[HEIGHT >> 4][];
        for (int layer = 0; layer < HEIGHT >> 4; ++layer) {
            ids[layer] = this.getIdArray(layer);
        }
        return ids;
    }

    @Nullable
    public int[] getIdArray(int layer) {
        int[] ids = new int[4096];
        int by = layer << 4;
        int index = 0;
        for (int y = 0; y < 16; ++y) {
            int yy = by + y;
            for (int z = 0; z < 16; ++z) {
                for (int x = 0; x < 16; ++x) {
                    ids[index++] = this.getBlockCombinedId(x, yy, z);
                }
            }
        }
        return ids;
    }

    public byte[][] getBlockLightArray() {
        return null;
    }

    public byte[][] getSkyLightArray() {
        return null;
    }

    public abstract byte[] getBiomeArray();

    public void forEachQueuedBlock(FaweChunkVisitor onEach) {
        for (int y = 0; y < HEIGHT; ++y) {
            for (int z = 0; z < 16; ++z) {
                for (int x = 0; x < 16; ++x) {
                    int combined = this.getBlockCombinedId(x, y, z);
                    if (combined == 0) continue;
                    onEach.run(x, y, z, combined);
                }
            }
        }
    }

    public void fill(int combinedId) {
        this.fillCuboid(0, 15, 0, HEIGHT - 1, 0, 15, combinedId);
    }

    public void fillCuboid(int x1, int x2, int y1, int y2, int z1, int z2, int combinedId) {
        for (int x = x1; x <= x2; ++x) {
            for (int y = y1; y <= y2; ++y) {
                for (int z = z1; z <= z2; ++z) {
                    this.setBlock(x, y, z, combinedId);
                }
            }
        }
    }

    public void addNotifyTask(Runnable run) {
        if (run != null) {
            this.tasks.add(run);
        }
    }

    public boolean hasNotifyTasks() {
        return this.tasks.size() > 0;
    }

    public void executeNotifyTasks() {
        for (Runnable task : this.tasks) {
            task.run();
        }
        this.tasks.clear();
    }

    public abstract T getChunk();

    public abstract void setTile(int var1, int var2, int var3, CompoundTag var4);

    public abstract void setEntity(CompoundTag var1);

    public abstract void removeEntity(UUID var1);

    public abstract void setBlock(int var1, int var2, int var3, int var4);

    public abstract Set<CompoundTag> getEntities();

    public abstract Set<UUID> getEntityRemoves();

    public abstract Map<Short, CompoundTag> getTiles();

    public abstract CompoundTag getTile(int var1, int var2, int var3);

    public void setBiome(int x, int z, BaseBiome biome) {
        this.setBiome(x, z, (byte)biome.getId());
    }

    public abstract void setBiome(int var1, int var2, byte var3);

    public void setBiome(byte biome) {
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                this.setBiome(x, z, biome);
            }
        }
    }

    public void optimize() {
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.hashCode() != this.hashCode() || !(obj instanceof FaweChunk)) {
            return false;
        }
        return this.longHash() != ((FaweChunk)obj).longHash();
    }

    public abstract FaweChunk<T> copy(boolean var1);

    public void start() {
    }

    public void end() {
    }

    @Override
    public abstract FaweChunk call();
}

