/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.brush;

import com.boydti.fawe.object.collection.SummedColorTable;
import com.boydti.fawe.object.mask.SurfaceMask;
import com.boydti.fawe.util.TextureUtil;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.command.tool.brush.Brush;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.function.visitor.RecursiveVisitor;
import com.sk89q.worldedit.math.transform.AffineTransform;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Arrays;

public class ImageBrush
implements Brush {
    private final LocalSession session;
    private final SummedColorTable table;
    private final int width;
    private final int height;
    private final double centerX;
    private final double centerZ;
    private final ColorFunction colorFunction;

    public ImageBrush(BufferedImage image, LocalSession session, boolean alpha) throws IOException {
        this.session = session;
        this.table = new SummedColorTable(image, alpha);
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.centerX = (double)this.width / 2.0;
        this.centerZ = (double)this.height / 2.0;
        this.colorFunction = alpha ? (x1, z1, x2, z2, extent, pos) -> {
            int color = this.table.averageRGBA(x1, z1, x2, z2);
            int alpha1 = color >> 24 & 0xFF;
            switch (alpha1) {
                case 0: {
                    return 0;
                }
                case 255: {
                    return color;
                }
            }
            BlockState block = extent.getBlock(pos);
            TextureUtil tu = session.getTextureUtil();
            int existingColor = tu.getColor(block.getBlockType());
            return tu.combineTransparency(color, existingColor);
        } : (x1, z1, x2, z2, extent, pos) -> this.table.averageRGB(x1, z1, x2, z2);
    }

    @Override
    public void build(final EditSession editSession, Vector position, Pattern pattern, double sizeDouble) throws MaxChangedBlocksException {
        final TextureUtil texture = this.session.getTextureUtil();
        final int cx = position.getBlockX();
        final int cy = position.getBlockY();
        final int cz = position.getBlockZ();
        final SurfaceMask solid = new SurfaceMask(editSession);
        final double scale = (double)Math.max(this.width, this.height) / sizeDouble;
        Location loc = editSession.getPlayer().getPlayer().getLocation();
        float yaw = loc.getYaw();
        float pitch = loc.getPitch();
        final AffineTransform transform = new AffineTransform().rotateY(-yaw % 360.0f).rotateX((pitch - 90.0f) % 360.0f).inverse();
        RecursiveVisitor visitor = new RecursiveVisitor(new Mask(){
            private final Vector mutable = new Vector();

            @Override
            public boolean test(Vector vector) {
                if (solid.test(vector)) {
                    BlockTypes block;
                    int tmp;
                    int dx = vector.getBlockX() - cx;
                    int dy = vector.getBlockY() - cy;
                    int dz = vector.getBlockZ() - cz;
                    Vector pos1 = transform.apply(this.mutable.setComponents((double)dx - 0.5, (double)dy - 0.5, (double)dz - 0.5));
                    int x1 = (int)(pos1.getX() * scale + ImageBrush.this.centerX);
                    int z1 = (int)(pos1.getZ() * scale + ImageBrush.this.centerZ);
                    Vector pos2 = transform.apply(this.mutable.setComponents((double)dx + 0.5, (double)dy + 0.5, (double)dz + 0.5));
                    int x2 = (int)(pos2.getX() * scale + ImageBrush.this.centerX);
                    int z2 = (int)(pos2.getZ() * scale + ImageBrush.this.centerZ);
                    if (x2 < x1) {
                        tmp = x1;
                        x1 = x2;
                        x2 = tmp;
                    }
                    if (z2 < z1) {
                        tmp = z1;
                        z1 = z2;
                        z2 = tmp;
                    }
                    if (x1 >= ImageBrush.this.width || x2 < 0 || z1 >= ImageBrush.this.height || z2 < 0) {
                        return false;
                    }
                    int color = ImageBrush.this.colorFunction.call(x1, z1, x2, z2, editSession, vector);
                    if (color != 0 && (block = texture.getNearestBlock(color)) != null) {
                        editSession.setBlock(vector, block.getDefaultState());
                    }
                    return true;
                }
                return false;
            }
        }, vector -> true, Integer.MAX_VALUE, editSession);
        visitor.setDirections(Arrays.asList(RecursiveVisitor.DIAGONAL_DIRECTIONS));
        visitor.visit(position);
        Operations.completeBlindly(visitor);
    }

    private void apply(double val) {
    }

    private static interface BlockFunction {
        public void apply(int var1, Extent var2, Vector var3);
    }

    private static interface ColorFunction {
        public int call(int var1, int var2, int var3, int var4, Extent var5, Vector var6);
    }
}

