/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.brush.sweep;

import com.boydti.fawe.config.BBC;
import com.boydti.fawe.object.FawePlayer;
import com.boydti.fawe.object.brush.ResettableTool;
import com.boydti.fawe.object.brush.sweep.ClipboardSpline;
import com.boydti.fawe.object.brush.visualization.VisualExtent;
import com.boydti.fawe.util.MathMan;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.EmptyClipboardException;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.command.tool.brush.Brush;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.interpolation.KochanekBartelsInterpolation;
import com.sk89q.worldedit.math.interpolation.Node;
import com.sk89q.worldedit.math.transform.AffineTransform;
import com.sk89q.worldedit.session.ClipboardHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class SweepBrush
implements Brush,
ResettableTool {
    private List<Vector> positions = new ArrayList<Vector>();
    private Vector position;
    private int copies;
    private static final double tension = 0.0;
    private static final double bias = 0.0;
    private static final double continuity = 0.0;

    public SweepBrush(int copies) {
        this.copies = copies > 0 ? copies : -1;
    }

    @Override
    public void build(EditSession editSession, Vector position, Pattern pattern, double size) throws MaxChangedBlocksException {
        boolean visualization = editSession.getExtent() instanceof VisualExtent;
        if (visualization && this.positions.isEmpty()) {
            return;
        }
        boolean newPos = this.position == null || !position.equals(this.position);
        this.position = position;
        FawePlayer player = editSession.getPlayer();
        if (newPos) {
            BBC.BRUSH_SPLINE_PRIMARY_2.send(player, new Object[0]);
            this.positions.add(position);
            return;
        }
        if (this.positions.size() < 2) {
            BBC.BRUSH_SPLINE_SECONDARY_ERROR.send(player, new Object[0]);
            return;
        }
        KochanekBartelsInterpolation interpol = new KochanekBartelsInterpolation();
        List<Node> nodes = this.positions.stream().map(v -> {
            Node n = new Node((Vector)v);
            n.setTension(0.0);
            n.setBias(0.0);
            n.setContinuity(0.0);
            return n;
        }).collect(Collectors.toList());
        interpol.setNodes(nodes);
        LocalSession session = player.getSession();
        ClipboardHolder holder = session.getExistingClipboard();
        if (holder == null) {
            throw new RuntimeException(new EmptyClipboardException());
        }
        Clipboard clipboard = holder.getClipboard();
        Vector dimensions = clipboard.getDimensions();
        AffineTransform transform = new AffineTransform();
        if (dimensions.getBlockX() > dimensions.getBlockZ()) {
            transform = transform.rotateY(90.0);
        }
        double quality = Math.max(dimensions.getBlockX(), dimensions.getBlockZ());
        ClipboardSpline spline = new ClipboardSpline(editSession, holder, interpol, transform, nodes.size());
        switch (this.copies) {
            case 1: {
                spline.pastePosition(0.0);
                break;
            }
            case -1: {
                double splineLength = interpol.arcLength(0.0, 1.0);
                double blockDistance = 1.0 / splineLength;
                double step = blockDistance / quality;
                double accumulation = 0.0;
                Vector last = null;
                for (double pos = 0.0; pos <= 1.0; pos += step) {
                    double d;
                    Vector gradient = interpol.get1stDerivative(pos);
                    if (last == null) {
                        last = new Vector(interpol.get1stDerivative(pos));
                    }
                    double dist = MathMan.sqrtApprox(last.distanceSq(gradient));
                    last.mutX(gradient.getX());
                    last.mutY(gradient.getY());
                    last.mutZ(gradient.getZ());
                    double change = dist * step;
                    accumulation += change + step * 2.0;
                    if (!(d > blockDistance)) continue;
                    accumulation -= blockDistance;
                    spline.pastePosition(pos);
                }
                break;
            }
            default: {
                for (double pos = 0.0; pos <= 1.0; pos += 1.0 / (double)(this.copies - 1)) {
                    spline.pastePosition(pos);
                }
            }
        }
        BBC.BRUSH_SPLINE_SECONDARY.send(player, new Object[0]);
        this.reset();
    }

    @Override
    public boolean reset() {
        this.positions.clear();
        this.position = null;
        return true;
    }
}

