/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.change;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.object.FaweQueue;
import com.boydti.fawe.object.HasFaweQueue;
import com.boydti.fawe.util.ExtentTraverser;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.history.UndoContext;
import com.sk89q.worldedit.history.change.Change;

public class MutableBlockChange
implements Change {
    public int z;
    public int y;
    public int x;
    public int combinedId;
    private FaweQueue queue;
    private boolean checkedQueue;

    public MutableBlockChange(int x, int y, int z, int combinedId) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.combinedId = combinedId;
    }

    @Override
    public void undo(UndoContext context) throws WorldEditException {
        this.create(context);
    }

    @Override
    public void redo(UndoContext context) throws WorldEditException {
        this.create(context);
    }

    public void create(UndoContext context) {
        if (this.queue != null) {
            this.queue.setBlock(this.x, this.y, this.z, this.combinedId);
        }
        if (!this.checkedQueue) {
            this.checkedQueue = true;
            Extent extent = context.getExtent();
            ExtentTraverser<HasFaweQueue> found = new ExtentTraverser<Extent>(extent).find(HasFaweQueue.class);
            if (found != null) {
                this.queue = found.get().getQueue();
                this.queue.setBlock(this.x, this.y, this.z, this.combinedId);
            } else {
                Fawe.debug("FAWE does not support: " + extent + " for " + this.getClass() + " (bug Empire92)");
            }
        }
    }
}

