/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.clipboard;

import com.boydti.fawe.FaweCache;
import com.boydti.fawe.jnbt.NBTStreamer;
import com.boydti.fawe.object.IntegerTrio;
import com.boydti.fawe.object.clipboard.FaweClipboard;
import com.boydti.fawe.util.ReflectionUtils;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.IntTag;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.world.biome.BaseBiome;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class CPUOptimizedClipboard
extends FaweClipboard {
    private int length;
    private int height;
    private int width;
    private int area;
    private int volume;
    private byte[] biomes = null;
    private int[] states;
    private final HashMap<IntegerTrio, CompoundTag> nbtMapLoc;
    private final HashMap<Integer, CompoundTag> nbtMapIndex;
    private final HashSet<FaweClipboard.ClipboardEntity> entities;
    private int ylast;
    private int ylasti;
    private int zlast;
    private int zlasti;

    public CPUOptimizedClipboard(int width, int height, int length) {
        this.width = width;
        this.height = height;
        this.length = length;
        this.area = width * length;
        this.volume = this.area * height;
        this.states = new int[this.volume];
        this.nbtMapLoc = new HashMap();
        this.nbtMapIndex = new HashMap();
        this.entities = new HashSet();
    }

    @Override
    public boolean hasBiomes() {
        return this.biomes != null;
    }

    @Override
    public boolean setBiome(int x, int z, int biome) {
        this.setBiome(this.getIndex(x, 0, z), biome);
        return true;
    }

    @Override
    public void setBiome(int index, int biome) {
        if (this.biomes == null) {
            this.biomes = new byte[this.area];
        }
        this.biomes[index] = (byte)biome;
    }

    @Override
    public void streamBiomes(NBTStreamer.ByteReader task) {
        if (!this.hasBiomes()) {
            return;
        }
        int index = 0;
        for (int z = 0; z < this.length; ++z) {
            int x = 0;
            while (x < this.width) {
                task.run(index, this.biomes[index] & 0xFF);
                ++x;
                ++index;
            }
        }
    }

    @Override
    public BaseBiome getBiome(int index) {
        if (!this.hasBiomes()) {
            return EditSession.nullBiome;
        }
        return FaweCache.CACHE_BIOME[this.biomes[index] & 0xFF];
    }

    @Override
    public BaseBiome getBiome(int x, int z) {
        return this.getBiome(this.getIndex(x, 0, z));
    }

    public void convertTilesToIndex() {
        if (this.nbtMapLoc.isEmpty()) {
            return;
        }
        for (Map.Entry<IntegerTrio, CompoundTag> entry : this.nbtMapLoc.entrySet()) {
            IntegerTrio key = entry.getKey();
            this.setTile(this.getIndex(key.x, key.y, key.z), entry.getValue());
        }
        this.nbtMapLoc.clear();
    }

    private CompoundTag getTag(int index) {
        this.convertTilesToIndex();
        return this.nbtMapIndex.get(index);
    }

    @Override
    public void setDimensions(Vector dimensions) {
        this.width = dimensions.getBlockX();
        this.height = dimensions.getBlockY();
        this.length = dimensions.getBlockZ();
        this.area = this.width * this.length;
        int newVolume = this.area * this.height;
        if (newVolume != this.volume) {
            this.volume = newVolume;
            this.states = new int[this.volume];
        }
    }

    @Override
    public Vector getDimensions() {
        return new Vector(this.width, this.height, this.length);
    }

    public int getIndex(int x, int y, int z) {
        int n;
        int n2;
        if (this.ylast == y) {
            n2 = this.ylasti;
        } else {
            this.ylast = y;
            n2 = this.ylasti = this.ylast * this.area;
        }
        int n3 = x + n2;
        if (this.zlast == z) {
            n = this.zlasti;
        } else {
            this.zlast = z;
            n = this.zlasti = this.zlast * this.width;
        }
        return n3 + n;
    }

    @Override
    public BlockState getBlock(int x, int y, int z) {
        int index = this.getIndex(x, y, z);
        return this.getBlock(index);
    }

    @Override
    public BlockState getBlock(int index) {
        CompoundTag nbt;
        int combinedId = this.states[index];
        BlockTypes type = BlockTypes.getFromStateId(combinedId);
        BlockState state = type.withStateId(combinedId);
        if (type.getMaterial().hasContainer() && (nbt = this.getTag(index)) != null) {
            return new BaseBlock(state, nbt);
        }
        return state;
    }

    @Override
    public void forEach(FaweClipboard.BlockReader task, boolean air) {
        if (air) {
            int index = 0;
            for (int y = 0; y < this.height; ++y) {
                for (int z = 0; z < this.length; ++z) {
                    int x = 0;
                    while (x < this.width) {
                        BlockState block = this.getBlock(index);
                        task.run(x, y, z, block);
                        ++x;
                        ++index;
                    }
                }
            }
        } else {
            int index = 0;
            for (int y = 0; y < this.height; ++y) {
                for (int z = 0; z < this.length; ++z) {
                    int x = 0;
                    while (x < this.width) {
                        BlockState block = this.getBlock(index);
                        switch (block.getBlockType()) {
                            case AIR: 
                            case CAVE_AIR: 
                            case VOID_AIR: {
                                break;
                            }
                            default: {
                                task.run(x, y, z, block);
                            }
                        }
                        ++x;
                        ++index;
                    }
                }
            }
        }
    }

    @Override
    public void streamCombinedIds(NBTStreamer.ByteReader task) {
        int index = 0;
        for (int y = 0; y < this.height; ++y) {
            for (int z = 0; z < this.length; ++z) {
                for (int x = 0; x < this.width; ++x) {
                    task.run(index, this.states[index++]);
                }
            }
        }
    }

    @Override
    public List<CompoundTag> getTileEntities() {
        this.convertTilesToIndex();
        for (Map.Entry<Integer, CompoundTag> entry : this.nbtMapIndex.entrySet()) {
            int index = entry.getKey();
            CompoundTag tag = entry.getValue();
            Map values = ReflectionUtils.getMap(tag.getValue());
            if (values.containsKey("x")) continue;
            int y = index / this.area;
            int z = (index -= y * this.area) / this.width;
            int x = index - z * this.width;
            values.put("x", new IntTag(x));
            values.put("y", new IntTag(y));
            values.put("z", new IntTag(z));
        }
        return new ArrayList<CompoundTag>(this.nbtMapIndex.values());
    }

    @Override
    public boolean setTile(int x, int y, int z, CompoundTag tag) {
        this.nbtMapLoc.put(new IntegerTrio(x, y, z), tag);
        return true;
    }

    public boolean setTile(int index, CompoundTag tag) {
        this.nbtMapIndex.put(index, tag);
        Map values = ReflectionUtils.getMap(tag.getValue());
        values.remove("x");
        values.remove("y");
        values.remove("z");
        return true;
    }

    @Override
    public boolean setBlock(int x, int y, int z, BlockStateHolder block) {
        return this.setBlock(this.getIndex(x, y, z), block);
    }

    @Override
    public boolean setBlock(int index, BlockStateHolder block) {
        this.states[index] = block.getInternalId();
        CompoundTag tile = block.getNbtData();
        if (tile != null) {
            this.setTile(index, tile);
        }
        return true;
    }

    @Override
    public Entity createEntity(Extent world, double x, double y, double z, float yaw, float pitch, BaseEntity entity) {
        FaweClipboard.ClipboardEntity ret = new FaweClipboard.ClipboardEntity(world, x, y, z, yaw, pitch, entity);
        this.entities.add(ret);
        return ret;
    }

    @Override
    public List<? extends Entity> getEntities() {
        return new ArrayList<FaweClipboard.ClipboardEntity>(this.entities);
    }

    @Override
    public boolean remove(FaweClipboard.ClipboardEntity clipboardEntity) {
        return this.entities.remove(clipboardEntity);
    }
}

