/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.clipboard;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.FaweCache;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.jnbt.NBTStreamer;
import com.boydti.fawe.object.IntegerTrio;
import com.boydti.fawe.object.clipboard.FaweClipboard;
import com.boydti.fawe.util.MainUtil;
import com.boydti.fawe.util.ReflectionUtils;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.IntTag;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.BlockArrayClipboard;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.world.biome.BaseBiome;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class DiskOptimizedClipboard
extends FaweClipboard
implements Closeable {
    public static int COMPRESSION = 0;
    public static int MODE = 0;
    public static int HEADER_SIZE = 14;
    protected int length;
    protected int height;
    protected int width;
    protected int area;
    protected int volume;
    private final HashMap<IntegerTrio, CompoundTag> nbtMap;
    private final HashSet<FaweClipboard.ClipboardEntity> entities;
    private final File file;
    private RandomAccessFile braf;
    private MappedByteBuffer mbb;
    private FileChannel fc;
    private boolean hasBiomes;
    private int ylast;
    private int ylasti;
    private int zlast;
    private int zlasti;

    public DiskOptimizedClipboard(int width, int height, int length, UUID uuid) {
        this(width, height, length, MainUtil.getFile(Fawe.get() != null ? Fawe.imp().getDirectory() : new File("."), Settings.IMP.PATHS.CLIPBOARD + File.separator + uuid + ".bd"));
    }

    public DiskOptimizedClipboard(File file) {
        try {
            this.nbtMap = new HashMap();
            this.entities = new HashSet();
            this.file = file;
            this.braf = new RandomAccessFile(file, "rw");
            this.braf.setLength(file.length());
            this.init();
            this.width = this.mbb.getChar(2);
            this.height = this.mbb.getChar(4);
            this.length = this.mbb.getChar(6);
            this.area = this.width * this.length;
            this.volume = this.length * this.width * this.height;
            if (this.braf.length() - (long)HEADER_SIZE == (long)((this.volume << 2) + this.area)) {
                this.hasBiomes = true;
            }
            this.autoCloseTask();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public File getFile() {
        return this.file;
    }

    private void init() throws IOException {
        if (this.fc == null) {
            this.fc = this.braf.getChannel();
            this.mbb = this.fc.map(FileChannel.MapMode.READ_WRITE, 0L, this.file.length());
        }
    }

    private boolean initBiome() {
        if (!this.hasBiomes) {
            try {
                this.hasBiomes = true;
                this.close();
                this.braf = new RandomAccessFile(this.file, "rw");
                this.braf.setLength(HEADER_SIZE + (this.volume << 2) + this.area);
                this.init();
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean hasBiomes() {
        return this.hasBiomes;
    }

    @Override
    public boolean setBiome(int x, int z, int biome) {
        this.setBiome(this.getIndex(x, 0, z), biome);
        return true;
    }

    @Override
    public void setBiome(int index, int biome) {
        if (this.initBiome()) {
            this.mbb.put(HEADER_SIZE + (this.volume << 2) + index, (byte)biome);
        }
    }

    @Override
    public BaseBiome getBiome(int index) {
        if (!this.hasBiomes()) {
            return EditSession.nullBiome;
        }
        int biomeId = this.mbb.get(HEADER_SIZE + (this.volume << 2) + index) & 0xFF;
        return FaweCache.CACHE_BIOME[biomeId];
    }

    @Override
    public void streamBiomes(NBTStreamer.ByteReader task) {
        if (!this.hasBiomes()) {
            return;
        }
        int index = 0;
        int mbbIndex = HEADER_SIZE + (this.volume << 2);
        for (int z = 0; z < this.length; ++z) {
            int x = 0;
            while (x < this.width) {
                int biome = this.mbb.get(mbbIndex) & 0xFF;
                task.run(index, biome);
                ++x;
                ++index;
                ++mbbIndex;
            }
        }
    }

    @Override
    public BaseBiome getBiome(int x, int z) {
        return this.getBiome(this.getIndex(x, 0, z));
    }

    @Override
    public Vector getDimensions() {
        return new Vector(this.width, this.height, this.length);
    }

    public BlockArrayClipboard toClipboard() {
        try {
            CuboidRegion region = new CuboidRegion(new Vector(0, 0, 0), new Vector(this.width - 1, this.height - 1, this.length - 1));
            short ox = this.mbb.getShort(8);
            short oy = this.mbb.getShort(10);
            short oz = this.mbb.getShort(12);
            BlockArrayClipboard clipboard = new BlockArrayClipboard((Region)region, this);
            clipboard.setOrigin(new Vector(ox, oy, oz));
            return clipboard;
        }
        catch (Throwable e) {
            MainUtil.handleError(e);
            return null;
        }
    }

    public DiskOptimizedClipboard(int width, int height, int length, File file) {
        try {
            this.nbtMap = new HashMap();
            this.entities = new HashSet();
            this.file = file;
            this.width = width;
            this.height = height;
            this.length = length;
            this.area = width * length;
            this.volume = width * length * height;
            try {
                if (!file.exists()) {
                    File parent = file.getParentFile();
                    if (parent != null) {
                        file.getParentFile().mkdirs();
                    }
                    file.createNewFile();
                }
            }
            catch (Exception e) {
                MainUtil.handleError(e);
            }
            this.braf = new RandomAccessFile(file, "rw");
            long volume = (long)width * (long)height * (long)length * 4L + (long)HEADER_SIZE;
            this.braf.setLength(0L);
            this.braf.setLength(volume);
            if (width * height * length != 0) {
                this.init();
                this.mbb.putChar(2, (char)width);
                this.mbb.putChar(4, (char)height);
                this.mbb.putChar(6, (char)length);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setOrigin(Vector offset) {
        try {
            this.mbb.putShort(8, (short)offset.getBlockX());
            this.mbb.putShort(10, (short)offset.getBlockY());
            this.mbb.putShort(12, (short)offset.getBlockZ());
        }
        catch (Throwable e) {
            MainUtil.handleError(e);
        }
    }

    @Override
    public void setDimensions(Vector dimensions) {
        try {
            this.width = dimensions.getBlockX();
            this.height = dimensions.getBlockY();
            this.length = dimensions.getBlockZ();
            this.area = this.width * this.length;
            this.volume = this.width * this.length * this.height;
            long size = (long)(this.width * this.height * this.length) * 4L + (long)HEADER_SIZE + (long)(this.hasBiomes() ? this.area : 0);
            if (this.braf.length() < size) {
                this.close();
                this.braf = new RandomAccessFile(this.file, "rw");
                this.braf.setLength(size);
                this.init();
            }
            this.mbb.putChar(2, (char)this.width);
            this.mbb.putChar(4, (char)this.height);
            this.mbb.putChar(6, (char)this.length);
        }
        catch (IOException e) {
            MainUtil.handleError(e);
        }
    }

    @Override
    public void flush() {
        this.mbb.force();
    }

    public DiskOptimizedClipboard(int width, int height, int length) {
        this(width, height, length, MainUtil.getFile(Fawe.imp() != null ? Fawe.imp().getDirectory() : new File("."), Settings.IMP.PATHS.CLIPBOARD + File.separator + UUID.randomUUID() + ".bd"));
    }

    private void closeDirectBuffer(ByteBuffer cb) {
        if (cb == null || !cb.isDirect()) {
            return;
        }
        try {
            Method cleaner = cb.getClass().getMethod("cleaner", new Class[0]);
            cleaner.setAccessible(true);
            Method clean = Class.forName("sun.misc.Cleaner").getMethod("clean", new Class[0]);
            clean.setAccessible(true);
            clean.invoke(cleaner.invoke((Object)cb, new Object[0]), new Object[0]);
        }
        catch (Exception ex) {
            try {
                Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
                Field theUnsafeField = unsafeClass.getDeclaredField("theUnsafe");
                theUnsafeField.setAccessible(true);
                Object theUnsafe = theUnsafeField.get(null);
                Method invokeCleanerMethod = unsafeClass.getMethod("invokeCleaner", ByteBuffer.class);
                invokeCleanerMethod.invoke(theUnsafe, cb);
            }
            catch (Exception e) {
                System.gc();
            }
        }
        cb = null;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    @Override
    public void close() {
        try {
            if (this.mbb != null) {
                this.mbb.force();
                this.fc.close();
                this.braf.close();
                this.file.setWritable(true);
                this.closeDirectBuffer(this.mbb);
                this.mbb = null;
                this.fc = null;
                this.braf = null;
            }
        }
        catch (IOException e) {
            MainUtil.handleError(e);
        }
    }

    private void autoCloseTask() {
    }

    @Override
    public void streamCombinedIds(NBTStreamer.ByteReader task) {
        try {
            this.mbb.force();
            int pos = HEADER_SIZE;
            int index = 0;
            for (int y = 0; y < this.height; ++y) {
                for (int z = 0; z < this.length; ++z) {
                    int x = 0;
                    while (x < this.width) {
                        int combinedId = this.mbb.getInt(pos);
                        task.run(index++, combinedId);
                        ++x;
                        pos += 4;
                    }
                }
            }
        }
        catch (Throwable e) {
            MainUtil.handleError(e);
        }
    }

    @Override
    public List<CompoundTag> getTileEntities() {
        return new ArrayList<CompoundTag>(this.nbtMap.values());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void forEach(FaweClipboard.BlockReader task, boolean air) {
        boolean hasTile;
        this.mbb.force();
        int pos = HEADER_SIZE;
        IntegerTrio trio = new IntegerTrio();
        boolean bl = hasTile = !this.nbtMap.isEmpty();
        if (air) {
            if (hasTile) {
                block3: for (int y = 0; y < this.height; ++y) {
                    int z = 0;
                    while (true) {
                        if (z >= this.length) continue block3;
                        for (int x = 0; x < this.width; ++x, pos += 4) {
                            int combinedId = this.mbb.getInt(pos);
                            BlockTypes type = BlockTypes.getFromStateId(combinedId);
                            BlockState state = type.withStateId(combinedId);
                            if (type.getMaterial().hasContainer()) {
                                trio.set(x, y, z);
                                CompoundTag nbt = this.nbtMap.get(trio);
                                if (nbt != null) {
                                    BaseBlock block = new BaseBlock(state, nbt);
                                    task.run(x, y, z, block);
                                    continue;
                                }
                            }
                            task.run(x, y, z, state);
                        }
                        ++z;
                    }
                }
                return;
            }
            for (int y = 0; y < this.height; ++y) {
                for (int z = 0; z < this.length; ++z) {
                    for (int x = 0; x < this.width; ++x, pos += 4) {
                        int combinedId = this.mbb.getInt(pos);
                        BlockState state = BlockState.getFromInternalId(combinedId);
                        task.run(x, y, z, state);
                    }
                }
            }
            return;
        }
        block9: for (int y = 0; y < this.height; ++y) {
            int z = 0;
            while (true) {
                if (z >= this.length) continue block9;
                block11: for (int x = 0; x < this.width; ++x, pos += 4) {
                    int combinedId = this.mbb.getInt(pos);
                    BlockTypes type = BlockTypes.getFromStateId(combinedId);
                    switch (type) {
                        case AIR: 
                        case CAVE_AIR: 
                        case VOID_AIR: {
                            continue block11;
                        }
                        default: {
                            BlockState state = type.withStateId(combinedId);
                            if (type.getMaterial().hasContainer()) {
                                trio.set(x, y, z);
                                CompoundTag nbt = this.nbtMap.get(trio);
                                if (nbt != null) {
                                    BaseBlock block = new BaseBlock(state, nbt);
                                    task.run(x, y, z, block);
                                    continue block11;
                                }
                            }
                            task.run(x, y, z, state);
                        }
                    }
                }
                ++z;
            }
        }
    }

    public int getIndex(int x, int y, int z) {
        int n;
        int n2;
        if (this.ylast == y) {
            n2 = this.ylasti;
        } else {
            this.ylast = y;
            n2 = this.ylasti = this.ylast * this.area;
        }
        int n3 = x + n2;
        if (this.zlast == z) {
            n = this.zlasti;
        } else {
            this.zlast = z;
            n = this.zlasti = this.zlast * this.width;
        }
        return n3 + n;
    }

    @Override
    public BlockState getBlock(int x, int y, int z) {
        try {
            CompoundTag nbt;
            int index = HEADER_SIZE + (this.getIndex(x, y, z) << 2);
            int combinedId = this.mbb.getInt(index);
            BlockTypes type = BlockTypes.getFromStateId(combinedId);
            BlockState state = type.withStateId(combinedId);
            if (type.getMaterial().hasContainer() && !this.nbtMap.isEmpty() && (nbt = this.nbtMap.get(new IntegerTrio(x, y, z))) != null) {
                return new BaseBlock(state, nbt);
            }
            return state;
        }
        catch (IndexOutOfBoundsException index) {
        }
        catch (Exception e) {
            e.printStackTrace();
            MainUtil.handleError(e);
        }
        return EditSession.nullBlock;
    }

    @Override
    public BlockState getBlock(int i) {
        try {
            int diskIndex = HEADER_SIZE + (i << 2);
            int combinedId = this.mbb.getInt(diskIndex);
            BlockTypes type = BlockTypes.getFromStateId(combinedId);
            BlockState state = type.withStateId(combinedId);
            if (type.getMaterial().hasContainer() && !this.nbtMap.isEmpty()) {
                CompoundTag nbt;
                if (this.nbtMap.size() < 4) {
                    nbt = null;
                    for (Map.Entry<IntegerTrio, CompoundTag> entry : this.nbtMap.entrySet()) {
                        IntegerTrio key = entry.getKey();
                        int index = this.getIndex(key.x, key.y, key.z);
                        if (index != i) continue;
                        nbt = entry.getValue();
                        break;
                    }
                } else {
                    int y = i / this.area;
                    int newI = i - y * this.area;
                    int z = newI / this.width;
                    int x = newI - z * this.width;
                    nbt = this.nbtMap.get(new IntegerTrio(x, y, z));
                }
                if (nbt != null) {
                    return new BaseBlock(state, nbt);
                }
            }
            return state;
        }
        catch (IndexOutOfBoundsException diskIndex) {
        }
        catch (Exception e) {
            MainUtil.handleError(e);
        }
        return EditSession.nullBlock;
    }

    @Override
    public boolean setTile(int x, int y, int z, CompoundTag tag) {
        this.nbtMap.put(new IntegerTrio(x, y, z), tag);
        Map values = ReflectionUtils.getMap(tag.getValue());
        values.put("x", new IntTag(x));
        values.put("y", new IntTag(y));
        values.put("z", new IntTag(z));
        return true;
    }

    @Override
    public boolean setBlock(int x, int y, int z, BlockStateHolder block) {
        try {
            int index = HEADER_SIZE + (this.getIndex(x, y, z) << 2);
            int combined = block.getInternalId();
            this.mbb.putInt(index, combined);
            CompoundTag tile = block.getNbtData();
            if (tile != null) {
                this.setTile(x, y, z, tile);
            }
            return true;
        }
        catch (Exception e) {
            MainUtil.handleError(e);
            return false;
        }
    }

    @Override
    public boolean setBlock(int i, BlockStateHolder block) {
        try {
            int combined = block.getInternalId();
            int index = HEADER_SIZE + (i << 2);
            this.mbb.putInt(index, combined);
            CompoundTag tile = block.getNbtData();
            if (tile != null) {
                int y = i / this.area;
                int newI = i - y * this.area;
                int z = newI / this.width;
                int x = newI - z * this.width;
                this.setTile(x, y, z, tile);
            }
            return true;
        }
        catch (Exception e) {
            MainUtil.handleError(e);
            return false;
        }
    }

    @Override
    public Entity createEntity(Extent world, double x, double y, double z, float yaw, float pitch, BaseEntity entity) {
        FaweClipboard.ClipboardEntity ret = new FaweClipboard.ClipboardEntity(world, x, y, z, yaw, pitch, entity);
        this.entities.add(ret);
        return ret;
    }

    @Override
    public List<? extends Entity> getEntities() {
        return new ArrayList<FaweClipboard.ClipboardEntity>(this.entities);
    }

    @Override
    public boolean remove(FaweClipboard.ClipboardEntity clipboardEntity) {
        return this.entities.remove(clipboardEntity);
    }
}

