/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.clipboard;

import com.boydti.fawe.object.clipboard.FaweClipboard;
import com.boydti.fawe.object.clipboard.ReadOnlyClipboard;
import com.boydti.fawe.util.ReflectionUtils;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.IntTag;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MutableBlockVector2D;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.RegionFunction;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.function.visitor.RegionVisitor;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.world.biome.BaseBiome;
import com.sk89q.worldedit.world.block.BlockState;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class WorldCopyClipboard
extends ReadOnlyClipboard {
    public final int mx;
    public final int my;
    public final int mz;
    private final boolean hasBiomes;
    private final boolean hasEntities;
    private MutableBlockVector2D mutableBlockVector2D = new MutableBlockVector2D();
    public final Extent extent;

    public WorldCopyClipboard(Extent editSession, Region region) {
        this(editSession, region, true, false);
    }

    public WorldCopyClipboard(Extent editSession, Region region, boolean hasEntities, boolean hasBiomes) {
        super(region);
        this.hasBiomes = hasBiomes;
        this.hasEntities = hasEntities;
        Vector origin = region.getMinimumPoint();
        this.mx = origin.getBlockX();
        this.my = origin.getBlockY();
        this.mz = origin.getBlockZ();
        this.extent = editSession;
    }

    @Override
    public BlockState getBlock(int x, int y, int z) {
        return this.extent.getLazyBlock(this.mx + x, this.my + y, this.mz + z);
    }

    public BlockState getBlockAbs(int x, int y, int z) {
        return this.extent.getLazyBlock(x, y, z);
    }

    @Override
    public BaseBiome getBiome(int x, int z) {
        return this.extent.getBiome(this.mutableBlockVector2D.setComponents(this.mx + x, this.mz + z));
    }

    @Override
    public List<? extends Entity> getEntities() {
        if (!this.hasEntities) {
            return new ArrayList();
        }
        return this.extent.getEntities(this.getRegion());
    }

    @Override
    public boolean hasBiomes() {
        return this.hasBiomes;
    }

    @Override
    public void forEach(final FaweClipboard.BlockReader task, boolean air) {
        Vector min = this.region.getMinimumPoint();
        Vector max = this.region.getMaximumPoint();
        Vector pos = new Vector();
        if (this.region instanceof CuboidRegion) {
            if (air) {
                ((CuboidRegion)this.region).setUseOldIterator(true);
                RegionVisitor visitor = new RegionVisitor(this.region, new RegionFunction(){

                    @Override
                    public boolean apply(Vector pos) throws WorldEditException {
                        BlockState block = WorldCopyClipboard.this.getBlockAbs(pos.getBlockX(), pos.getBlockY(), pos.getBlockZ());
                        int x = pos.getBlockX() - WorldCopyClipboard.this.mx;
                        int y = pos.getBlockY() - WorldCopyClipboard.this.my;
                        int z = pos.getBlockZ() - WorldCopyClipboard.this.mz;
                        CompoundTag tag = block.getNbtData();
                        if (tag != null) {
                            Map values = ReflectionUtils.getMap(tag.getValue());
                            values.put("x", new IntTag(x));
                            values.put("y", new IntTag(y));
                            values.put("z", new IntTag(z));
                        }
                        task.run(x, y, z, block);
                        return true;
                    }
                }, this.extent instanceof EditSession ? (EditSession)this.extent : null);
                Operations.completeBlindly(visitor);
            } else {
                CuboidRegion cuboidEquivalent = new CuboidRegion(this.region.getMinimumPoint(), this.region.getMaximumPoint());
                cuboidEquivalent.setUseOldIterator(true);
                RegionVisitor visitor = new RegionVisitor((Region)cuboidEquivalent, new RegionFunction(){

                    @Override
                    public boolean apply(Vector pos) throws WorldEditException {
                        int x = pos.getBlockX() - WorldCopyClipboard.this.mx;
                        int y = pos.getBlockY() - WorldCopyClipboard.this.my;
                        int z = pos.getBlockZ() - WorldCopyClipboard.this.mz;
                        if (WorldCopyClipboard.this.region.contains(pos)) {
                            BlockState block = WorldCopyClipboard.this.getBlockAbs(pos.getBlockX(), pos.getBlockY(), pos.getBlockZ());
                            CompoundTag tag = block.getNbtData();
                            if (tag != null) {
                                Map values = ReflectionUtils.getMap(tag.getValue());
                                values.put("x", new IntTag(x));
                                values.put("y", new IntTag(y));
                                values.put("z", new IntTag(z));
                            }
                            if (!block.getBlockType().getMaterial().isAir()) {
                                task.run(x, y, z, block);
                            }
                        }
                        return true;
                    }
                }, this.extent instanceof EditSession ? (EditSession)this.extent : null);
                Operations.completeBlindly(visitor);
            }
        } else {
            for (int y = min.getBlockY(); y <= max.getBlockY(); ++y) {
                pos.mutY(y);
                int yy = pos.getBlockY() - this.my;
                for (int z = min.getBlockZ(); z <= max.getBlockZ(); ++z) {
                    pos.mutZ(z);
                    int zz = pos.getBlockZ() - this.mz;
                    for (int x = min.getBlockX(); x <= max.getBlockX(); ++x) {
                        pos.mutX(x);
                        int xx = pos.getBlockX() - this.mx;
                        if (this.region.contains(pos)) {
                            BlockState block = this.getBlockAbs(x, y, z);
                            if (!air && block.getBlockType().getMaterial().isAir()) continue;
                            CompoundTag tag = block.getNbtData();
                            if (tag != null) {
                                Map values = ReflectionUtils.getMap(tag.getValue());
                                values.put("x", new IntTag(xx));
                                values.put("y", new IntTag(yy));
                                values.put("z", new IntTag(zz));
                            }
                            task.run(xx, yy, zz, block);
                            continue;
                        }
                        if (!air) continue;
                        task.run(xx, yy, zz, EditSession.nullBlock);
                    }
                }
            }
        }
    }
}

