/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.collection;

import java.util.Arrays;

public final class FastBitSet {
    private final int size;
    private final long[] bits;

    public FastBitSet(int size) {
        this.size = size;
        this.bits = new long[size + 64 >> 6];
    }

    public FastBitSet(long[] bits, int size) {
        this.bits = bits;
        this.size = size;
    }

    public static long[] create(int size) {
        return new long[size + 64 >> 6];
    }

    public static boolean get(long[] bits, int i) {
        return (bits[i >> 6] & 1L << (i & 0x3F)) != 0L;
    }

    public static final void set(long[] bits, int i) {
        int n = i >> 6;
        bits[n] = bits[n] | 1L << (i & 0x3F);
    }

    public static final void clear(long[] bits, int i) {
        int n = i >> 6;
        bits[n] = bits[n] & (1L << (i & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static final void set(long[] bits, int i, boolean v) {
        if (v) {
            FastBitSet.set(bits, i);
        } else {
            FastBitSet.clear(bits, i);
        }
    }

    public static final void setRange(long[] bits, int b, int e) {
        int bt = b >> 6;
        int et = e >> 6;
        if (bt != et) {
            FastBitSet.fill(bits, bt + 1, et, -1L);
            int n = bt;
            bits[n] = bits[n] | -1L << (b & 0x3F);
            int n2 = et;
            bits[n2] = bits[n2] | -1L << (e & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL;
        } else {
            int n = bt;
            bits[n] = bits[n] | -1L << (b & 0x3F) & (-1L << (e & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public static final void clearRange(long[] bits, int b, int e) {
        int bt = b >> 6;
        int et = e >> 6;
        if (bt != et) {
            FastBitSet.fill(bits, bt + 1, et, 0L);
            int n = bt;
            bits[n] = bits[n] & (-1L << (b & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
            int n2 = et;
            bits[n2] = bits[n2] & -1L << (e & 0x3F);
        } else {
            int n = bt;
            bits[n] = bits[n] & (-1L << (b & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL | -1L << (e & 0x3F));
        }
    }

    public static final void setAll(long[] bits) {
        Arrays.fill(bits, -1L);
    }

    public static final void clearAll(long[] bits) {
        Arrays.fill(bits, 0L);
    }

    public static final void invertAll(long[] bits) {
        for (int i = 0; i < bits.length; ++i) {
            bits[i] = bits[i] ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }

    public static final void and(long[] bits, long[] other) {
        int end = Math.min(other.length, bits.length);
        for (int i = 0; i < end; ++i) {
            int n = i;
            bits[n] = bits[n] & other[i];
        }
    }

    public static final void or(long[] bits, long[] other) {
        int end = Math.min(other.length, bits.length);
        for (int i = 0; i < end; ++i) {
            int n = i;
            bits[n] = bits[n] | other[i];
        }
    }

    public static final void nand(long[] bits, long[] other) {
        int end = Math.min(other.length, bits.length);
        for (int i = 0; i < end; ++i) {
            bits[i] = bits[i] & other[i] ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }

    public static final void nor(long[] bits, long[] other) {
        int end = Math.min(other.length, bits.length);
        for (int i = 0; i < end; ++i) {
            bits[i] = (bits[i] | other[i]) ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }

    public static final void xor(long[] bits, long[] other) {
        int end = Math.min(other.length, bits.length);
        for (int i = 0; i < end; ++i) {
            int n = i;
            bits[n] = bits[n] ^ other[i];
        }
    }

    public static final long memoryUsage(long[] bits) {
        return 8L * (long)bits.length;
    }

    public final boolean get(int i) {
        return (this.bits[i >> 6] & 1L << (i & 0x3F)) != 0L;
    }

    public final void set(int i) {
        int n = i >> 6;
        this.bits[n] = this.bits[n] | 1L << (i & 0x3F);
    }

    public final void clear(int i) {
        int n = i >> 6;
        this.bits[n] = this.bits[n] & (1L << (i & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public final void set(int i, boolean v) {
        if (v) {
            this.set(i);
        } else {
            this.clear(i);
        }
    }

    public final void setRange(int b, int e) {
        int bt = b >> 6;
        int et = e >> 6;
        if (bt != et) {
            FastBitSet.fill(this.bits, bt + 1, et, -1L);
            int n = bt;
            this.bits[n] = this.bits[n] | -1L << (b & 0x3F);
            int n2 = et;
            this.bits[n2] = this.bits[n2] | -1L << (e & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL;
        } else {
            int n = bt;
            this.bits[n] = this.bits[n] | -1L << (b & 0x3F) & (-1L << (e & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public final void clearRange(int b, int e) {
        int bt = b >> 6;
        int et = e >> 6;
        if (bt != et) {
            FastBitSet.fill(this.bits, bt + 1, et, 0L);
            int n = bt;
            this.bits[n] = this.bits[n] & (-1L << (b & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
            int n2 = et;
            this.bits[n2] = this.bits[n2] & -1L << (e & 0x3F);
        } else {
            int n = bt;
            this.bits[n] = this.bits[n] & (-1L << (b & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL | -1L << (e & 0x3F));
        }
    }

    public final void setAll() {
        Arrays.fill(this.bits, -1L);
    }

    public final void clearAll() {
        Arrays.fill(this.bits, 0L);
    }

    public final void invertAll() {
        for (int i = 0; i < this.bits.length; ++i) {
            this.bits[i] = this.bits[i] ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }

    public final void and(FastBitSet other) {
        int end = Math.min(other.bits.length, this.bits.length);
        for (int i = 0; i < end; ++i) {
            int n = i;
            this.bits[n] = this.bits[n] & other.bits[i];
        }
    }

    public final void or(FastBitSet other) {
        int end = Math.min(other.bits.length, this.bits.length);
        for (int i = 0; i < end; ++i) {
            int n = i;
            this.bits[n] = this.bits[n] | other.bits[i];
        }
    }

    public final void nand(FastBitSet other) {
        int end = Math.min(other.bits.length, this.bits.length);
        for (int i = 0; i < end; ++i) {
            this.bits[i] = this.bits[i] & other.bits[i] ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }

    public final void nor(FastBitSet other) {
        int end = Math.min(other.bits.length, this.bits.length);
        for (int i = 0; i < end; ++i) {
            this.bits[i] = (this.bits[i] | other.bits[i]) ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }

    public final void xor(FastBitSet other) {
        int end = Math.min(other.bits.length, this.bits.length);
        for (int i = 0; i < end; ++i) {
            int n = i;
            this.bits[n] = this.bits[n] ^ other.bits[i];
        }
    }

    public final int cardinality() {
        if (this.size == 0) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < this.bits.length - 1; ++i) {
            count += Long.bitCount(this.bits[i]);
        }
        return count + Long.bitCount(this.bits[this.bits.length - 1] & (-1L << (this.size & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public final int size() {
        return this.size;
    }

    public final long memoryUsage() {
        return 8L * (long)this.bits.length;
    }

    private static void fill(long[] a, int b, int e, long l) {
        for (int i = b; i < e; ++i) {
            a[i] = l;
        }
    }

    public static long calculateMemoryUsage(int entries) {
        int numLongs = entries + 64 >> 6;
        return 8L * (long)numLongs;
    }

    public IntIterator iterator() {
        return new IntIterator();
    }

    public final class IntIterator {
        int index = 0;
        long bitBuffer = 0L;
        int value = 0;

        public boolean next() {
            while (this.bitBuffer == 0L) {
                if (this.index >= FastBitSet.this.bits.length) {
                    return false;
                }
                this.bitBuffer = FastBitSet.this.bits[this.index];
                ++this.index;
            }
            long lowBit = Long.lowestOneBit(this.bitBuffer);
            int bitIndex = Long.bitCount(lowBit - 1L);
            this.value = (this.index - 1 << 6) + bitIndex;
            this.bitBuffer ^= lowBit;
            return true;
        }

        public int getValue() {
            return this.value;
        }
    }
}

