/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.collection;

import java.lang.reflect.Array;
import java.util.AbstractList;

public class PrimitiveList<T>
extends AbstractList<T> {
    private final Class<?> primitive;
    private final Type type;
    private int length;
    private int totalLength;
    private Object arr;

    public PrimitiveList(Class<T> type) {
        try {
            Class<Object> boxed;
            if (type.isPrimitive()) {
                this.primitive = type;
                boxed = Array.get(Array.newInstance(this.primitive, 1), 0).getClass();
            } else {
                this.primitive = (Class)type.getField("TYPE").get(null);
                boxed = type;
            }
            this.type = Type.valueOf(boxed.getSimpleName());
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        this.length = 0;
        this.totalLength = 0;
        this.arr = Array.newInstance(this.primitive, 0);
    }

    public PrimitiveList(T[] arr) {
        try {
            Class<?> boxed = arr.getClass().getComponentType();
            this.primitive = (Class)boxed.getField("TYPE").get(null);
            this.type = Type.valueOf(boxed.getSimpleName());
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        this.arr = Array.newInstance(this.primitive, arr.length);
        for (int i = 0; i < arr.length; ++i) {
            T val = arr[i];
            if (val == null) continue;
            this.setFast(i, val);
        }
        this.totalLength = this.length = arr.length;
    }

    public PrimitiveList(Object arr) {
        if (!arr.getClass().isArray()) {
            throw new IllegalArgumentException("Argument must be an array!");
        }
        this.primitive = arr.getClass().getComponentType();
        Class<?> boxed = Array.get(Array.newInstance(this.primitive, 1), 0).getClass();
        this.type = Type.valueOf(boxed.getSimpleName());
        this.arr = arr;
        this.totalLength = this.length = Array.getLength(arr);
    }

    public Object getArray() {
        return this.arr;
    }

    @Override
    public T get(int index) {
        return (T)this.getFast(index);
    }

    public byte getByte(int index) {
        return this.type == Type.Double ? ((byte[])this.arr)[index] : (Byte)this.getFast(index);
    }

    public boolean getBoolean(int index) {
        return this.type == Type.Boolean ? ((boolean[])this.arr)[index] : (Boolean)this.getFast(index);
    }

    public short getShort(int index) {
        return this.type == Type.Short ? ((short[])this.arr)[index] : (Short)this.getFast(index);
    }

    public char getCharacter(int index) {
        return this.type == Type.Character ? ((char[])this.arr)[index] : ((Character)this.getFast(index)).charValue();
    }

    public int getInt(int index) {
        return this.type == Type.Integer ? ((int[])this.arr)[index] : (Integer)this.getFast(index);
    }

    public float getFloat(int index) {
        return this.type == Type.Float ? ((float[])this.arr)[index] : ((Float)this.getFast(index)).floatValue();
    }

    public long getLong(int index) {
        return this.type == Type.Long ? ((long[])this.arr)[index] : (Long)this.getFast(index);
    }

    public double getDouble(int index) {
        return this.type == Type.Double ? ((double[])this.arr)[index] : (Double)this.getFast(index);
    }

    private final Object getFast(int index) {
        switch (this.type) {
            case Byte: {
                return ((byte[])this.arr)[index];
            }
            case Boolean: {
                return ((boolean[])this.arr)[index];
            }
            case Short: {
                return ((short[])this.arr)[index];
            }
            case Character: {
                return Character.valueOf(((char[])this.arr)[index]);
            }
            case Integer: {
                return ((int[])this.arr)[index];
            }
            case Float: {
                return Float.valueOf(((float[])this.arr)[index]);
            }
            case Long: {
                return ((long[])this.arr)[index];
            }
            case Double: {
                return ((double[])this.arr)[index];
            }
        }
        return null;
    }

    @Override
    public T set(int index, T element) {
        T value = this.get(index);
        this.setFast(index, element);
        return value;
    }

    @Override
    public void set(int index, char value) {
        switch (this.type) {
            default: {
                this.setFast(index, Character.valueOf(value));
                return;
            }
            case Character: 
        }
        ((char[])this.arr)[index] = value;
    }

    @Override
    public void set(int index, byte value) {
        switch (this.type) {
            default: {
                this.setFast(index, value);
                return;
            }
            case Byte: 
        }
        ((byte[])this.arr)[index] = value;
    }

    @Override
    public void set(int index, int value) {
        switch (this.type) {
            default: {
                this.setFast(index, value);
                return;
            }
            case Integer: {
                ((int[])this.arr)[index] = value;
                return;
            }
            case Long: {
                ((long[])this.arr)[index] = value;
                return;
            }
            case Double: 
        }
        ((double[])this.arr)[index] = value;
    }

    @Override
    public void set(int index, long value) {
        switch (this.type) {
            default: {
                this.setFast(index, value);
                return;
            }
            case Integer: {
                ((int[])this.arr)[index] = (int)value;
                return;
            }
            case Long: {
                ((long[])this.arr)[index] = value;
                return;
            }
            case Double: 
        }
        ((double[])this.arr)[index] = value;
    }

    @Override
    public void set(int index, double value) {
        switch (this.type) {
            default: {
                this.setFast(index, value);
                return;
            }
            case Float: {
                ((float[])this.arr)[index] = (float)value;
                return;
            }
            case Long: {
                ((long[])this.arr)[index] = (long)value;
                return;
            }
            case Double: 
        }
        ((double[])this.arr)[index] = value;
    }

    public final void setFast(int index, Object element) {
        switch (this.type) {
            case Byte: {
                ((byte[])this.arr)[index] = (Byte)element;
                return;
            }
            case Boolean: {
                ((boolean[])this.arr)[index] = (Boolean)element;
                return;
            }
            case Short: {
                ((short[])this.arr)[index] = (Short)element;
                return;
            }
            case Character: {
                ((char[])this.arr)[index] = ((Character)element).charValue();
                return;
            }
            case Integer: {
                ((int[])this.arr)[index] = (Integer)element;
                return;
            }
            case Float: {
                ((float[])this.arr)[index] = ((Float)element).floatValue();
                return;
            }
            case Long: {
                ((long[])this.arr)[index] = (Long)element;
                return;
            }
            case Double: {
                ((double[])this.arr)[index] = (Double)element;
                return;
            }
        }
    }

    @Override
    public void add(int index, T element) {
        if (index == this.length) {
            if (this.totalLength == this.length) {
                Object tmp = this.arr;
                this.totalLength = (this.length << 1) + 16;
                this.arr = Array.newInstance(this.primitive, this.totalLength);
                System.arraycopy(tmp, 0, this.arr, 0, this.length);
            }
            this.setFast(this.length, element);
            ++this.length;
        } else {
            if (this.totalLength == this.length) {
                Object tmp = this.arr;
                this.totalLength = (this.length << 1) + 16;
                this.arr = Array.newInstance(this.primitive, this.totalLength);
                System.arraycopy(tmp, 0, this.arr, 0, index);
            }
            System.arraycopy(this.arr, index, this.arr, index + 1, this.length - index);
            this.set(index, element);
            ++this.length;
        }
    }

    private void ensureAddCapacity() {
        if (this.totalLength == this.length) {
            Object tmp = this.arr;
            this.totalLength = (this.length << 1) + 16;
            this.arr = Array.newInstance(this.primitive, this.totalLength);
            System.arraycopy(tmp, 0, this.arr, 0, this.length);
        }
    }

    @Override
    public boolean add(T element) {
        this.ensureAddCapacity();
        this.setFast(this.length++, element);
        return true;
    }

    @Override
    public boolean add(int element) {
        this.ensureAddCapacity();
        this.set(this.length++, element);
        return true;
    }

    @Override
    public boolean add(long element) {
        this.ensureAddCapacity();
        this.set(this.length++, element);
        return true;
    }

    @Override
    public boolean add(double element) {
        this.ensureAddCapacity();
        this.set(this.length++, element);
        return true;
    }

    @Override
    public boolean add(byte element) {
        this.ensureAddCapacity();
        this.set(this.length++, element);
        return true;
    }

    @Override
    public boolean add(char element) {
        this.ensureAddCapacity();
        this.set(this.length++, element);
        return true;
    }

    @Override
    public T remove(int index) {
        if (index < 0 || index > this.length) {
            throw new IndexOutOfBoundsException(index + " not in [0, " + this.length + "]");
        }
        T value = this.get(index);
        if (index != this.length) {
            System.arraycopy(this.arr, index + 1, this.arr, index, this.length - index - 1);
        }
        --this.length;
        return value;
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public void clear() {
        if (this.length != 0) {
            this.arr = Array.newInstance(this.primitive, 0);
        }
        this.length = 0;
    }

    private static enum Type {
        Byte,
        Boolean,
        Short,
        Character,
        Integer,
        Float,
        Long,
        Double;

    }
}

