/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.collection;

import com.boydti.fawe.object.collection.FastRandomCollection;
import com.boydti.fawe.object.collection.SimpleRandomCollection;
import com.boydti.fawe.object.random.SimpleRandom;
import com.google.common.base.Preconditions;
import java.util.Map;

public abstract class RandomCollection<T> {
    protected SimpleRandom random;

    public RandomCollection(Map<T, Double> weights, SimpleRandom random) {
        this.random = random;
    }

    public static <T> RandomCollection<T> of(Map<T, Double> weights, SimpleRandom random) {
        try {
            return new FastRandomCollection<T>(weights, random);
        }
        catch (IllegalArgumentException ignore) {
            return new SimpleRandomCollection<T>(weights, random);
        }
    }

    public void setRandom(SimpleRandom random) {
        Preconditions.checkNotNull((Object)random);
        this.random = random;
    }

    public SimpleRandom getRandom() {
        return this.random;
    }

    public abstract T next(int var1, int var2, int var3);
}

