/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.extent;

import com.boydti.fawe.object.extent.ResettableExtent;
import com.sk89q.worldedit.MutableBlockVector;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.Vector2D;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.transform.BlockTransformExtent;
import com.sk89q.worldedit.world.biome.BaseBiome;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;

public class TransformExtent
extends BlockTransformExtent {
    private final MutableBlockVector mutable = new MutableBlockVector();
    private Vector min;
    private int maxy;

    public TransformExtent(Extent parent) {
        super(parent);
        this.maxy = parent.getMaximumPoint().getBlockY();
    }

    @Override
    public ResettableExtent setExtent(Extent extent) {
        this.min = null;
        this.maxy = extent.getMaximumPoint().getBlockY();
        return super.setExtent(extent);
    }

    @Override
    public Vector getMinimumPoint() {
        MutableBlockVector pos1 = new MutableBlockVector(this.getPos(super.getMinimumPoint()));
        MutableBlockVector pos2 = new MutableBlockVector(this.getPos(super.getMaximumPoint()));
        return Vector.getMinimum(pos1, pos2);
    }

    @Override
    public Vector getMaximumPoint() {
        MutableBlockVector pos1 = new MutableBlockVector(this.getPos(super.getMinimumPoint()));
        MutableBlockVector pos2 = new MutableBlockVector(this.getPos(super.getMaximumPoint()));
        return Vector.getMaximum(pos1, pos2);
    }

    @Override
    public void setOrigin(Vector pos) {
        this.min = pos;
    }

    public Vector getPos(Vector pos) {
        if (this.min == null) {
            this.min = new Vector(pos);
        }
        this.mutable.mutX(pos.getX() - this.min.getX());
        this.mutable.mutY(pos.getY() - this.min.getY());
        this.mutable.mutZ(pos.getZ() - this.min.getZ());
        Vector tmp = this.getTransform().apply(this.mutable);
        tmp.mutX(tmp.getX() + this.min.getX());
        tmp.mutY(tmp.getY() + this.min.getY());
        tmp.mutZ(tmp.getZ() + this.min.getZ());
        return tmp;
    }

    public Vector getPos(int x, int y, int z) {
        if (this.min == null) {
            this.min = new Vector(x, y, z);
        }
        this.mutable.mutX((double)x - this.min.getX());
        this.mutable.mutY((double)y - this.min.getY());
        this.mutable.mutZ((double)z - this.min.getZ());
        Vector tmp = this.getTransform().apply(this.mutable);
        tmp.mutX(tmp.getX() + this.min.getX());
        tmp.mutY(tmp.getY() + this.min.getY());
        tmp.mutZ(tmp.getZ() + this.min.getZ());
        return tmp;
    }

    @Override
    public BlockState getLazyBlock(int x, int y, int z) {
        return this.transformFast(super.getLazyBlock(this.getPos(x, y, z)));
    }

    @Override
    public BlockState getLazyBlock(Vector position) {
        return this.transformFast(super.getLazyBlock(this.getPos(position)));
    }

    @Override
    public BlockState getBlock(Vector position) {
        return this.transformFast(super.getBlock(this.getPos(position)));
    }

    @Override
    public BaseBiome getBiome(Vector2D position) {
        this.mutable.mutX(position.getBlockX());
        this.mutable.mutZ(position.getBlockZ());
        this.mutable.mutY(0);
        return super.getBiome(this.getPos(this.mutable).toVector2D());
    }

    @Override
    public boolean setBlock(int x, int y, int z, BlockStateHolder block) throws WorldEditException {
        return super.setBlock(this.getPos(x, y, z), this.transformFastInverse((BlockState)block));
    }

    @Override
    public boolean setBlock(Vector location, BlockStateHolder block) throws WorldEditException {
        return super.setBlock(this.getPos(location), this.transformFastInverse((BlockState)block));
    }

    @Override
    public boolean setBiome(Vector2D position, BaseBiome biome) {
        this.mutable.mutX(position.getBlockX());
        this.mutable.mutZ(position.getBlockZ());
        this.mutable.mutY(0);
        return super.setBiome(this.getPos(this.mutable).toVector2D(), biome);
    }
}

