/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.mask;

import com.boydti.fawe.object.mask.ResettableMask;
import com.sk89q.worldedit.MutableBlockVector;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.mask.Mask2D;
import com.sk89q.worldedit.function.mask.SolidBlockMask;
import javax.annotation.Nullable;

public class SolidPlaneMask
extends SolidBlockMask
implements ResettableMask {
    private transient int mode = -1;
    private transient MutableBlockVector mutable = new MutableBlockVector();
    private int originX = Integer.MAX_VALUE;
    private int originY = Integer.MAX_VALUE;
    private int originZ = Integer.MAX_VALUE;

    public SolidPlaneMask(Extent extent) {
        super(extent);
    }

    @Override
    public boolean test(Vector vector) {
        switch (this.mode) {
            case -1: {
                if (!super.test(vector)) {
                    return false;
                }
                this.originX = vector.getBlockX();
                this.originY = vector.getBlockY();
                this.originZ = vector.getBlockZ();
                this.mode = 0;
                Extent extent = this.getExtent();
                if (!extent.getBlockType(this.mutable.setComponents(this.originX - 1, this.originY, this.originZ)).getMaterial().isAir() && !extent.getBlockType(this.mutable.setComponents(this.originX + 1, this.originY, this.originZ)).getMaterial().isAir()) {
                    this.mode &= 1;
                }
                if (!extent.getBlockType(this.mutable.setComponents(this.originX, this.originY, this.originZ - 1)).getMaterial().isAir() && !extent.getBlockType(this.mutable.setComponents(this.originX, this.originY, this.originZ + 1)).getMaterial().isAir()) {
                    this.mode &= 4;
                }
                if (!extent.getBlockType(this.mutable.setComponents(this.originX, this.originY - 1, this.originZ + 1)).getMaterial().isAir() && !extent.getBlockType(this.mutable.setComponents(this.originX, this.originY + 1, this.originZ + 1)).getMaterial().isAir()) {
                    this.mode &= 2;
                }
                if (Integer.bitCount(this.mode) >= 3) {
                    return false;
                }
            }
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                if (!super.test(vector)) {
                    return false;
                }
                int original = this.mode;
                if (this.originX != vector.getBlockX()) {
                    this.mode &= 1;
                }
                if (this.originY != vector.getBlockY()) {
                    this.mode &= 2;
                }
                if (this.originZ != vector.getBlockZ()) {
                    this.mode &= 4;
                }
                if (Integer.bitCount(this.mode) < 3) break;
                this.mode = original;
                return false;
            }
        }
        if (this.originX != vector.getBlockX() && (this.mode & 1) == 0) {
            return false;
        }
        if (this.originZ != vector.getBlockZ() && (this.mode & 4) == 0) {
            return false;
        }
        if (this.originY != vector.getBlockY() && (this.mode & 2) == 0) {
            return false;
        }
        return super.test(vector);
    }

    @Override
    public void reset() {
        this.mode = -1;
        this.mutable = new MutableBlockVector();
    }

    @Override
    @Nullable
    public Mask2D toMask2D() {
        return null;
    }
}

