/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.pattern;

import com.boydti.fawe.object.pattern.ExistingPattern;
import com.sk89q.worldedit.MutableBlockVector2D;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.world.biome.BaseBiome;
import java.io.IOException;
import java.io.ObjectInputStream;

public class BiomePattern
extends ExistingPattern {
    private transient MutableBlockVector2D mutable = new MutableBlockVector2D();
    private final BaseBiome biome;

    public BiomePattern(Extent extent, BaseBiome biome) {
        super(extent);
        this.biome = biome;
    }

    @Override
    public BaseBlock apply(Vector position) {
        throw new BiomePatternException();
    }

    @Override
    public boolean apply(Extent extent, Vector set, Vector getPosition) throws WorldEditException {
        return extent.setBiome(set.getBlockX(), set.getBlockY(), set.getBlockZ(), this.biome);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.mutable = new MutableBlockVector2D();
    }

    public class BiomePatternException
    extends RuntimeException {
        private BiomePatternException() {
        }

        public BiomePattern getPattern() {
            return BiomePattern.this;
        }

        public BaseBiome getBiome() {
            return BiomePattern.this.biome;
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

