/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.pattern;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.object.FawePlayer;
import com.boydti.fawe.object.collection.LocalBlockVectorSet;
import com.boydti.fawe.object.pattern.ResettablePattern;
import com.boydti.fawe.util.FaweTimer;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.pattern.AbstractPattern;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.UUID;

public class BufferedPattern
extends AbstractPattern
implements ResettablePattern {
    protected transient LocalBlockVectorSet set = new LocalBlockVectorSet();
    protected transient FaweTimer timer;
    protected transient long[] actionTime;
    protected final Pattern pattern;
    protected final UUID uuid;

    public BufferedPattern(FawePlayer fp, Pattern parent) {
        this.uuid = fp.getUUID();
        this.actionTime = (long[])fp.getMeta("lastActionTime");
        if (this.actionTime == null) {
            this.actionTime = new long[2];
            fp.setMeta("lastActionTime", this.actionTime);
        }
        this.pattern = parent;
        this.timer = Fawe.get().getTimer();
    }

    @Override
    public BlockStateHolder apply(Vector position) {
        return this.pattern.apply(position);
    }

    @Override
    public boolean apply(Extent extent, Vector setPosition, Vector getPosition) throws WorldEditException {
        long now = this.timer.getTick();
        try {
            if (!this.set(setPosition)) {
                return false;
            }
            return this.pattern.apply(extent, setPosition, getPosition);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return false;
        }
    }

    public boolean set(Vector pos) {
        return this.set.add(pos);
    }

    @Override
    public void reset() {
        long now = this.timer.getTick();
        if (now - this.actionTime[1] > 5L) {
            this.set.clear();
        }
        this.actionTime[1] = this.actionTime[0];
        this.actionTime[0] = now;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.set = new LocalBlockVectorSet();
        this.timer = Fawe.get().getTimer();
        FawePlayer fp = Fawe.get().getCachedPlayer(this.uuid);
        if (fp != null) {
            this.actionTime = (long[])fp.getMeta("lastActionTime");
            if (this.actionTime == null) {
                this.actionTime = new long[2];
                fp.setMeta("lastActionTime", this.actionTime);
            }
        } else {
            this.actionTime = new long[2];
        }
    }
}

