/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.pattern;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.function.pattern.AbstractPattern;
import com.sk89q.worldedit.internal.expression.Expression;
import com.sk89q.worldedit.internal.expression.ExpressionException;
import com.sk89q.worldedit.internal.expression.runtime.EvaluationException;
import com.sk89q.worldedit.regions.shape.WorldEditExpressionEnvironment;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.io.IOException;
import java.io.ObjectInputStream;

public class ExpressionPattern
extends AbstractPattern {
    public String input;
    private transient Expression expression;

    public ExpressionPattern(String input) throws ExpressionException {
        Preconditions.checkNotNull((Object)input);
        this.input = input;
        this.expression = Expression.compile(input, "x", "y", "z");
    }

    public ExpressionPattern(Expression expression) {
        Preconditions.checkNotNull((Object)expression);
        this.expression = expression;
    }

    @Override
    public BlockStateHolder apply(Vector vector) {
        try {
            if (this.expression.getEnvironment() instanceof WorldEditExpressionEnvironment) {
                ((WorldEditExpressionEnvironment)this.expression.getEnvironment()).setCurrentBlock(vector);
            }
            double combined = this.expression.evaluate(vector.getX(), vector.getY(), vector.getZ());
            return BlockState.getFromInternalId((int)combined);
        }
        catch (EvaluationException e) {
            e.printStackTrace();
            return EditSession.nullBlock;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        try {
            this.expression = Expression.compile(this.input, "x", "y", "z");
        }
        catch (ExpressionException e) {
            e.printStackTrace();
        }
    }
}

