/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.pattern;

import com.boydti.fawe.object.pattern.AbstractExtentPattern;
import com.boydti.fawe.object.string.MutableCharSequence;
import com.boydti.fawe.util.MathMan;
import com.boydti.fawe.util.StringMan;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.registry.state.AbstractProperty;
import com.sk89q.worldedit.registry.state.IntegerProperty;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.registry.state.PropertyKey;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.ArrayList;
import java.util.List;

public class PropertyPattern
extends AbstractExtentPattern {
    private final int[] transformed = new int[BlockTypes.states.length];
    private static final Operator EQUAL = (length, value, index) -> value;
    private static final Operator PLUS = (length, value, index) -> index + value;
    private static final Operator MINUS = (length, value, index) -> index - value;
    private static final Operator MODULO = (length, value, index) -> index % value;
    private static final Operator AND = (length, value, index) -> index & value;
    private static final Operator OR = (length, value, index) -> index | value;
    private static final Operator XOR = (length, value, index) -> index ^ value;

    public PropertyPattern(Extent extent, String[] properties) {
        this(extent);
        this.addRegex(".*[" + StringMan.join(properties, ",") + "]");
    }

    public PropertyPattern(Extent extent) {
        super(extent);
        for (int i = 0; i < this.transformed.length; ++i) {
            this.transformed[i] = i;
        }
    }

    private Operator getOp(char c) {
        switch (c) {
            case '=': {
                return EQUAL;
            }
            case '+': {
                return PLUS;
            }
            case '-': {
                return MINUS;
            }
            case '%': {
                return MODULO;
            }
            case '&': {
                return AND;
            }
            case '|': {
                return OR;
            }
            case '^': {
                return XOR;
            }
        }
        return null;
    }

    private void add(BlockTypes type, PropertyKey key, Operator operator, MutableCharSequence value, boolean wrap) {
        if (!type.hasProperty(key)) {
            return;
        }
        AbstractProperty property = (AbstractProperty)type.getProperty(key);
        BlockState defaultState = type.getDefaultState();
        int valueInt = value.length() == 0 ? property.getIndex(defaultState.getInternalId()) : (!(property instanceof IntegerProperty) && MathMan.isInteger(value) ? StringMan.parseInt(value) : property.getIndexFor(value));
        List values = property.getValues();
        int length = values.size();
        for (int i = 0; i < values.size(); ++i) {
            int result = operator.apply(length, valueInt, i);
            result = wrap ? MathMan.wrap(result, 0, length - 1) : Math.max(Math.min(result, length - 1), 0);
            if (result == i) continue;
            int internalId = valueInt + i;
            int state = property.modifyIndex(0, i);
            if (type.getProperties().size() > 1) {
                ArrayList<Property> properties = new ArrayList<Property>(type.getProperties().size() - 1);
                for (Property property2 : type.getProperties()) {
                    if (property2 == property) continue;
                    properties.add(property2);
                }
                this.applyRecursive(type, property, properties, 0, state, result);
                continue;
            }
            int ordinal = type.withStateId(internalId).getOrdinal();
            this.transformed[ordinal] = type.withStateId(result).getOrdinal();
        }
    }

    private void applyRecursive(BlockType type, AbstractProperty property, List<Property> properties, int propertiesIndex, int stateId, int index) {
        AbstractProperty current = (AbstractProperty)properties.get(propertiesIndex);
        List values = current.getValues();
        if (propertiesIndex + 1 < properties.size()) {
            for (int i = 0; i < values.size(); ++i) {
                int newState = current.modifyIndex(stateId, i);
                this.applyRecursive(type, property, properties, propertiesIndex + 1, newState, index);
            }
        } else {
            for (int i = 0; i < values.size(); ++i) {
                int statesIndex = current.modifyIndex(stateId, i) >> BlockTypes.BIT_OFFSET;
                BlockState state = BlockState.getFromInternalId(statesIndex);
                int existingOrdinal = this.transformed[state.getOrdinal()];
                int existing = BlockTypes.states[existingOrdinal].getInternalId();
                this.transformed[state.getOrdinal()] = property.modifyIndex(existing, index) >> BlockTypes.BIT_OFFSET;
            }
        }
    }

    public PropertyPattern addRegex(String input) {
        if (input.charAt(input.length() - 1) == ']') {
            int propStart = StringMan.findMatchingBracket(input, input.length() - 1);
            if (propStart == -1) {
                return this;
            }
            MutableCharSequence charSequence = MutableCharSequence.getTemporal();
            charSequence.setString(input);
            charSequence.setSubstring(0, propStart);
            BlockTypes type = null;
            ArrayList<BlockTypes> blockTypeList = null;
            if (StringMan.isAlphanumericUnd(charSequence)) {
                type = BlockTypes.get(charSequence);
            } else {
                String regex = charSequence.toString();
                blockTypeList = new ArrayList<BlockTypes>();
                for (BlockTypes myType : BlockTypes.values) {
                    if (!myType.getId().matches(regex)) continue;
                    blockTypeList.add(myType);
                }
                if (blockTypeList.size() == 1) {
                    type = (BlockTypes)blockTypeList.get(0);
                }
            }
            PropertyKey key = null;
            int length = input.length();
            int last = propStart + 1;
            Operator operator = null;
            boolean wrap = false;
            block5: for (int i = last; i < length; ++i) {
                char c = input.charAt(i);
                switch (c) {
                    case '(': 
                    case '[': 
                    case '{': {
                        int next = StringMan.findMatchingBracket(input, i);
                        if (next == -1) continue block5;
                        i = next;
                        continue block5;
                    }
                    case ',': 
                    case ']': {
                        charSequence.setSubstring(last, i);
                        char firstChar = input.charAt(last + 1);
                        if (type != null) {
                            this.add(type, key, operator, charSequence, wrap);
                        } else {
                            for (BlockTypes myType : blockTypeList) {
                                this.add(myType, key, operator, charSequence, wrap);
                            }
                        }
                        last = i + 1;
                        continue block5;
                    }
                    default: {
                        Operator tmp = this.getOp(c);
                        if (tmp == null) continue block5;
                        operator = tmp;
                        charSequence.setSubstring(last, i);
                        char cp = input.charAt(i + 1);
                        boolean extra = cp == '=';
                        boolean bl = wrap = cp == '~';
                        if (extra || wrap) {
                            ++i;
                        }
                        if (charSequence.length() > 0) {
                            key = PropertyKey.get(charSequence);
                        }
                        last = i + 1;
                        continue block5;
                    }
                }
            }
        }
        return this;
    }

    @Override
    public BlockStateHolder apply(Vector position) {
        BlockState block = this.getExtent().getBlock(position);
        return this.apply(block, block);
    }

    public BlockState apply(BlockState block, BlockState orDefault) {
        int ordinal = block.getOrdinal();
        int newOrdinal = this.transformed[ordinal];
        if (newOrdinal != ordinal) {
            CompoundTag nbt = block.getNbtData();
            BlockState newState = BlockState.getFromOrdinal(newOrdinal);
            return nbt != null ? new BaseBlock(newState, nbt) : newState;
        }
        return orDefault;
    }

    @Override
    public boolean apply(Extent extent, Vector set, Vector get) throws WorldEditException {
        BlockState block = this.getExtent().getBlock(get);
        if ((block = this.apply(block, null)) != null) {
            return extent.setBlock(set, block);
        }
        return false;
    }

    private static interface Operator {
        public int apply(int var1, int var2, int var3);
    }
}

