/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.pattern;

import com.boydti.fawe.object.pattern.ResettablePattern;
import com.sk89q.worldedit.MutableBlockVector;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.pattern.AbstractPattern;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.io.IOException;
import java.io.ObjectInputStream;

public class RelativePattern
extends AbstractPattern
implements ResettablePattern {
    private final Pattern pattern;
    private transient Vector origin;
    private transient MutableBlockVector mutable = new MutableBlockVector();

    public RelativePattern(Pattern pattern) {
        this.pattern = pattern;
    }

    @Override
    public BlockStateHolder apply(Vector pos) {
        if (this.origin == null) {
            this.origin = new Vector(pos);
        }
        this.mutable.mutX(pos.getX() - this.origin.getX());
        this.mutable.mutY(pos.getY() - this.origin.getY());
        this.mutable.mutZ(pos.getZ() - this.origin.getZ());
        return this.pattern.apply(this.mutable);
    }

    @Override
    public boolean apply(Extent extent, Vector set, Vector get) throws WorldEditException {
        if (this.origin == null) {
            this.origin = new Vector(get);
        }
        this.mutable.mutX(get.getX() - this.origin.getX());
        this.mutable.mutY(get.getY() - this.origin.getY());
        this.mutable.mutZ(get.getZ() - this.origin.getZ());
        return this.pattern.apply(extent, set, this.mutable);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.mutable = new MutableBlockVector();
    }

    @Override
    public void reset() {
        this.origin = null;
    }
}

