/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.schematic.visualizer;

import com.boydti.fawe.config.BBC;
import com.boydti.fawe.jnbt.anvil.MCAChunk;
import com.boydti.fawe.jnbt.anvil.MCAQueue;
import com.boydti.fawe.object.FaweChunk;
import com.boydti.fawe.object.FaweInputStream;
import com.boydti.fawe.object.FaweLocation;
import com.boydti.fawe.object.FaweOutputStream;
import com.boydti.fawe.object.FawePlayer;
import com.boydti.fawe.object.FaweQueue;
import com.boydti.fawe.object.brush.visualization.ImmutableVirtualWorld;
import com.boydti.fawe.object.clipboard.LazyClipboardHolder;
import com.boydti.fawe.object.clipboard.MultiClipboardHolder;
import com.boydti.fawe.object.clipboard.URIClipboardHolder;
import com.boydti.fawe.object.exception.FaweException;
import com.boydti.fawe.object.io.NonCloseableInputStream;
import com.boydti.fawe.object.queue.LazyFaweChunk;
import com.boydti.fawe.object.schematic.Schematic;
import com.boydti.fawe.util.IOUtil;
import com.boydti.fawe.util.MainUtil;
import com.boydti.fawe.util.MathMan;
import com.boydti.fawe.util.SetQueue;
import com.boydti.fawe.util.TaskManager;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteSource;
import com.sk89q.jnbt.NBTInputStream;
import com.sk89q.jnbt.NBTOutputStream;
import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.BlockVector2D;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.MutableBlockVector2D;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.event.platform.InputType;
import com.sk89q.worldedit.event.platform.PlayerInputEvent;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardReader;
import com.sk89q.worldedit.session.ClipboardHolder;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.util.TargetBlock;
import com.sk89q.worldedit.world.block.BlockTypes;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class SchemVis
extends ImmutableVirtualWorld {
    private static final WeakHashMap<File, Integer> DIMENSION_CACHE = new WeakHashMap();
    private final Long2ObjectOpenHashMap<Map.Entry<File, Long>> files;
    private final Long2ObjectOpenHashMap<MCAChunk> chunks;
    private final MutableBlockVector2D lastPos = new MutableBlockVector2D();
    private final FawePlayer player;
    private final Location origin;
    private final BlockVector2D chunkOffset;
    private BlockVector2D lastPosition;

    public static SchemVis create(FawePlayer player, Collection<File> files) throws IOException {
        Preconditions.checkNotNull((Object)player);
        Preconditions.checkNotNull(files);
        SchemVis visExtent = new SchemVis(player);
        for (File file : files) {
            visExtent.add(file);
        }
        visExtent.bind();
        visExtent.update();
        return visExtent;
    }

    public SchemVis(FawePlayer player) {
        this.files = new Long2ObjectOpenHashMap();
        this.chunks = new Long2ObjectOpenHashMap();
        this.player = player;
        FaweLocation pos = player.getLocation();
        this.origin = player.getPlayer().getLocation();
        this.chunkOffset = new BlockVector2D(pos.x >> 4, pos.z >> 4);
    }

    private Set<File> getFiles(BlockVector2D chunkPosA, BlockVector2D chunkPosB) {
        BlockVector2D pos1 = new BlockVector2D(Math.min(chunkPosA.getBlockX(), chunkPosB.getBlockX()), Math.min(chunkPosA.getBlockZ(), chunkPosB.getBlockZ()));
        BlockVector2D pos2 = new BlockVector2D(Math.max(chunkPosA.getBlockX(), chunkPosB.getBlockX()), Math.max(chunkPosA.getBlockZ(), chunkPosB.getBlockZ()));
        HashSet<File> contained = new HashSet<File>();
        for (Long2ObjectMap.Entry entry : this.files.long2ObjectEntrySet()) {
            int chunkZ;
            long key = entry.getLongKey();
            int chunkX = MathMan.unpairIntX(key);
            if (chunkX < pos1.getBlockX() || chunkX > pos2.getBlockX() || (chunkZ = MathMan.unpairIntY(key)) < pos1.getBlockZ() || chunkZ > pos2.getBlockZ()) continue;
            contained.add((File)((Map.Entry)entry.getValue()).getKey());
        }
        return contained;
    }

    private File getRealFile(File cached) {
        String fileName = cached.getName();
        return new File(cached.getParentFile(), fileName.substring(1, fileName.length() - 7));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handlePlayerInput(Player player, PlayerInputEvent event) {
        int chunkZ;
        int chunkX;
        long pos;
        Map.Entry entry;
        int range = 240;
        Location target = new TargetBlock(player, range, 0.2).getAnyTargetBlock();
        if (target != null && (entry = (Map.Entry)this.files.get(pos = MathMan.pairInt(chunkX = target.getBlockX() >> 4, chunkZ = target.getBlockZ() >> 4))) != null) {
            File cachedFile = (File)entry.getKey();
            String filename = cachedFile.getName();
            LocalSession session = this.player.getSession();
            SchemVis schemVis = this;
            synchronized (schemVis) {
                try {
                    BlockVector2D tmpLastPosition = this.lastPosition;
                    this.lastPosition = new BlockVector2D(chunkX, chunkZ);
                    boolean sneaking = this.player.isSneaking();
                    if (event.getInputType() == InputType.PRIMARY && !sneaking) {
                        File file = new File(cachedFile.getParentFile(), filename.substring(1, filename.length() - 7));
                        URI uri = file.toURI();
                        ClipboardFormat format = ClipboardFormat.findByFile(file);
                        format.hold(player, uri, new FileInputStream(file));
                        BBC.SCHEMATIC_LOADED.send(player, filename);
                        session.setVirtualWorld(null);
                        return;
                    }
                    Set<File> toSelect = sneaking && tmpLastPosition != null ? this.getFiles(tmpLastPosition, this.lastPosition) : Collections.singleton(cachedFile);
                    HashMap<File, Boolean> select = new HashMap<File, Boolean>();
                    for (File clicked : toSelect) {
                        boolean contains;
                        ClipboardHolder existing = session.getExistingClipboard();
                        File file = new File(clicked.getParentFile(), filename.substring(1, filename.length() - 7));
                        URI uri = file.toURI();
                        ClipboardFormat format = ClipboardFormat.findByFile(file);
                        boolean bl = contains = existing instanceof URIClipboardHolder && ((URIClipboardHolder)existing).contains(uri);
                        if (contains) {
                            if (sneaking) continue;
                            if (existing instanceof MultiClipboardHolder) {
                                MultiClipboardHolder multi = (MultiClipboardHolder)existing;
                                multi.remove(uri);
                                if (multi.getClipboards().isEmpty()) {
                                    session.setClipboard(null);
                                }
                            } else {
                                session.setClipboard(null);
                            }
                            select.put(clicked, false);
                            BBC.CLIPBOARD_CLEARED.send(player, new Object[0]);
                            continue;
                        }
                        ByteSource source = com.google.common.io.Files.asByteSource((File)file);
                        MultiClipboardHolder multi = new MultiClipboardHolder(URI.create(""), new LazyClipboardHolder(uri, source, format, null));
                        session.addClipboard(multi);
                        select.put(clicked, true);
                        BBC.SCHEMATIC_LOADED.send(player, file.getName());
                    }
                    FaweQueue packetQueue = SetQueue.IMP.getNewQueue(this.player.getWorld(), true, false);
                    if (packetQueue.supports(FaweQueue.Capability.CHUNK_PACKETS)) {
                        ArrayDeque<Long> toSend = new ArrayDeque<Long>();
                        int OX = this.chunkOffset.getBlockX();
                        int OZ = this.chunkOffset.getBlockZ();
                        ObjectIterator iter = this.chunks.long2ObjectEntrySet().fastIterator();
                        while (iter.hasNext()) {
                            Boolean selected;
                            Long2ObjectMap.Entry mcaChunkEntry = (Long2ObjectMap.Entry)iter.next();
                            long curChunkPos = mcaChunkEntry.getLongKey();
                            Map.Entry curFileEntry = (Map.Entry)this.files.get(curChunkPos);
                            if (curFileEntry == null || (selected = (Boolean)select.get(curFileEntry.getKey())) == null) continue;
                            if (!selected.booleanValue()) {
                                iter.remove();
                            } else {
                                this.select((MCAChunk)mcaChunkEntry.getValue());
                            }
                            toSend.add(curChunkPos);
                        }
                        Iterator iterator = toSend.iterator();
                        while (iterator.hasNext()) {
                            long curChunkPos = (Long)iterator.next();
                            this.send(packetQueue, MathMan.unpairIntX(curChunkPos), MathMan.unpairIntY(curChunkPos));
                        }
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private void clean() {
        if (this.chunks.size() > 225) {
            TaskManager.IMP.sync(() -> {
                if (this.chunks.size() > 225) {
                    SchemVis schemVis = this;
                    synchronized (schemVis) {
                        FaweLocation pos = this.player.getLocation();
                        int centerX = pos.x >> 4;
                        int centerZ = pos.z >> 4;
                        ObjectIterator iter = this.chunks.long2ObjectEntrySet().fastIterator();
                        while (iter.hasNext()) {
                            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)iter.next();
                            long pair = entry.getLongKey();
                            int chunkX = MathMan.unpairIntX(pair);
                            int chunkZ = MathMan.unpairIntY(pair);
                            if (Math.abs(centerX - chunkX) <= 15 && Math.abs(centerZ - chunkZ) <= 15) continue;
                            iter.remove();
                        }
                    }
                }
                return null;
            });
        }
    }

    private void send(FaweQueue packetQueue, int chunkX, int chunkZ) {
        TaskManager.IMP.getPublicForkJoinPool().submit(() -> {
            try {
                int OX = this.chunkOffset.getBlockX();
                int OZ = this.chunkOffset.getBlockZ();
                FaweChunk toSend = this.getSnapshot(chunkX, chunkZ);
                toSend.setLoc(this, chunkX + OX, chunkZ + OZ);
                packetQueue.sendChunkUpdate(toSend, this.player);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public Vector getOrigin() {
        return new BlockVector(this.chunkOffset.getBlockX() << 4, 0, this.chunkOffset.getBlockZ() << 4);
    }

    private File getFile(int chunkX, int chunkZ) {
        long pair = MathMan.pairInt(chunkX, chunkZ);
        Map.Entry entry = (Map.Entry)this.files.get(pair);
        return entry != null ? (File)entry.getKey() : null;
    }

    private Map.Entry<File, Long> getEntry(File file, long position) {
        return new AbstractMap.SimpleEntry<File, Long>(file, position);
    }

    private void select(MCAChunk chunk) {
        for (int layer = 0; layer < 16; ++layer) {
            byte[] ids = chunk.ids[layer];
            if (ids == null) continue;
            for (int i = 0; i < ids.length; ++i) {
                if (ids[i] != 0) {
                    ids[i] = (byte)BlockTypes.WHITE_STAINED_GLASS.getInternalId();
                }
                Arrays.fill(chunk.data[layer], (byte)0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheChunk(File file, MCAChunk chunk, boolean selected) {
        long pair = MathMan.pairInt(chunk.getX(), chunk.getZ());
        for (int layer = 0; layer < 16; ++layer) {
            if (chunk.skyLight[layer] == null) continue;
            Arrays.fill(chunk.skyLight[layer], (byte)-1);
        }
        if (selected) {
            this.select(chunk);
        }
        SchemVis schemVis = this;
        synchronized (schemVis) {
            this.chunks.put(pair, (Object)chunk);
        }
    }

    private BlockVector2D registerAndGetChunkOffset(BlockVector2D schemDimensions, File file) {
        int chunkX = schemDimensions.getBlockX() >> 4;
        int chunkZ = schemDimensions.getBlockZ() >> 4;
        MutableBlockVector2D pos2 = new MutableBlockVector2D();
        MutableBlockVector2D curPos = this.lastPos;
        while (!this.isAreaFree(curPos, pos2.setComponents(curPos.getBlockX() + chunkX, curPos.getBlockZ() + chunkZ))) {
            curPos.nextPosition();
        }
        Map.Entry<File, Long> originValue = this.getEntry(file, MathMan.pairInt(curPos.getBlockX(), curPos.getBlockZ()));
        for (int x = 0; x <= chunkX; ++x) {
            int xx = curPos.getBlockX() + x;
            long pairX = (long)xx << 32;
            for (int z = 0; z <= chunkZ; ++z) {
                int zz = curPos.getBlockZ() + z;
                long pos = pairX + ((long)zz & 0xFFFFFFFFL);
                this.files.put(pos, originValue);
            }
        }
        for (int i = 0; i < Math.min(chunkX, chunkZ); ++i) {
            curPos.nextPosition();
        }
        return curPos.toBlockVector2D();
    }

    private boolean isAreaFree(BlockVector2D chunkPos1, BlockVector2D chunkPos2) {
        for (int x = chunkPos1.getBlockX(); x <= chunkPos2.getBlockX(); ++x) {
            for (int z = chunkPos1.getBlockZ(); z <= chunkPos2.getBlockZ(); ++z) {
                if (!this.files.containsKey(MathMan.pairInt(x, z)) && (x != 0 || z != 0)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isSelected(File file) {
        ClipboardHolder clipboard = this.player.getSession().getExistingClipboard();
        if (clipboard != null && clipboard instanceof URIClipboardHolder) {
            return ((URIClipboardHolder)clipboard).contains(file.toURI());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(File file) throws IOException {
        block58: {
            File cached = new File(file.getParentFile(), "." + file.getName() + ".cached");
            Integer dimensionPair = DIMENSION_CACHE.get(file);
            if (dimensionPair != null) {
                char width = (char)MathMan.unpairX(dimensionPair);
                char length = (char)MathMan.unpairY(dimensionPair);
                BlockVector2D dimensions = new BlockVector2D(width, length);
                BlockVector2D offset = this.registerAndGetChunkOffset(dimensions, cached);
                return;
            }
            if (cached.exists() && file.lastModified() <= cached.lastModified()) {
                try (BufferedInputStream fis = new BufferedInputStream(new FileInputStream(cached), 4);){
                    BlockVector2D dimensions = new BlockVector2D(IOUtil.readVarInt(fis), IOUtil.readVarInt(fis));
                    DIMENSION_CACHE.put(file, MathMan.pair((short)dimensions.getBlockX(), (short)dimensions.getBlockZ()));
                    BlockVector2D offset = this.registerAndGetChunkOffset(dimensions, cached);
                }
            }
            try {
                this.player.sendMessage(BBC.getPrefix() + "Converting: " + file);
                cached.createNewFile();
                try (FileInputStream in = new FileInputStream(file);){
                    ClipboardFormat format = ClipboardFormat.findByFile(file);
                    if (format == null) break block58;
                    ClipboardReader reader = format.getReader(in);
                    Clipboard clipboard = reader.read();
                    clipboard.setOrigin(clipboard.getMinimumPoint());
                    try {
                        Path path;
                        Object hidden;
                        MCAQueue queue = new MCAQueue(null, null, false);
                        BlockVector2D dimensions = clipboard.getDimensions().toVector2D().toBlockVector2D();
                        BlockVector2D offset = this.registerAndGetChunkOffset(dimensions, cached);
                        new Schematic(clipboard).paste(queue, Vector.ZERO, true);
                        try (FileOutputStream fos = new FileOutputStream(cached);){
                            IOUtil.writeVarInt(fos, dimensions.getBlockX());
                            IOUtil.writeVarInt(fos, dimensions.getBlockZ());
                            try (FaweOutputStream cos = MainUtil.getCompressedOS(fos, 2);){
                                NBTOutputStream nos = new NBTOutputStream(cos);
                                Collection<FaweChunk> writeChunks = queue.getFaweChunks();
                                cos.writeInt(writeChunks.size());
                                boolean selected = this.isSelected(file);
                                for (FaweChunk chunk : writeChunks) {
                                    MCAChunk mcaChunk = (MCAChunk)chunk;
                                    mcaChunk.write(nos);
                                    mcaChunk.setLoc(this, mcaChunk.getX() + offset.getBlockX(), mcaChunk.getZ() + offset.getBlockZ());
                                    if (Math.abs(mcaChunk.getX()) > 15 || Math.abs(mcaChunk.getZ()) > 15) continue;
                                    this.cacheChunk(cached, mcaChunk, selected);
                                }
                            }
                        }
                        if (System.getProperty("os.name").contains("Windows") && (hidden = Files.getAttribute(path = cached.toPath(), "dos:hidden", LinkOption.NOFOLLOW_LINKS)) != null) {
                            Files.setAttribute(path, "dos:hidden", Boolean.TRUE, LinkOption.NOFOLLOW_LINKS);
                        }
                        DIMENSION_CACHE.put(file, MathMan.pair((short)dimensions.getBlockX(), (short)dimensions.getBlockZ()));
                    }
                    finally {
                        if (clipboard instanceof Closeable) {
                            ((Closeable)((Object)clipboard)).close();
                        }
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                cached.delete();
            }
        }
    }

    private synchronized MCAChunk getCachedChunk(int chunkX, int chunkZ) {
        return (MCAChunk)this.chunks.get(MathMan.pairInt(chunkX, chunkZ));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MCAChunk getChunk(int chunkX, int chunkZ) {
        long pair = MathMan.pairInt(chunkX, chunkZ);
        MCAChunk chunk = this.getCachedChunk(chunkX, chunkZ);
        if (chunk != null) {
            return chunk;
        }
        Map.Entry entry = (Map.Entry)this.files.get(pair);
        if (entry != null) {
            File cached;
            File file = cached = (File)entry.getKey();
            synchronized (file) {
                chunk = this.getCachedChunk(chunkX, chunkZ);
                if (chunk == null) {
                    this.clean();
                    String filename = cached.getName();
                    File file2 = new File(cached.getParentFile(), filename.substring(1, filename.length() - 7));
                    boolean selected = this.isSelected(file2);
                    long origin = (Long)entry.getValue();
                    int OCX = MathMan.unpairIntX(origin);
                    int OCZ = MathMan.unpairIntY(origin);
                    try (FileInputStream fis = new FileInputStream(cached);){
                        BlockVector2D dimensions = new BlockVector2D(IOUtil.readVarInt(fis), IOUtil.readVarInt(fis));
                        try (FaweInputStream in = MainUtil.getCompressedIS(fis);){
                            NonCloseableInputStream nonCloseable = new NonCloseableInputStream(in);
                            try (NBTInputStream nis = new NBTInputStream(nonCloseable);){
                                int numChunks = in.readInt();
                                for (int i = 0; i < numChunks; ++i) {
                                    MCAChunk mcaChunk = new MCAChunk(nis, null, 0, 0, true);
                                    mcaChunk.setLoc(this, mcaChunk.getX() + OCX, mcaChunk.getZ() + OCZ);
                                    this.cacheChunk(cached, mcaChunk, selected);
                                }
                            }
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    chunk = this.getCachedChunk(chunkX, chunkZ);
                    if (chunk == null) {
                        chunk = new MCAChunk(this, chunkX, chunkZ);
                        this.cacheChunk(cached, chunk, selected);
                    }
                }
            }
        }
        chunk = new MCAChunk(this, chunkX, chunkZ);
        return chunk;
    }

    @Override
    public FaweChunk getSnapshot(final int chunkX, final int chunkZ) {
        return new LazyFaweChunk<MCAChunk>((FaweQueue)this, chunkX, chunkZ){

            @Override
            public MCAChunk getChunk() {
                MCAChunk tmp = SchemVis.this.getChunk(chunkX, chunkZ);
                tmp.setLoc(SchemVis.this, this.getX(), this.getZ());
                return tmp;
            }

            @Override
            public void addToQueue() {
                MCAChunk cached = (MCAChunk)this.getCachedChunk();
                if (cached != null) {
                    SchemVis.this.setChunk(cached);
                }
            }
        };
    }

    @Override
    public FawePlayer getPlayer() {
        return this.player;
    }

    public void bind() {
        this.player.setVirtualWorld(this);
    }

    @Override
    public void update() {
        FaweQueue packetQueue = SetQueue.IMP.getNewQueue(this.player.getWorld(), true, false);
        if (!packetQueue.supports(FaweQueue.Capability.CHUNK_PACKETS)) {
            return;
        }
        int OX = this.chunkOffset.getBlockX();
        int OZ = this.chunkOffset.getBlockZ();
        FaweLocation position = this.player.getLocation();
        int pcx = (position.x >> 4) - OX;
        int pcz = (position.z >> 4) - OZ;
        int scx = pcx - 15;
        int scz = pcz - 15;
        int ecx = pcx + 15;
        int ecz = pcz + 15;
        for (int cz = scz; cz <= ecz; ++cz) {
            int cx = scx;
            while (cx <= ecx) {
                int finalCX = cx++;
                int finalCZ = cz;
                this.send(packetQueue, finalCX, finalCZ);
            }
        }
    }

    @Override
    public void sendChunk(FaweChunk chunk) {
    }

    @Override
    public void sendChunk(int x, int z, int bitMask) {
    }

    @Override
    public int getBiomeId(int x, int z) throws FaweException.FaweChunkLoadException {
        return 0;
    }

    @Override
    public int getCombinedId4Data(int x, int y, int z) throws FaweException.FaweChunkLoadException {
        MCAChunk chunk = this.getChunk(x >> 4, z >> 4);
        if (y < 0 || y > 255) {
            return 0;
        }
        return chunk.getBlockCombinedId(x & 0xF, y, z & 0xF);
    }

    @Override
    public synchronized void close(boolean update) throws IOException {
        this.clear();
        this.chunks.clear();
        this.files.clear();
        this.player.getPlayer().setPosition(this.origin.toVector(), this.origin.getPitch(), this.origin.getYaw());
        if (update) {
            FaweQueue packetQueue = SetQueue.IMP.getNewQueue(this.player.getWorld(), true, false);
            int OX = this.chunkOffset.getBlockX();
            int OZ = this.chunkOffset.getBlockZ();
            FaweLocation position = this.player.getLocation();
            int pcx = (position.x >> 4) - OX;
            int pcz = (position.z >> 4) - OZ;
            int scx = pcx - 15;
            int scz = pcz - 15;
            int ecx = pcx + 15;
            int ecz = pcz + 15;
            for (int cz = scz; cz <= ecz; ++cz) {
                for (int cx = scx; cx <= ecx; ++cx) {
                    packetQueue.sendChunk(cx + OX, cz + OZ, 0);
                }
            }
        }
    }
}

