/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.regions.general.plot;

import com.boydti.fawe.FaweCache;
import com.boydti.fawe.object.FaweQueue;
import com.boydti.fawe.object.clipboard.ReadOnlyClipboard;
import com.boydti.fawe.object.io.PGZIPOutputStream;
import com.boydti.fawe.regions.general.plot.FaweLocalBlockQueue;
import com.boydti.fawe.util.EditSessionBuilder;
import com.boydti.fawe.util.SetQueue;
import com.intellectualcrafters.plot.PS;
import com.intellectualcrafters.plot.object.Location;
import com.intellectualcrafters.plot.object.RegionWrapper;
import com.intellectualcrafters.plot.object.RunnableVal;
import com.intellectualcrafters.plot.util.MainUtil;
import com.intellectualcrafters.plot.util.SchematicHandler;
import com.intellectualcrafters.plot.util.TaskManager;
import com.intellectualcrafters.plot.util.block.LocalBlockQueue;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.NBTOutputStream;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.extent.clipboard.BlockArrayClipboard;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;

public class FaweSchematicHandler
extends SchematicHandler {
    public boolean restoreTile(LocalBlockQueue queue, com.intellectualcrafters.jnbt.CompoundTag compoundTag, int x, int y, int z) {
        if (queue instanceof FaweLocalBlockQueue) {
            queue.setTile(x, y, z, compoundTag);
            return true;
        }
        FaweQueue faweQueue = SetQueue.IMP.getNewQueue(((FaweLocalBlockQueue)queue).IMP.getWEWorld(), true, false);
        faweQueue.setTile(x, y, z, (CompoundTag)FaweCache.asTag((Object)compoundTag));
        faweQueue.flush();
        return false;
    }

    public void getCompoundTag(final String world, final Set<RegionWrapper> regions, RunnableVal<com.intellectualcrafters.jnbt.CompoundTag> whenDone) {
        com.boydti.fawe.util.TaskManager.IMP.async(new Runnable(){

            @Override
            public void run() {
                Location[] corners = MainUtil.getCorners((String)world, (Collection)regions);
                Location pos1 = corners[0];
                Location pos2 = corners[1];
                CuboidRegion region = new CuboidRegion(new Vector(pos1.getX(), pos1.getY(), pos1.getZ()), new Vector(pos2.getX(), pos2.getY(), pos2.getZ()));
                EditSession editSession = new EditSessionBuilder(world).checkMemory(false).fastmode(true).limitUnlimited().changeSetNull().autoQueue(false).build();
                int mx = pos1.getX();
                int my = pos1.getY();
                int mz = pos1.getZ();
                ReadOnlyClipboard clipboard = ReadOnlyClipboard.of(editSession, region);
                BlockArrayClipboard holder = new BlockArrayClipboard((Region)region, clipboard);
            }
        });
    }

    public boolean save(com.intellectualcrafters.jnbt.CompoundTag tag, String path) {
        if (tag == null) {
            PS.debug((Object)"&cCannot save empty tag");
            return false;
        }
        try {
            File tmp = MainUtil.getFile((File)PS.get().IMP.getDirectory(), (String)path);
            tmp.getParentFile().mkdirs();
            CompoundTag weTag = (CompoundTag)FaweCache.asTag((Object)tag);
            try (FileOutputStream stream = new FileOutputStream(tmp);
                 NBTOutputStream output = new NBTOutputStream(new PGZIPOutputStream(stream));){
                Object map = weTag.getValue();
                output.writeNamedTag("Schematic", map.containsKey("Schematic") ? (Tag)map.get("Schematic") : weTag);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void upload(final com.intellectualcrafters.jnbt.CompoundTag tag, UUID uuid, String file, RunnableVal<URL> whenDone) {
        if (tag == null) {
            PS.debug((Object)"&cCannot save empty tag");
            TaskManager.runTask(whenDone);
            return;
        }
        MainUtil.upload((UUID)uuid, (String)file, (String)"schematic", (RunnableVal)new RunnableVal<OutputStream>(){

            public void run(OutputStream output) {
                try (PGZIPOutputStream gzip = new PGZIPOutputStream(output);){
                    CompoundTag weTag = (CompoundTag)FaweCache.asTag((Object)tag);
                    try (NBTOutputStream nos = new NBTOutputStream(gzip);){
                        Object map = weTag.getValue();
                        nos.writeNamedTag("Schematic", map.containsKey("Schematic") ? (Tag)map.get("Schematic") : weTag);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }, whenDone);
    }
}

