/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.util;

import com.boydti.fawe.util.TextureUtil;
import java.io.FileNotFoundException;
import java.util.Arrays;

public class CleanTextureUtil
extends TextureUtil {
    private final int min;
    private final int max;

    public CleanTextureUtil(TextureUtil parent, int minPercent, int maxPercent) throws FileNotFoundException {
        super(parent.getFolder());
        int minIndex;
        this.min = minPercent;
        this.max = maxPercent;
        int maxIndex = (parent.distances.length - 1) * maxPercent / 100;
        long min = parent.distances[minIndex];
        long max = parent.distances[maxIndex];
        for (minIndex = (parent.distances.length - 1) * minPercent / 100; minIndex > 0 && parent.distances[minIndex - 1] == min; --minIndex) {
        }
        while (maxIndex < parent.distances.length - 1 && parent.distances[maxIndex + 1] == max) {
            ++maxIndex;
        }
        int num = maxIndex - minIndex + 1;
        this.validMixBiomeColors = parent.validMixBiomeColors;
        this.validMixBiomeIds = parent.validMixBiomeIds;
        this.validBiomes = parent.validBiomes;
        this.blockColors = parent.blockColors;
        this.blockDistance = parent.blockDistance;
        this.distances = Arrays.copyOfRange(parent.blockDistance, minIndex, maxIndex + 1);
        this.validColors = new int[this.distances.length];
        this.validBlockIds = new int[this.distances.length];
        int j = 0;
        for (int i = 0; i < parent.validBlockIds.length; ++i) {
            int color;
            int combined = parent.validBlockIds[i];
            long distance = parent.blockDistance[combined];
            if (distance < min || distance > max) continue;
            this.validColors[j] = color = parent.validColors[i];
            this.validBlockIds[j++] = combined;
        }
        this.calculateLayerArrays();
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }
}

