/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.util;

import java.awt.Color;
import java.lang.reflect.Field;
import java.util.Locale;

public class ColorUtil {
    private static final int PARSE_COMPONENT = 0;
    private static final int PARSE_PERCENT = 1;
    private static final int PARSE_ANGLE = 2;
    private static final int PARSE_ALPHA = 3;

    private static float parseComponent(String color, int off, int end, int type) {
        if ((color = color.substring(off, end).trim()).endsWith("%")) {
            if (type > 1) {
                throw new IllegalArgumentException("Invalid color specification");
            }
            type = 1;
            color = color.substring(0, color.length() - 1).trim();
        } else if (type == 1) {
            throw new IllegalArgumentException("Invalid color specification");
        }
        float c = type == 0 ? (float)Integer.parseInt(color) : Float.parseFloat(color);
        switch (type) {
            case 3: {
                return c < 0.0f ? 0.0f : (c > 1.0f ? 1.0f : c);
            }
            case 1: {
                return c <= 0.0f ? 0.0f : (c >= 100.0f ? 1.0f : c / 100.0f);
            }
            case 0: {
                return c <= 0.0f ? 0.0f : (c >= 255.0f ? 1.0f : c / 255.0f);
            }
            case 2: {
                return c < 0.0f ? c % 360.0f + 360.0f : (c > 360.0f ? c % 360.0f : c);
            }
        }
        throw new IllegalArgumentException("Invalid color specification");
    }

    private static Color parseRGBColor(String color, int roff) {
        try {
            int rend = color.indexOf(44, roff);
            int gend = rend < 0 ? -1 : color.indexOf(44, rend + 1);
            int bend = gend < 0 ? -1 : color.indexOf(gend + 1);
            float r = ColorUtil.parseComponent(color, roff, rend, 0);
            float g = ColorUtil.parseComponent(color, rend + 1, gend, 0);
            float b = ColorUtil.parseComponent(color, gend + 1, bend, 0);
            return new Color(r, g, b);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid color specification");
        }
    }

    private static Color parseHSLColor(String color, int hoff) {
        try {
            int hend = color.indexOf(44, hoff);
            int send = hend < 0 ? -1 : color.indexOf(44, hend + 1);
            int lend = send < 0 ? -1 : color.indexOf(send + 1);
            float h = ColorUtil.parseComponent(color, hoff, hend, 2);
            float s = ColorUtil.parseComponent(color, hend + 1, send, 1);
            float l = ColorUtil.parseComponent(color, send + 1, lend, 1);
            return Color.getHSBColor(h, s, l);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid color specification");
        }
    }

    public static Color parseColor(String colorString) {
        if (colorString == null) {
            throw new NullPointerException("The color components or name must be specified");
        }
        if (colorString.isEmpty()) {
            throw new IllegalArgumentException("Invalid color specification");
        }
        String color = colorString.toLowerCase(Locale.ROOT);
        if (color.startsWith("#")) {
            color = color.substring(1);
        } else if (color.startsWith("0x")) {
            color = color.substring(2);
        } else if (color.startsWith("rgb")) {
            if (color.startsWith("(", 3)) {
                return ColorUtil.parseRGBColor(color, 4);
            }
            if (color.startsWith("a(", 3)) {
                return ColorUtil.parseRGBColor(color, 5);
            }
        } else if (color.startsWith("hsl")) {
            if (color.startsWith("(", 3)) {
                return ColorUtil.parseHSLColor(color, 4);
            }
            if (color.startsWith("a(", 3)) {
                return ColorUtil.parseHSLColor(color, 5);
            }
        } else {
            Color col = null;
            try {
                Field field = Color.class.getField(color.toLowerCase());
                col = (Color)field.get(null);
            }
            catch (Throwable field) {
                // empty catch block
            }
            if (col != null) {
                return col;
            }
        }
        int len = color.length();
        try {
            if (len == 3) {
                int r = Integer.parseInt(color.substring(0, 1), 16);
                int g = Integer.parseInt(color.substring(1, 2), 16);
                int b = Integer.parseInt(color.substring(2, 3), 16);
                return new Color((float)r / 15.0f, (float)g / 15.0f, (float)b / 15.0f);
            }
            if (len == 4) {
                int r = Integer.parseInt(color.substring(0, 1), 16);
                int g = Integer.parseInt(color.substring(1, 2), 16);
                int b = Integer.parseInt(color.substring(2, 3), 16);
                return new Color((float)r / 15.0f, (float)g / 15.0f, (float)b / 15.0f);
            }
            if (len == 6) {
                int r = Integer.parseInt(color.substring(0, 2), 16);
                int g = Integer.parseInt(color.substring(2, 4), 16);
                int b = Integer.parseInt(color.substring(4, 6), 16);
                return new Color(r, g, b);
            }
            if (len == 8) {
                int r = Integer.parseInt(color.substring(0, 2), 16);
                int g = Integer.parseInt(color.substring(2, 4), 16);
                int b = Integer.parseInt(color.substring(4, 6), 16);
                return new Color(r, g, b);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new IllegalArgumentException("Invalid color specification");
    }
}

