/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.util;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.object.pattern.PatternExtent;
import com.boydti.fawe.util.FilteredTextureUtil;
import com.boydti.fawe.util.MainUtil;
import com.boydti.fawe.util.MaskTraverser;
import com.boydti.fawe.util.MathMan;
import com.boydti.fawe.util.StringMan;
import com.boydti.fawe.util.TextureHolder;
import com.boydti.fawe.util.image.ImageUtil;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.blocks.BlockMaterial;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.pattern.BlockPattern;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;

public class TextureUtil
implements TextureHolder {
    private final File folder;
    private static final int[] FACTORS = new int[766];
    protected int[] blockColors = new int[BlockTypes.size()];
    protected long[] blockDistance = new long[BlockTypes.size()];
    protected long[] distances;
    protected int[] validColors;
    protected int[] validBlockIds;
    protected int[] validLayerColors;
    protected int[][] validLayerBlocks;
    protected int[] validMixBiomeColors;
    protected long[] validMixBiomeIds;
    protected BiomeColor[] validBiomes;
    private BiomeColor[] biomes = new BiomeColor[]{new BiomeColor(0, "Ocean", 0.5f, 0.5f, 9616729, 7842607), new BiomeColor(1, "Plains", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(2, "Desert", 2.0f, 0.0f, 9616729, 7842607), new BiomeColor(3, "Extreme Hills", 0.2f, 0.3f, 9616729, 7842607), new BiomeColor(4, "Forest", 0.7f, 0.8f, 9616729, 7842607), new BiomeColor(5, "Taiga", 0.25f, 0.8f, 9616729, 7842607), new BiomeColor(6, "Swampland", 0.8f, 0.9f, 9616729, 7842607), new BiomeColor(7, "River", 0.5f, 0.5f, 9616729, 7842607), new BiomeColor(8, "Nether", 2.0f, 0.0f, 9616729, 7842607), new BiomeColor(9, "End", 0.5f, 0.5f, 9616729, 7842607), new BiomeColor(10, "Frozen Ocean", 0.0f, 0.5f, 9616729, 7842607), new BiomeColor(11, "Frozen River", 0.0f, 0.5f, 9616729, 7842607), new BiomeColor(12, "Ice Plains", 0.0f, 0.5f, 9616729, 7842607), new BiomeColor(13, "Ice Mountains", 0.0f, 0.5f, 9616729, 7842607), new BiomeColor(14, "Mushroom Island", 0.9f, 1.0f, 9616729, 7842607), new BiomeColor(15, "Mushroom Island Shore", 0.9f, 1.0f, 9616729, 7842607), new BiomeColor(16, "Beach", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(17, "Desert Hills", 2.0f, 0.0f, 9616729, 7842607), new BiomeColor(18, "Forest Hills", 0.7f, 0.8f, 9616729, 7842607), new BiomeColor(19, "Taiga Hills", 0.25f, 0.8f, 9616729, 7842607), new BiomeColor(20, "Extreme Hills Edge", 0.2f, 0.3f, 9616729, 7842607), new BiomeColor(21, "Jungle", 0.95f, 0.9f, 9616729, 7842607), new BiomeColor(22, "Jungle Hills", 0.95f, 0.9f, 9616729, 7842607), new BiomeColor(23, "Jungle Edge", 0.95f, 0.8f, 9616729, 7842607), new BiomeColor(24, "Deep Ocean", 0.5f, 0.5f, 9616729, 7842607), new BiomeColor(25, "Stone Beach", 0.2f, 0.3f, 9616729, 7842607), new BiomeColor(26, "Cold Beach", 0.05f, 0.3f, 9616729, 7842607), new BiomeColor(27, "Birch Forest", 0.6f, 0.6f, 9616729, 7842607), new BiomeColor(28, "Birch Forest Hills", 0.6f, 0.6f, 9616729, 7842607), new BiomeColor(29, "Roofed Forest", 0.7f, 0.8f, 9616729, 7842607), new BiomeColor(30, "Cold Taiga", -0.5f, 0.4f, 9616729, 7842607), new BiomeColor(31, "Cold Taiga Hills", -0.5f, 0.4f, 9616729, 7842607), new BiomeColor(32, "Mega Taiga", 0.3f, 0.8f, 9616729, 7842607), new BiomeColor(33, "Mega Taiga Hills", 0.3f, 0.8f, 9616729, 7842607), new BiomeColor(34, "Extreme Hills+", 0.2f, 0.3f, 9616729, 7842607), new BiomeColor(35, "Savanna", 1.2f, 0.0f, 9616729, 7842607), new BiomeColor(36, "Savanna Plateau", 1.0f, 0.0f, 9616729, 7842607), new BiomeColor(37, "Mesa", 2.0f, 0.0f, 9616729, 7842607), new BiomeColor(38, "Mesa Plateau F", 2.0f, 0.0f, 9616729, 7842607), new BiomeColor(39, "Mesa Plateau", 2.0f, 0.0f, 9616729, 7842607), new BiomeColor(40, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(41, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(42, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(43, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(44, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(45, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(46, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(47, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(48, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(49, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(50, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(51, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(52, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(53, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(54, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(55, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(56, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(57, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(58, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(59, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(60, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(61, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(62, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(63, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(64, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(65, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(66, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(67, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(68, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(69, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(70, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(71, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(72, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(73, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(74, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(75, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(76, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(77, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(78, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(79, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(80, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(81, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(82, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(83, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(84, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(85, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(86, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(87, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(88, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(89, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(90, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(91, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(92, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(93, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(94, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(95, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(96, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(97, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(98, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(99, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(100, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(101, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(102, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(103, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(104, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(105, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(106, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(107, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(108, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(109, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(110, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(111, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(112, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(113, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(114, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(115, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(116, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(117, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(118, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(119, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(120, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(121, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(122, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(123, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(124, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(125, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(126, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(127, "The Void", 0.5f, 0.5f, 9616729, 7842607), new BiomeColor(128, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(129, "Sunflower Plains", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(130, "Desert M", 2.0f, 0.0f, 9616729, 7842607), new BiomeColor(131, "Extreme Hills M", 0.2f, 0.3f, 9616729, 7842607), new BiomeColor(132, "Flower Forest", 0.7f, 0.8f, 9616729, 7842607), new BiomeColor(133, "Taiga M", 0.25f, 0.8f, 9616729, 7842607), new BiomeColor(134, "Swampland M", 0.8f, 0.9f, 9616729, 7842607), new BiomeColor(135, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(136, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(137, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(138, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(139, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(140, "Ice Plains Spikes", 0.0f, 0.5f, 9616729, 7842607), new BiomeColor(141, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(142, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(143, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(144, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(145, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(146, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(147, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(148, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(149, "Jungle M", 0.95f, 0.9f, 9616729, 7842607), new BiomeColor(150, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(151, "JungleEdge M", 0.95f, 0.8f, 9616729, 7842607), new BiomeColor(152, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(153, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(154, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(155, "Birch Forest M", 0.6f, 0.6f, 9616729, 7842607), new BiomeColor(156, "Birch Forest Hills M", 0.6f, 0.6f, 9616729, 7842607), new BiomeColor(157, "Roofed Forest M", 0.7f, 0.8f, 9616729, 7842607), new BiomeColor(158, "Cold Taiga M", -0.5f, 0.4f, 9616729, 7842607), new BiomeColor(159, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(160, "Mega Spruce Taiga", 0.25f, 0.8f, 9616729, 7842607), new BiomeColor(161, "Mega Spruce Taiga Hills", 0.25f, 0.8f, 9616729, 7842607), new BiomeColor(162, "Extreme Hills+ M", 0.2f, 0.3f, 9616729, 7842607), new BiomeColor(163, "Savanna M", 1.1f, 0.0f, 9616729, 7842607), new BiomeColor(164, "Savanna Plateau M", 1.0f, 0.0f, 9616729, 7842607), new BiomeColor(165, "Mesa (Bryce)", 2.0f, 0.0f, 9616729, 7842607), new BiomeColor(166, "Mesa Plateau F M", 2.0f, 0.0f, 9616729, 7842607), new BiomeColor(167, "Mesa Plateau M", 2.0f, 0.0f, 9616729, 7842607), new BiomeColor(168, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(169, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(170, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(171, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(172, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(173, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(174, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(175, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(176, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(177, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(178, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(179, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(180, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(181, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(182, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(183, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(184, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(185, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(186, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(187, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(188, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(189, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(190, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(191, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(192, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(193, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(194, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(195, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(196, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(197, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(198, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(199, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(200, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(201, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(202, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(203, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(204, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(205, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(206, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(207, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(208, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(209, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(210, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(211, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(212, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(213, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(214, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(215, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(216, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(217, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(218, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(219, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(220, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(221, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(222, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(223, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(224, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(225, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(226, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(227, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(228, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(229, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(230, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(231, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(232, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(233, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(234, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(235, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(236, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(237, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(238, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(239, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(240, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(241, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(242, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(243, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(244, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(245, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(246, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(247, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(248, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(249, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(250, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(251, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(252, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(253, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(254, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607), new BiomeColor(255, "Unknown Biome", 0.8f, 0.4f, 9616729, 7842607)};
    private BlockTypes[] layerBuffer = new BlockTypes[2];

    public static TextureUtil fromClipboard(Clipboard clipboard) throws FileNotFoundException {
        boolean[] ids = new boolean[BlockTypes.size()];
        for (Vector pt : clipboard.getRegion()) {
            ids[clipboard.getBlock((Vector)pt).getInternalBlockTypeId()] = true;
        }
        HashSet<BlockType> blocks = new HashSet<BlockType>();
        for (int typeId = 0; typeId < ids.length; ++typeId) {
            if (!ids[typeId]) continue;
            blocks.add(BlockTypes.get(typeId));
        }
        return TextureUtil.fromBlocks(blocks);
    }

    public static TextureUtil fromBlocks(Set<BlockType> blocks) throws FileNotFoundException {
        return new FilteredTextureUtil(Fawe.get().getTextureUtil(), blocks);
    }

    public static TextureUtil fromMask(Mask mask) throws FileNotFoundException {
        HashSet<BlockType> blocks = new HashSet<BlockType>();
        BlockPattern pattern = new BlockPattern(BlockTypes.AIR.getDefaultState());
        PatternExtent extent = new PatternExtent(pattern);
        new MaskTraverser(mask).reset(extent);
        TextureUtil tu = Fawe.get().getTextureUtil();
        for (int typeId : tu.getValidBlockIds()) {
            BlockTypes block = BlockTypes.get(typeId);
            pattern.setBlock(block.getDefaultState());
            if (!mask.test(Vector.ZERO)) continue;
            blocks.add(block);
        }
        return TextureUtil.fromBlocks(blocks);
    }

    @Override
    public TextureUtil getTextureUtil() {
        return this;
    }

    public TextureUtil() throws FileNotFoundException {
        this(MainUtil.getFile(Fawe.imp().getDirectory(), Settings.IMP.PATHS.TEXTURES));
    }

    public TextureUtil(File folder) throws FileNotFoundException {
        this.folder = folder;
        if (!folder.exists()) {
            throw new FileNotFoundException("Please create a `FastAsyncWorldEdit/textures` folder with `.minecraft/versions` jar or mods in it.");
        }
    }

    public BlockTypes getNearestBlock(int color) {
        long min = Long.MAX_VALUE;
        int closest = 0;
        int red1 = color >> 16 & 0xFF;
        int green1 = color >> 8 & 0xFF;
        int blue1 = color >> 0 & 0xFF;
        int alpha = color >> 24 & 0xFF;
        for (int i = 0; i < this.validColors.length; ++i) {
            long distance;
            int other = this.validColors[i];
            if ((other >> 24 & 0xFF) != alpha || (distance = this.colorDistance(red1, green1, blue1, other)) >= min) continue;
            min = distance;
            closest = this.validBlockIds[i];
        }
        if (min == Long.MAX_VALUE) {
            return null;
        }
        return BlockTypes.get(closest);
    }

    public BlockType getNearestBlock(BlockType block) {
        int color = this.getColor(block);
        if (color == 0) {
            return null;
        }
        return this.getNextNearestBlock(color);
    }

    public BlockType getNextNearestBlock(int color) {
        long min = Long.MAX_VALUE;
        int closest = 0;
        int red1 = color >> 16 & 0xFF;
        int green1 = color >> 8 & 0xFF;
        int blue1 = color >> 0 & 0xFF;
        int alpha = color >> 24 & 0xFF;
        for (int i = 0; i < this.validColors.length; ++i) {
            long distance;
            int other = this.validColors[i];
            if (other == color || (other >> 24 & 0xFF) != alpha || (distance = this.colorDistance(red1, green1, blue1, other)) >= min) continue;
            min = distance;
            closest = this.validBlockIds[i];
        }
        if (min == Long.MAX_VALUE) {
            return null;
        }
        return BlockTypes.get(closest);
    }

    public BlockTypes[] getNearestLayer(int color) {
        int[] closest = null;
        long min = Long.MAX_VALUE;
        int red1 = color >> 16 & 0xFF;
        int green1 = color >> 8 & 0xFF;
        int blue1 = color >> 0 & 0xFF;
        int alpha = color >> 24 & 0xFF;
        for (int i = 0; i < this.validLayerColors.length; ++i) {
            long distance;
            int other = this.validLayerColors[i];
            if ((other >> 24 & 0xFF) != alpha || (distance = this.colorDistance(red1, green1, blue1, other)) >= min) continue;
            min = distance;
            closest = this.validLayerBlocks[i];
        }
        this.layerBuffer[0] = BlockTypes.get((int)closest[0]);
        this.layerBuffer[1] = BlockTypes.get((int)closest[1]);
        return this.layerBuffer;
    }

    public BlockType getLighterBlock(BlockType block) {
        return this.getNearestBlock(block, false);
    }

    public BlockType getDarkerBlock(BlockType block) {
        return this.getNearestBlock(block, true);
    }

    public int getColor(BlockType block) {
        return this.blockColors[block.getInternalId()];
    }

    public BiomeColor getBiome(int biome) {
        return this.biomes[biome];
    }

    public boolean getIsBlockCloserThanBiome(int[] blockAndBiomeIdOutput, int color, int biomePriority) {
        BlockTypes block = this.getNearestBlock(color);
        BiomeColor biome = this.getNearestBiome(color);
        int blockColor = this.getColor(block);
        blockAndBiomeIdOutput[0] = block.getInternalId();
        blockAndBiomeIdOutput[1] = biome.id;
        return this.colorDistance(biome.grassCombined, color) - (long)biomePriority > this.colorDistance(blockColor, color);
    }

    public int getBiomeMix(int[] biomeIdsOutput, int color) {
        long closest = Long.MAX_VALUE;
        int closestAverage = Integer.MAX_VALUE;
        long min = Long.MAX_VALUE;
        int red1 = color >> 16 & 0xFF;
        int green1 = color >> 8 & 0xFF;
        int blue1 = color >> 0 & 0xFF;
        int alpha = color >> 24 & 0xFF;
        for (int i = 0; i < this.validMixBiomeColors.length; ++i) {
            long distance;
            int other = this.validMixBiomeColors[i];
            if ((other >> 24 & 0xFF) != alpha || (distance = this.colorDistance(red1, green1, blue1, other)) >= min) continue;
            min = distance;
            closest = this.validMixBiomeIds[i];
            closestAverage = other;
        }
        biomeIdsOutput[0] = (int)(closest >> 0 & 0xFFL);
        biomeIdsOutput[1] = (int)(closest >> 8 & 0xFFL);
        biomeIdsOutput[2] = (int)(closest >> 16 & 0xFFL);
        return closestAverage;
    }

    public BiomeColor getNearestBiome(int color) {
        int grass = this.blockColors[BlockTypes.GRASS_BLOCK.getInternalId()];
        if (grass == 0) {
            return null;
        }
        BiomeColor closest = null;
        long min = Long.MAX_VALUE;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color >> 0 & 0xFF;
        for (int i = 0; i < this.validBiomes.length; ++i) {
            BiomeColor biome = this.validBiomes[i];
            long distance = this.colorDistance(red, green, blue, biome.grassCombined);
            if (distance >= min) continue;
            min = distance;
            closest = biome;
        }
        return closest;
    }

    public File getFolder() {
        return this.folder;
    }

    public long colorDistance(int c1, int c2) {
        int red1 = c1 >> 16 & 0xFF;
        int green1 = c1 >> 8 & 0xFF;
        int blue1 = c1 >> 0 & 0xFF;
        return this.colorDistance(red1, green1, blue1, c2);
    }

    private BufferedImage readImage(ZipFile zipFile, String name) throws IOException {
        ZipEntry entry = this.getEntry(zipFile, name);
        if (entry != null) {
            try (InputStream is = zipFile.getInputStream(entry);){
                BufferedImage bufferedImage = ImageIO.read(is);
                return bufferedImage;
            }
        }
        return null;
    }

    private ZipEntry getEntry(ZipFile file, String path) {
        ZipEntry entry = file.getEntry(path);
        if (entry == null) {
            path = path.replace("/", File.separator);
            entry = file.getEntry(path);
        }
        return entry;
    }

    /*
     * WARNING - void declaration
     */
    public void loadModTextures() throws IOException {
        Int2ObjectOpenHashMap colorMap = new Int2ObjectOpenHashMap();
        Int2ObjectOpenHashMap distanceMap = new Int2ObjectOpenHashMap();
        Gson gson = new Gson();
        if (this.folder.exists()) {
            File[] files = this.folder.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar");
                }
            });
            for (ObjectIterator objectIterator : BlockTypes.values) {
                int color;
                BlockMaterial material = objectIterator.getMaterial();
                if (!material.isSolid() || !material.isFullCube() || (color = material.getMapColor()) == 0) continue;
                colorMap.put(objectIterator.getInternalId(), (Object)color);
            }
            if (files.length == 0) {
                Fawe.debug("Please create a `FastAsyncWorldEdit/textures` folder with `.minecraft/versions/1.13.jar` jar or mods in it. If the file exists, please make sure the server has read access to the directory");
            } else {
                for (File file : files) {
                    ZipEntry grassEntry;
                    ZipFile zipFile = new ZipFile(file);
                    HashSet<String> mods = new HashSet<String>();
                    Enumeration<? extends ZipEntry> entries = zipFile.entries();
                    while (entries.hasMoreElements()) {
                        String[] split;
                        ZipEntry entry = entries.nextElement();
                        String name = entry.getName();
                        BlockTypes[] path = Paths.get(name, new String[0]);
                        if (!path.startsWith("assets" + File.separator) || (split = path.toString().split(Pattern.quote(File.separator))).length <= 1) continue;
                        String modId = split[1];
                        mods.add(modId);
                    }
                    String modelsDir = "assets/%1$s/models/block/%2$s.json";
                    String texturesDir = "assets/%1$s/textures/%2$s.png";
                    Type typeToken = new TypeToken<Map<String, Object>>(){}.getType();
                    for (BlockTypes blockTypes : BlockTypes.values) {
                        String textureFileName;
                        if (!blockTypes.getMaterial().isFullCube()) continue;
                        int combined = blockTypes.getInternalId();
                        String id = blockTypes.getId();
                        String[] split = id.split(":", 2);
                        String name = split.length == 1 ? id : split[1];
                        String nameSpace = split.length == 1 ? "minecraft" : split[0];
                        ConcurrentHashMap texturesMap = new ConcurrentHashMap();
                        String modelFileName = String.format(modelsDir, nameSpace, name);
                        ZipEntry entry = this.getEntry(zipFile, modelFileName);
                        if (entry == null) {
                            System.out.println("Cannot find " + modelFileName + " in " + file);
                            continue;
                        }
                        try (InputStream is = zipFile.getInputStream(entry);){
                            JsonReader reader = new JsonReader((Reader)new InputStreamReader(is, "UTF-8"));
                            Map root = (Map)gson.fromJson(reader, typeToken);
                            Map textures = (Map)root.get("textures");
                            if (textures == null) continue;
                            HashSet<String> models = new HashSet<String>();
                            for (Map.Entry stringObjectEntry : textures.entrySet()) {
                                Object value = stringObjectEntry.getValue();
                                if (value instanceof String) {
                                    models.add((String)value);
                                    continue;
                                }
                                if (!(value instanceof Map) || (value = ((Map)value).get("model")) == null) continue;
                                models.add((String)value);
                            }
                            if (models.size() != 1) continue;
                            textureFileName = String.format(texturesDir, nameSpace, models.iterator().next());
                        }
                        BufferedImage image = this.readImage(zipFile, textureFileName);
                        if (image == null) {
                            System.out.println("Cannot find " + textureFileName);
                            continue;
                        }
                        int color = ImageUtil.getColor(image);
                        long distance = this.getDistance(image, color);
                        distanceMap.put(combined, (Object)distance);
                        colorMap.put(combined, (Object)color);
                    }
                    Integer grass = null;
                    String grassFileName = String.format(texturesDir, "minecraft", "grass_block_top");
                    BufferedImage image = this.readImage(zipFile, grassFileName);
                    if (image != null) {
                        grass = ImageUtil.getColor(image);
                    }
                    if (grass != null && (grassEntry = this.getEntry(zipFile, "assets/minecraft/textures/colormap/grass_block.png")) != null) {
                        int i;
                        void var17_32;
                        Throwable throwable = null;
                        try (InputStream is = zipFile.getInputStream(grassEntry);){
                            BufferedImage image2 = ImageIO.read(is);
                            for (int i2 = 0; i2 < this.biomes.length; ++i2) {
                                BiomeColor biome = this.biomes[i2];
                                float adjTemp = MathMan.clamp(biome.temperature, 0.0f, 1.0f);
                                float adjRainfall = MathMan.clamp(biome.rainfall, 0.0f, 1.0f) * adjTemp;
                                int x = (int)(255.0f - adjTemp * 255.0f);
                                int z = (int)(255.0f - adjRainfall * 255.0f);
                                biome.grass = image2.getRGB(x, z);
                            }
                        }
                        catch (Throwable image2) {
                            Throwable throwable2 = image2;
                            throw image2;
                        }
                        this.biomes[6].grass = 0;
                        this.biomes[134].grass = 0;
                        this.biomes[29].grass = this.multiplyColor(this.biomes[29].grass, -14142454);
                        this.biomes[157].grass = this.multiplyColor(this.biomes[157].grass, -14142454);
                        this.biomes[37].grass = -7306931;
                        this.biomes[38].grass = -7306931;
                        this.biomes[39].grass = -7306931;
                        this.biomes[165].grass = -7306931;
                        this.biomes[166].grass = -7306931;
                        this.biomes[167].grass = -7306931;
                        ArrayList<BiomeColor> valid = new ArrayList<BiomeColor>();
                        boolean bl = false;
                        while (var17_32 < this.biomes.length) {
                            BiomeColor biome = this.biomes[var17_32];
                            if (biome.grass != 0 && !biome.name.equalsIgnoreCase("Unknown Biome")) {
                                valid.add(biome);
                            }
                            biome.grassCombined = this.multiplyColor(grass, biome.grass);
                            ++var17_32;
                        }
                        this.validBiomes = valid.toArray(new BiomeColor[valid.size()]);
                        ArrayList<BiomeColor> arrayList = new ArrayList<BiomeColor>();
                        IntArraySet uniqueBiomesColors = new IntArraySet();
                        for (BiomeColor color : this.validBiomes) {
                            if (!uniqueBiomesColors.add(color.grass)) continue;
                            arrayList.add(color);
                        }
                        int count = 0;
                        boolean count2 = false;
                        uniqueBiomesColors.clear();
                        LongArrayList layerIds = new LongArrayList();
                        LongArrayList layerColors = new LongArrayList();
                        for (i = 0; i < arrayList.size(); ++i) {
                            for (int j = i; j < arrayList.size(); ++j) {
                                for (int k = j; k < arrayList.size(); ++k) {
                                    BiomeColor c1 = (BiomeColor)arrayList.get(i);
                                    BiomeColor c2 = (BiomeColor)arrayList.get(j);
                                    BiomeColor c3 = (BiomeColor)arrayList.get(k);
                                    int average = this.averageColor(c1.grass, c2.grass, c3.grass);
                                    if (!uniqueBiomesColors.add(average)) continue;
                                    ++count;
                                    layerColors.add((long)average);
                                    layerIds.add((long)(c1.id + (c2.id << 8) + (c3.id << 16)));
                                }
                            }
                        }
                        this.validMixBiomeColors = new int[layerColors.size()];
                        for (i = 0; i < layerColors.size(); ++i) {
                            this.validMixBiomeColors[i] = (int)layerColors.getLong(i);
                        }
                        this.validMixBiomeIds = layerIds.toLongArray();
                    }
                    zipFile.close();
                }
            }
        }
        this.validBlockIds = new int[colorMap.size()];
        this.validColors = new int[colorMap.size()];
        int index = 0;
        for (Int2ObjectMap.Entry entry : colorMap.int2ObjectEntrySet()) {
            int n;
            int combinedId = entry.getIntKey();
            this.blockColors[combinedId] = n = ((Integer)entry.getValue()).intValue();
            this.validBlockIds[index] = combinedId;
            this.validColors[index] = n;
            ++index;
        }
        ArrayList distances = new ArrayList(distanceMap.values());
        Collections.sort(distances);
        this.distances = new long[distances.size()];
        for (int i = 0; i < this.distances.length; ++i) {
            this.distances[i] = (Long)distances.get(i);
        }
        for (Int2ObjectMap.Entry entry : distanceMap.int2ObjectEntrySet()) {
            this.blockDistance[entry.getIntKey()] = (Long)entry.getValue();
        }
        this.calculateLayerArrays();
    }

    public int multiplyColor(int c1, int c2) {
        int alpha1 = c1 >> 24 & 0xFF;
        int alpha2 = c2 >> 24 & 0xFF;
        int red1 = c1 >> 16 & 0xFF;
        int green1 = c1 >> 8 & 0xFF;
        int blue1 = c1 >> 0 & 0xFF;
        int red2 = c2 >> 16 & 0xFF;
        int green2 = c2 >> 8 & 0xFF;
        int blue2 = c2 >> 0 & 0xFF;
        int red = red1 * red2 / 255;
        int green = green1 * green2 / 255;
        int blue = blue1 * blue2 / 255;
        int alpha = alpha1 * alpha2 / 255;
        return (alpha << 24) + (red << 16) + (green << 8) + (blue << 0);
    }

    public int averageColor(int c1, int c2) {
        int alpha1 = c1 >> 24 & 0xFF;
        int alpha2 = c2 >> 24 & 0xFF;
        int red1 = c1 >> 16 & 0xFF;
        int green1 = c1 >> 8 & 0xFF;
        int blue1 = c1 >> 0 & 0xFF;
        int red2 = c2 >> 16 & 0xFF;
        int green2 = c2 >> 8 & 0xFF;
        int blue2 = c2 >> 0 & 0xFF;
        int red = red1 + red2 >> 1;
        int green = green1 + green2 >> 1;
        int blue = blue1 + blue2 >> 1;
        int alpha = alpha1 + alpha2 >> 1;
        return (alpha << 24) + (red << 16) + (green << 8) + (blue << 0);
    }

    public int averageColor(int ... colors) {
        int alpha = 0;
        int red = 0;
        int green = 0;
        int blue = 0;
        for (int c : colors) {
            alpha += c >> 24 & 0xFF;
            red += c >> 16 & 0xFF;
            green += c >> 8 & 0xFF;
            blue += c >> 0 & 0xFF;
        }
        int num = colors.length;
        return ((alpha /= num) << 24) + ((red /= num) << 16) + ((green /= num) << 8) + ((blue /= num) << 0);
    }

    public int combineTransparency(int top, int bottom) {
        int alpha1 = top >> 24 & 0xFF;
        int alpha2 = 255 - alpha1;
        int red1 = top >> 16 & 0xFF;
        int green1 = top >> 8 & 0xFF;
        int blue1 = top >> 0 & 0xFF;
        int red2 = bottom >> 16 & 0xFF;
        int green2 = bottom >> 8 & 0xFF;
        int blue2 = bottom >> 0 & 0xFF;
        int red = (red1 * alpha1 + red2 * alpha2) / 255;
        int green = (green1 * alpha1 + green2 * alpha2) / 255;
        int blue = (blue1 * alpha1 + blue2 * alpha2) / 255;
        return (red << 16) + (green << 8) + (blue << 0) + -16777216;
    }

    protected void calculateLayerArrays() {
        Int2ObjectOpenHashMap colorLayerMap = new Int2ObjectOpenHashMap();
        for (int i = 0; i < this.validBlockIds.length; ++i) {
            int color = this.validColors[i];
            int combined = this.validBlockIds[i];
            if (!this.hasAlpha(color)) continue;
            for (int j = 0; j < this.validBlockIds.length; ++j) {
                int colorOther = this.validColors[j];
                if (this.hasAlpha(colorOther)) continue;
                int combinedOther = this.validBlockIds[j];
                int combinedColor = this.combineTransparency(color, colorOther);
                colorLayerMap.put(combinedColor, (Object)new int[]{combined, combinedOther});
            }
        }
        this.validLayerColors = new int[colorLayerMap.size()];
        this.validLayerBlocks = new int[colorLayerMap.size()][];
        int index = 0;
        for (Int2ObjectMap.Entry entry : colorLayerMap.int2ObjectEntrySet()) {
            this.validLayerColors[index] = entry.getIntKey();
            this.validLayerBlocks[index++] = (int[])entry.getValue();
        }
    }

    protected BlockType getNearestBlock(BlockType block, boolean darker) {
        int color = this.getColor(block);
        if (color == 0) {
            return block;
        }
        BlockType darkerBlock = this.getNearestBlock(color, darker);
        return darkerBlock != null ? darkerBlock : block;
    }

    protected BlockType getNearestBlock(int color, boolean darker) {
        long min = Long.MAX_VALUE;
        int closest = 0;
        int red1 = color >> 16 & 0xFF;
        int green1 = color >> 8 & 0xFF;
        int blue1 = color >> 0 & 0xFF;
        int alpha = color >> 24 & 0xFF;
        int intensity1 = 2 * red1 + 4 * green1 + 3 * blue1;
        for (int i = 0; i < this.validColors.length; ++i) {
            long distance;
            int other = this.validColors[i];
            if (other == color || (other >> 24 & 0xFF) != alpha) continue;
            int red2 = other >> 16 & 0xFF;
            int green2 = other >> 8 & 0xFF;
            int blue2 = other >> 0 & 0xFF;
            int intensity2 = 2 * red2 + 4 * green2 + 3 * blue2;
            if ((!darker ? intensity1 >= intensity2 : intensity2 >= intensity1) || (distance = this.colorDistance(red1, green1, blue1, other)) >= min) continue;
            min = distance;
            closest = this.validBlockIds[i];
        }
        if (min == Long.MAX_VALUE) {
            return null;
        }
        return BlockTypes.get(closest);
    }

    private String getFileName(String path) {
        String[] split = path.toString().split("[/|\\\\]");
        String name = split[split.length - 1];
        int dot = name.indexOf(46);
        if (dot != -1) {
            name = name.substring(0, dot);
        }
        return name;
    }

    private String alphabetize(String asset) {
        Object[] split = asset.split("_");
        Arrays.sort(split);
        return StringMan.join(split, "_");
    }

    protected boolean hasAlpha(int color) {
        int alpha = color >> 24 & 0xFF;
        return alpha != 255;
    }

    protected long colorDistance(int red1, int green1, int blue1, int c2) {
        int red2 = c2 >> 16 & 0xFF;
        int green2 = c2 >> 8 & 0xFF;
        int blue2 = c2 >> 0 & 0xFF;
        int rmean = red1 + red2 >> 1;
        int r = red1 - red2;
        int g = green1 - green2;
        int b = blue1 - blue2;
        int hd = TextureUtil.hueDistance(red1, green1, blue1, red2, green2, blue2);
        return ((512 + rmean) * r * r >> 8) + 4 * g * g + ((767 - rmean) * b * b >> 8) + hd * hd;
    }

    protected static int hueDistance(int red1, int green1, int blue1, int red2, int green2, int blue2) {
        int total1 = red1 + green1 + blue1;
        int total2 = red2 + green2 + blue2;
        if (total1 == 0 || total2 == 0) {
            return 0;
        }
        int factor1 = FACTORS[total1];
        int factor2 = FACTORS[total2];
        long r = 512 * (red1 * factor1 - red2 * factor2) >> 10;
        long g = green1 * factor1 - green2 * factor2;
        long b = 767 * (blue1 * factor1 - blue2 * factor2) >> 10;
        return (int)(r * r + g * g + b * b >> 25);
    }

    public long getDistance(BufferedImage image, int c1) {
        long totalDistSqr = 0L;
        int width = image.getWidth();
        int height = image.getHeight();
        int area = width * height;
        int red1 = c1 >> 16 & 0xFF;
        int green1 = c1 >> 8 & 0xFF;
        int blue1 = c1 >> 0 & 0xFF;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int c2 = image.getRGB(x, y);
                long distance = this.colorDistance(red1, green1, blue1, c2);
                totalDistSqr += distance * distance;
            }
        }
        return totalDistSqr / (long)area;
    }

    public int[] getValidBlockIds() {
        return (int[])this.validBlockIds.clone();
    }

    static {
        for (int i = 1; i < FACTORS.length; ++i) {
            TextureUtil.FACTORS[i] = 65535 / i;
        }
    }

    public static class BiomeColor {
        public int id;
        public String name;
        public float temperature;
        public float rainfall;
        public int grass;
        public int grassCombined;
        public int foliage;

        public BiomeColor(int id, String name, float temperature, float rainfall, int grass, int foliage) {
            this.id = id;
            this.name = name;
            this.temperature = temperature;
            this.rainfall = rainfall;
            this.grass = grass;
            this.grassCombined = grass;
            this.foliage = foliage;
        }
    }
}

