/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.util.chat;

import com.boydti.fawe.config.BBC;
import com.boydti.fawe.config.Commands;
import com.boydti.fawe.util.MainUtil;
import com.boydti.fawe.util.StringMan;
import com.boydti.fawe.util.chat.Message;
import com.google.common.base.Preconditions;
import com.sk89q.minecraft.util.commands.CommandLocals;
import com.sk89q.minecraft.util.commands.Link;
import com.sk89q.worldedit.extension.platform.CommandManager;
import com.sk89q.worldedit.util.command.CommandCallable;
import com.sk89q.worldedit.util.command.CommandMapping;
import com.sk89q.worldedit.util.command.Description;
import com.sk89q.worldedit.util.command.Dispatcher;
import com.sk89q.worldedit.util.command.Parameter;
import com.sk89q.worldedit.util.command.PrimaryAliasComparator;
import com.sk89q.worldedit.util.command.binding.Range;
import com.sk89q.worldedit.util.command.parametric.ParameterData;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public class UsageMessage
extends Message {
    public UsageMessage(CommandCallable command, String commandString) {
        this(command, commandString, null);
    }

    public UsageMessage(CommandCallable command, String commandString, @Nullable CommandLocals locals) {
        Preconditions.checkNotNull((Object)command);
        Preconditions.checkNotNull((Object)commandString);
        if (command instanceof Dispatcher) {
            this.attachDispatcherUsage((Dispatcher)command, commandString, locals);
        } else {
            this.attachCommandUsage(command.getDescription(), commandString);
        }
    }

    private void attachDispatcherUsage(Dispatcher dispatcher, String commandString, @Nullable CommandLocals locals) {
        this.prefix();
        this.text(BBC.HELP_HEADER_SUBCOMMANDS.f(new Object[0]));
        String prefix = !commandString.isEmpty() ? commandString + " " : "";
        ArrayList<CommandMapping> list = new ArrayList<CommandMapping>(dispatcher.getCommands());
        Collections.sort(list, new PrimaryAliasComparator(CommandManager.COMMAND_CLEAN_PATTERN));
        for (CommandMapping mapping : list) {
            boolean perm = locals == null || mapping.getCallable().testPermission(locals);
            this.newline();
            String cmd = prefix + mapping.getPrimaryAlias();
            this.text((perm ? BBC.HELP_ITEM_ALLOWED : BBC.HELP_ITEM_DENIED).format(cmd, mapping.getDescription().getDescription()));
            this.command(cmd);
        }
    }

    protected String separateArg(String arg) {
        return " " + arg;
    }

    private void attachCommandUsage(Description description, String commandString) {
        int i;
        String[] usage;
        List<Parameter> params = description.getParameters();
        if (description.getUsage() != null) {
            usage = description.getUsage().split(" ", params.size());
        } else {
            usage = new String[params.size()];
            for (i = 0; i < usage.length; ++i) {
                String arg;
                boolean optional;
                Parameter param = params.get(i);
                boolean bl = optional = param.isValueFlag() || param.isOptional();
                if (param.getFlag() != null) {
                    arg = "-" + param.getFlag();
                    if (param.isValueFlag()) {
                        arg = arg + param.getName();
                    }
                } else {
                    arg = param.getName();
                    if (param.getDefaultValue() != null && param.getDefaultValue().length > 0) {
                        arg = arg + "=" + StringMan.join(param.getDefaultValue(), ",");
                    }
                }
                usage[i] = optional ? "[" + arg + "]" : "<" + arg + ">";
            }
        }
        this.prefix();
        this.text("&cUsage: ");
        this.text("&7" + commandString);
        this.suggestTip(commandString + " ");
        for (i = 0; i < usage.length; ++i) {
            String argStr = usage[i];
            this.text(this.separateArg(argStr.replaceAll("[\\[|\\]|<|>]", "&0$0&7")));
            if (params.isEmpty()) continue;
            Parameter param = params.get(i);
            StringBuilder tooltip = new StringBuilder();
            String command = null;
            String webpage = null;
            tooltip.append("Name: " + param.getName());
            if (param instanceof ParameterData) {
                Link link;
                Range range;
                ParameterData pd = (ParameterData)param;
                Type type = pd.getType();
                if (type instanceof Class) {
                    tooltip.append("\nType: " + ((Class)type).getSimpleName());
                }
                if ((range = MainUtil.getOf(pd.getModifiers(), Range.class)) != null) {
                    String min = range.min() == Double.MIN_VALUE ? "(-\u221e" : "[" + range.min();
                    String max = range.max() == Double.MAX_VALUE ? "\u221e)" : range.max() + "]";
                    tooltip.append("\nRange: " + min + "," + max);
                }
                if (type instanceof Class && (link = ((Class)type).getAnnotation(Link.class)) != null) {
                    if (link.value().startsWith("http")) {
                        webpage = link.value();
                    } else {
                        command = Commands.getAlias(link.clazz(), link.value());
                    }
                }
            }
            tooltip.append("\nOptional: " + (param.isOptional() || param.isValueFlag()));
            if (param.getDefaultValue() != null && param.getDefaultValue().length >= 0) {
                tooltip.append("\nDefault: " + param.getDefaultValue()[0]);
            } else if (argStr.contains("=")) {
                tooltip.append("\nDefault: " + argStr.split("[=|\\]|>]")[1]);
            }
            if (command != null || webpage != null) {
                tooltip.append("\nClick for more info");
            }
            this.tooltip(tooltip.toString());
            if (command != null) {
                this.command(command);
            }
            if (webpage == null) continue;
            this.link(webpage);
        }
        this.newline();
        if (description.getHelp() != null) {
            this.text("&cHelp: &7" + description.getHelp());
        } else if (description.getDescription() != null) {
            this.text("&cDescription: &7" + description.getDescription());
        } else {
            this.text("No further help is available.");
        }
    }
}

