/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit;

import com.boydti.fawe.util.MathMan;
import com.sk89q.worldedit.BlockVector2D;
import com.sk89q.worldedit.MutableBlockVector2D;
import com.sk89q.worldedit.Vector;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class Vector2D
implements Serializable {
    public static final Vector2D ZERO = new Vector2D(0, 0);
    public static final Vector2D UNIT_X = new Vector2D(1, 0);
    public static final Vector2D UNIT_Z = new Vector2D(0, 1);
    public static final Vector2D ONE = new Vector2D(1, 1);
    public transient double x;
    public transient double z;

    public Vector2D(double x, double z) {
        this.x = x;
        this.z = z;
    }

    public Vector2D(int x, int z) {
        this.x = x;
        this.z = z;
    }

    public Vector2D(float x, float z) {
        this.x = x;
        this.z = z;
    }

    public Vector2D(Vector2D other) {
        this.x = other.getX();
        this.z = other.getZ();
    }

    public Vector2D() {
        this.x = 0.0;
        this.z = 0.0;
    }

    public double getX() {
        return this.x;
    }

    public int getBlockX() {
        return MathMan.roundInt(this.getX());
    }

    public Vector2D setX(double x) {
        return new Vector2D(x, this.getZ());
    }

    public Vector2D setX(int x) {
        return new Vector2D((double)x, this.getZ());
    }

    public double getZ() {
        return this.z;
    }

    public int getBlockZ() {
        return MathMan.roundInt(this.getZ());
    }

    public Vector2D setZ(double z) {
        return new Vector2D(this.getX(), z);
    }

    public Vector2D setZ(int z) {
        return new Vector2D(this.getX(), (double)z);
    }

    public Vector2D add(Vector2D other) {
        return new Vector2D(this.getX() + other.getX(), this.getZ() + other.getZ());
    }

    public Vector2D add(double x, double z) {
        return new Vector2D(this.getX() + x, this.getZ() + z);
    }

    public Vector2D add(int x, int z) {
        return new Vector2D(this.getX() + (double)x, this.getZ() + (double)z);
    }

    public Vector2D add(Vector2D ... others) {
        double newX = this.getX();
        double newZ = this.getZ();
        for (Vector2D other : others) {
            newX += other.getX();
            newZ += other.getZ();
        }
        return new Vector2D(newX, newZ);
    }

    public Vector2D subtract(Vector2D other) {
        return new Vector2D(this.getX() - other.getX(), this.getZ() - other.getZ());
    }

    public Vector2D subtract(double x, double z) {
        return new Vector2D(this.getX() - x, this.getZ() - z);
    }

    public Vector2D subtract(int x, int z) {
        return new Vector2D(this.getX() - (double)x, this.getZ() - (double)z);
    }

    public Vector2D subtract(Vector2D ... others) {
        double newX = this.getX();
        double newZ = this.getZ();
        for (Vector2D other : others) {
            newX -= other.getX();
            newZ -= other.getZ();
        }
        return new Vector2D(newX, newZ);
    }

    public Vector2D multiply(Vector2D other) {
        return new Vector2D(this.getX() * other.getX(), this.getZ() * other.getZ());
    }

    public Vector2D multiply(double x, double z) {
        return new Vector2D(this.getX() * x, this.getZ() * z);
    }

    public Vector2D multiply(int x, int z) {
        return new Vector2D(this.getX() * (double)x, this.getZ() * (double)z);
    }

    public Vector2D multiply(Vector2D ... others) {
        double newX = this.getX();
        double newZ = this.getZ();
        for (Vector2D other : others) {
            newX *= other.getX();
            newZ *= other.getZ();
        }
        return new Vector2D(newX, newZ);
    }

    public Vector2D multiply(double n) {
        return new Vector2D(this.getX() * n, this.getZ() * n);
    }

    public Vector2D multiply(float n) {
        return new Vector2D(this.getX() * (double)n, this.getZ() * (double)n);
    }

    public Vector2D multiply(int n) {
        return new Vector2D(this.getX() * (double)n, this.getZ() * (double)n);
    }

    public Vector2D divide(Vector2D other) {
        return new Vector2D(this.getX() / other.getX(), this.getZ() / other.getZ());
    }

    public Vector2D divide(double x, double z) {
        return new Vector2D(this.getX() / x, this.getZ() / z);
    }

    public Vector2D divide(int x, int z) {
        return new Vector2D(this.getX() / (double)x, this.getZ() / (double)z);
    }

    public Vector2D divide(int n) {
        return new Vector2D(this.getX() / (double)n, this.getZ() / (double)n);
    }

    public Vector2D divide(double n) {
        return new Vector2D(this.getX() / n, this.getZ() / n);
    }

    public Vector2D divide(float n) {
        return new Vector2D(this.getX() / (double)n, this.getZ() / (double)n);
    }

    public double length() {
        return Math.sqrt(this.getX() * this.getX() + this.getZ() * this.getZ());
    }

    public double lengthSq() {
        return this.getX() * this.getX() + this.getZ() * this.getZ();
    }

    public double distance(Vector2D other) {
        return Math.sqrt(Math.pow(other.getX() - this.getX(), 2.0) + Math.pow(other.getZ() - this.getZ(), 2.0));
    }

    public double distanceSq(Vector2D other) {
        return Math.pow(other.getX() - this.getX(), 2.0) + Math.pow(other.getZ() - this.getZ(), 2.0);
    }

    public Vector2D normalize() {
        return this.divide(this.length());
    }

    public double dot(Vector2D other) {
        return this.getX() * other.getX() + this.getZ() * other.getZ();
    }

    public boolean containedWithin(Vector2D min, Vector2D max) {
        return this.getX() >= min.getX() && this.getX() <= max.getX() && this.getZ() >= min.getZ() && this.getZ() <= max.getZ();
    }

    public boolean containedWithinBlock(Vector2D min, Vector2D max) {
        return this.getBlockX() >= min.getBlockX() && this.getBlockX() <= max.getBlockX() && this.getBlockZ() >= min.getBlockZ() && this.getBlockZ() <= max.getBlockZ();
    }

    public Vector2D floor() {
        return new Vector2D(Math.floor(this.getX()), Math.floor(this.getZ()));
    }

    public Vector2D ceil() {
        return new Vector2D(Math.ceil(this.getX()), Math.ceil(this.getZ()));
    }

    public Vector2D round() {
        return new Vector2D(Math.floor(this.getX() + 0.5), Math.floor(this.getZ() + 0.5));
    }

    public Vector2D positive() {
        return new Vector2D(Math.abs(this.getX()), Math.abs(this.getZ()));
    }

    public Vector2D transform2D(double angle, double aboutX, double aboutZ, double translateX, double translateZ) {
        angle = Math.toRadians(angle);
        double x = this.getX() - aboutX;
        double z = this.getZ() - aboutZ;
        double x2 = x * Math.cos(angle) - z * Math.sin(angle);
        double z2 = x * Math.sin(angle) + z * Math.cos(angle);
        return new Vector2D(x2 + aboutX + translateX, z2 + aboutZ + translateZ);
    }

    public boolean isCollinearWith(Vector2D other) {
        if (this.getX() == 0.0 && this.getZ() == 0.0) {
            return true;
        }
        double otherX = other.getX();
        double otherZ = other.getZ();
        if (otherX == 0.0 && otherZ == 0.0) {
            return true;
        }
        if (this.getX() == 0.0 != (otherX == 0.0)) {
            return false;
        }
        if (this.getZ() == 0.0 != (otherZ == 0.0)) {
            return false;
        }
        double quotientX = otherX / this.getX();
        if (!Double.isNaN(quotientX)) {
            return other.equals(this.multiply(quotientX));
        }
        double quotientZ = otherZ / this.getZ();
        if (!Double.isNaN(quotientZ)) {
            return other.equals(this.multiply(quotientZ));
        }
        throw new RuntimeException("This should not happen");
    }

    public BlockVector2D toBlockVector2D() {
        return new BlockVector2D(this);
    }

    public Vector toVector() {
        return new Vector(this.getX(), 0.0, this.getZ());
    }

    public Vector toVector(double y) {
        return new Vector(this.getX(), y, this.getZ());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Vector2D)) {
            return false;
        }
        Vector2D other = (Vector2D)obj;
        return other.getX() == this.getX() && other.getZ() == this.getZ();
    }

    public int hashCode() {
        return new Double(this.getX()).hashCode() >> 13 ^ new Double(this.getZ()).hashCode();
    }

    public String toString() {
        return "(" + this.getX() + ", " + this.getZ() + ")";
    }

    public static Vector2D getMinimum(Vector2D v1, Vector2D v2) {
        return new Vector2D(Math.min(v1.getX(), v2.getX()), Math.min(v1.getZ(), v2.getZ()));
    }

    public static Vector2D getMaximum(Vector2D v1, Vector2D v2) {
        return new Vector2D(Math.max(v1.getX(), v2.getX()), Math.max(v1.getZ(), v2.getZ()));
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        if (this instanceof MutableBlockVector2D) {
            return;
        }
        stream.writeDouble(this.x);
        stream.writeDouble(this.z);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        if (this instanceof MutableBlockVector2D) {
            return;
        }
        this.x = stream.readDouble();
        this.z = stream.readDouble();
    }
}

