/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.blocks;

import com.google.common.base.Preconditions;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockType;

public class LazyBlock
extends BaseBlock {
    private final Extent extent;
    private final Vector position;
    private boolean loaded = false;

    public LazyBlock(BlockType type, Extent extent, Vector position) {
        super(type);
        Preconditions.checkNotNull((Object)extent);
        Preconditions.checkNotNull((Object)position);
        this.extent = extent;
        this.position = position;
    }

    public LazyBlock(BlockState state, Extent extent, Vector position) {
        super(state);
        Preconditions.checkNotNull((Object)extent);
        Preconditions.checkNotNull((Object)position);
        this.extent = extent;
        this.position = position;
    }

    @Override
    public CompoundTag getNbtData() {
        if (!this.loaded) {
            BlockState loadedBlock = this.extent.getFullBlock(this.position);
            this.nbtData = loadedBlock.getNbtData();
            this.loaded = true;
        }
        return super.getNbtData();
    }

    @Override
    public void setNbtData(CompoundTag nbtData) {
        throw new UnsupportedOperationException("This object is immutable");
    }
}

