/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extension.factory;

import com.boydti.fawe.util.MathMan;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.blocks.BaseItem;
import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.extension.input.ParserContext;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.internal.registry.InputParser;
import com.sk89q.worldedit.world.item.ItemTypes;
import com.sk89q.worldedit.world.registry.LegacyMapper;

public class DefaultItemParser
extends InputParser<BaseItem> {
    protected DefaultItemParser(WorldEdit worldEdit) {
        super(worldEdit);
    }

    @Override
    public BaseItem parseFromInput(String input, ParserContext context) throws InputParseException {
        BaseItem item = null;
        if (context.isTryingLegacy()) {
            try {
                ItemTypes type;
                String[] split = input.split(":");
                if (split.length == 1) {
                    type = LegacyMapper.getInstance().getItemFromLegacy(Integer.parseInt(split[0]));
                } else if (MathMan.isInteger(split[0])) {
                    type = LegacyMapper.getInstance().getItemFromLegacy(Integer.parseInt(split[0]), Integer.parseInt(split[1]));
                } else {
                    ItemTypes newType;
                    Integer legacy;
                    type = ItemTypes.parse(input);
                    if (type != null && (legacy = LegacyMapper.getInstance().getLegacyCombined(type)) != null && (newType = LegacyMapper.getInstance().getItemFromLegacy(legacy >> 4, Integer.parseInt(split[1]))) != null) {
                        type = newType;
                    }
                }
                item = new BaseItem(type);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (item == null) {
            item = WorldEdit.getInstance().getPlatformManager().queryCapability(Capability.GAME_HOOKS).getRegistries().getItemRegistry().createFromId(input.toLowerCase());
        }
        if (item == null) {
            throw new InputParseException("'" + input + "' did not match any item");
        }
        return item;
    }
}

