/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extension.platform;

import com.boydti.fawe.config.BBC;
import com.boydti.fawe.object.FawePlayer;
import com.boydti.fawe.object.brush.visualization.VirtualWorld;
import com.boydti.fawe.object.exception.FaweException;
import com.boydti.fawe.object.pattern.PatternTraverser;
import com.boydti.fawe.util.MainUtil;
import com.boydti.fawe.wrappers.LocationMaskedPlayerWrapper;
import com.boydti.fawe.wrappers.PlayerWrapper;
import com.boydti.fawe.wrappers.WorldWrapper;
import com.google.common.base.Preconditions;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.command.tool.BlockTool;
import com.sk89q.worldedit.command.tool.BrushTool;
import com.sk89q.worldedit.command.tool.DoubleActionBlockTool;
import com.sk89q.worldedit.command.tool.DoubleActionTraceTool;
import com.sk89q.worldedit.command.tool.Tool;
import com.sk89q.worldedit.command.tool.TraceTool;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.event.platform.BlockInteractEvent;
import com.sk89q.worldedit.event.platform.ConfigurationLoadEvent;
import com.sk89q.worldedit.event.platform.Interaction;
import com.sk89q.worldedit.event.platform.PlatformInitializeEvent;
import com.sk89q.worldedit.event.platform.PlatformReadyEvent;
import com.sk89q.worldedit.event.platform.PlayerInputEvent;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.extension.platform.CommandManager;
import com.sk89q.worldedit.extension.platform.NoCapablePlatformException;
import com.sk89q.worldedit.extension.platform.Platform;
import com.sk89q.worldedit.extension.platform.Preference;
import com.sk89q.worldedit.extension.platform.permission.ActorSelectorLimits;
import com.sk89q.worldedit.regions.RegionSelector;
import com.sk89q.worldedit.session.request.Request;
import com.sk89q.worldedit.util.HandSide;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.util.eventbus.Subscribe;
import com.sk89q.worldedit.world.World;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class PlatformManager {
    private static final Logger logger = Logger.getLogger(PlatformManager.class.getCanonicalName());
    private final WorldEdit worldEdit;
    private final CommandManager commandManager;
    private final List<Platform> platforms = new ArrayList<Platform>();
    private final Map<Capability, Platform> preferences = new EnumMap<Capability, Platform>(Capability.class);
    @Nullable
    private String firstSeenVersion;
    private final AtomicBoolean initialized = new AtomicBoolean();
    private final AtomicBoolean configured = new AtomicBoolean();

    public PlatformManager(WorldEdit worldEdit) {
        Preconditions.checkNotNull((Object)worldEdit);
        this.worldEdit = worldEdit;
        this.commandManager = new CommandManager(worldEdit, this);
        worldEdit.getEventBus().register(this);
    }

    public synchronized void register(Platform platform) {
        Preconditions.checkNotNull((Object)platform);
        logger.log(Level.FINE, "Got request to register " + platform.getClass() + " with WorldEdit [" + super.toString() + "]");
        this.platforms.add(platform);
        if (this.firstSeenVersion != null) {
            if (!this.firstSeenVersion.equals(platform.getVersion())) {
                logger.log(Level.WARNING, "Multiple ports of WorldEdit are installed but they report different versions ({0} and {1}). If these two versions are truly different, then you may run into unexpected crashes and errors.", new Object[]{this.firstSeenVersion, platform.getVersion()});
            }
        } else {
            this.firstSeenVersion = platform.getVersion();
        }
    }

    public synchronized boolean unregister(Platform platform) {
        Preconditions.checkNotNull((Object)platform);
        boolean removed = this.platforms.remove(platform);
        if (removed) {
            logger.log(Level.FINE, "Unregistering " + platform.getClass().getCanonicalName() + " from WorldEdit");
            boolean choosePreferred = false;
            Iterator<Map.Entry<Capability, Platform>> it = this.preferences.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Capability, Platform> entry = it.next();
                if (!entry.getValue().equals(platform)) continue;
                entry.getKey().unload(this, entry.getValue());
                it.remove();
                choosePreferred = true;
            }
            if (choosePreferred) {
                this.choosePreferred();
            }
        }
        return removed;
    }

    public synchronized Platform queryCapability(Capability capability) throws NoCapablePlatformException {
        Platform platform = this.preferences.get(Preconditions.checkNotNull((Object)((Object)capability)));
        if (platform != null) {
            return platform;
        }
        if (this.preferences.isEmpty() && !this.platforms.isEmpty()) {
            return this.platforms.get(0);
        }
        throw new NoCapablePlatformException("No platform was found supporting " + capability.name());
    }

    private synchronized void choosePreferred() {
        for (Capability capability : Capability.values()) {
            Platform preferred = this.findMostPreferred(capability);
            if (preferred == null) continue;
            this.preferences.put(capability, preferred);
            capability.initialize(this, preferred);
        }
        if (this.preferences.containsKey((Object)Capability.CONFIGURATION) && this.configured.compareAndSet(false, true)) {
            this.worldEdit.getEventBus().post(new ConfigurationLoadEvent(this.queryCapability(Capability.CONFIGURATION).getConfiguration()));
        }
    }

    @Nullable
    private synchronized Platform findMostPreferred(Capability capability) {
        Platform preferred = null;
        Preference highest = null;
        for (Platform platform : this.platforms) {
            Preference preference = platform.getCapabilities().get((Object)capability);
            if (preference == null || highest != null && !preference.isPreferredOver(highest)) continue;
            preferred = platform;
            highest = preference;
        }
        return preferred;
    }

    public synchronized List<Platform> getPlatforms() {
        return new ArrayList<Platform>(this.platforms);
    }

    public World getWorldForEditing(World base) {
        Preconditions.checkNotNull((Object)base);
        base = WorldWrapper.unwrap(base);
        World match = this.queryCapability(Capability.WORLD_EDITING).matchWorld(base);
        return match != null ? match : base;
    }

    public <T extends Actor> T createProxyActor(T base) {
        Preconditions.checkNotNull(base);
        if (base instanceof Player) {
            Player player = (Player)base;
            FawePlayer fp = FawePlayer.wrap(player);
            return (T)fp.createProxy();
        }
        return base;
    }

    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    public LocalConfiguration getConfiguration() {
        return this.queryCapability(Capability.CONFIGURATION).getConfiguration();
    }

    @Subscribe
    public void handlePlatformReady(PlatformReadyEvent event) {
        this.choosePreferred();
        if (this.initialized.compareAndSet(false, true)) {
            this.worldEdit.getEventBus().post(new PlatformInitializeEvent());
        }
    }

    private <T extends Tool> T reset(T tool) {
        new PatternTraverser(tool).reset(null);
        return tool;
    }

    @Subscribe
    public void handleBlockInteract(BlockInteractEvent event) {
        Request.reset();
        final Actor actor = this.createProxyActor(event.getCause());
        try {
            final Location location = event.getLocation();
            final Vector vector = location.toVector();
            if (actor instanceof Player) {
                final LocalSession session = this.worldEdit.getSessionManager().get(actor);
                Player playerActor = (Player)actor;
                VirtualWorld virtual = session.getVirtualWorld();
                if (virtual != null) {
                    virtual.handleBlockInteract(playerActor, vector, event);
                    if (event.isCancelled()) {
                        return;
                    }
                }
                if (event.getType() == Interaction.HIT) {
                    BlockTool superPickaxe;
                    if (session.isToolControlEnabled() && playerActor.getItemInHand(HandSide.MAIN_HAND).getType().equals(this.getConfiguration().wandItem)) {
                        FawePlayer fp = FawePlayer.wrap(playerActor);
                        if (!actor.hasPermission("worldedit.selection.pos")) {
                            return;
                        }
                        final RegionSelector selector = session.getRegionSelector(playerActor.getWorld());
                        final LocationMaskedPlayerWrapper player = new LocationMaskedPlayerWrapper(PlayerWrapper.wrap((Player)actor), ((Player)actor).getLocation());
                        fp.runAction(new Runnable(){

                            @Override
                            public void run() {
                                if (selector.selectPrimary(location.toVector(), ActorSelectorLimits.forActor(player))) {
                                    selector.explainPrimarySelection(actor, session, vector);
                                }
                            }
                        }, false, true);
                        event.setCancelled(true);
                        return;
                    }
                    if (session.hasSuperPickAxe() && playerActor.isHoldingPickAxe() && (superPickaxe = session.getSuperPickaxe()) != null && superPickaxe.canUse(playerActor)) {
                        FawePlayer fp = FawePlayer.wrap(playerActor);
                        final LocationMaskedPlayerWrapper player = new LocationMaskedPlayerWrapper(PlayerWrapper.wrap((Player)actor), ((Player)actor).getLocation());
                        fp.runAction(new Runnable(){

                            @Override
                            public void run() {
                                ((BlockTool)PlatformManager.this.reset(superPickaxe)).actPrimary(PlatformManager.this.queryCapability(Capability.WORLD_EDITING), PlatformManager.this.getConfiguration(), player, session, location);
                            }
                        }, false, true);
                        event.setCancelled(true);
                        return;
                    }
                    final Tool tool = session.getTool(playerActor);
                    if (tool != null && tool instanceof DoubleActionBlockTool && tool.canUse(playerActor)) {
                        FawePlayer fp = FawePlayer.wrap(playerActor);
                        final LocationMaskedPlayerWrapper player = new LocationMaskedPlayerWrapper(PlayerWrapper.wrap((Player)actor), ((Player)actor).getLocation());
                        fp.runAction(new Runnable(){

                            @Override
                            public void run() {
                                ((DoubleActionBlockTool)PlatformManager.this.reset((DoubleActionBlockTool)tool)).actSecondary(PlatformManager.this.queryCapability(Capability.WORLD_EDITING), PlatformManager.this.getConfiguration(), player, session, location);
                            }
                        }, false, true);
                        event.setCancelled(true);
                        return;
                    }
                } else if (event.getType() == Interaction.OPEN) {
                    FawePlayer fp;
                    if (session.isToolControlEnabled() && playerActor.getItemInHand(HandSide.MAIN_HAND).getType().equals(this.getConfiguration().wandItem)) {
                        FawePlayer fp2 = FawePlayer.wrap(playerActor);
                        if (!actor.hasPermission("worldedit.selection.pos")) {
                            return;
                        }
                        if (fp2.checkAction()) {
                            final RegionSelector selector = session.getRegionSelector(playerActor.getWorld());
                            final LocationMaskedPlayerWrapper player = new LocationMaskedPlayerWrapper(PlayerWrapper.wrap((Player)actor), ((Player)actor).getLocation());
                            fp2.runAction(new Runnable(){

                                @Override
                                public void run() {
                                    if (selector.selectSecondary(vector, ActorSelectorLimits.forActor(player))) {
                                        selector.explainSecondarySelection(actor, session, vector);
                                    }
                                }
                            }, false, true);
                        }
                        event.setCancelled(true);
                        return;
                    }
                    final Tool tool = session.getTool(playerActor);
                    if (tool != null && tool instanceof BlockTool && tool.canUse(playerActor) && (fp = FawePlayer.wrap(playerActor)).checkAction()) {
                        final LocationMaskedPlayerWrapper player = new LocationMaskedPlayerWrapper(PlayerWrapper.wrap((Player)actor), ((Player)actor).getLocation());
                        fp.runAction(new Runnable(){

                            @Override
                            public void run() {
                                if (tool instanceof BrushTool) {
                                    ((BlockTool)tool).actPrimary(PlatformManager.this.queryCapability(Capability.WORLD_EDITING), PlatformManager.this.getConfiguration(), player, session, location);
                                } else {
                                    ((BlockTool)PlatformManager.this.reset((BlockTool)tool)).actPrimary(PlatformManager.this.queryCapability(Capability.WORLD_EDITING), PlatformManager.this.getConfiguration(), player, session, location);
                                }
                            }
                        }, false, true);
                        event.setCancelled(true);
                        return;
                    }
                }
            }
        }
        catch (Throwable e) {
            this.handleThrowable(e, actor);
        }
    }

    public void handleThrowable(Throwable e, Actor actor) {
        FaweException faweException = FaweException.get(e);
        if (faweException != null) {
            BBC.WORLDEDIT_CANCEL_REASON.send(actor, faweException.getMessage());
        } else {
            actor.printError("Please report this error: [See console]");
            actor.printRaw(e.getClass().getName() + ": " + e.getMessage());
            MainUtil.handleError(e);
        }
    }

    @Subscribe
    public void handlePlayerInput(PlayerInputEvent event) {
        Player actor = this.createProxyActor(event.getPlayer());
        final LocationMaskedPlayerWrapper player = new LocationMaskedPlayerWrapper(PlayerWrapper.wrap(actor), actor.getLocation(), true);
        final LocalSession session = this.worldEdit.getSessionManager().get(player);
        VirtualWorld virtual = session.getVirtualWorld();
        if (virtual != null) {
            virtual.handlePlayerInput(player, event);
            if (event.isCancelled()) {
                return;
            }
        }
        try {
            switch (event.getInputType()) {
                case PRIMARY: {
                    if (player.getItemInHand(HandSide.MAIN_HAND).getType().equals(this.getConfiguration().navigationWand)) {
                        if (this.getConfiguration().navigationWandMaxDistance <= 0) {
                            return;
                        }
                        if (!player.hasPermission("worldedit.navigation.jumpto.tool")) {
                            return;
                        }
                        Location pos = player.getSolidBlockTrace(this.getConfiguration().navigationWandMaxDistance);
                        if (pos != null) {
                            player.findFreePosition(pos);
                        } else {
                            BBC.NO_BLOCK.send(player, new Object[0]);
                        }
                        event.setCancelled(true);
                        return;
                    }
                    final Tool tool = session.getTool(player);
                    if (tool == null || !(tool instanceof DoubleActionTraceTool) || !tool.canUse(player)) break;
                    FawePlayer fp = FawePlayer.wrap(player);
                    fp.runAsyncIfFree(new Runnable(){

                        @Override
                        public void run() {
                            ((DoubleActionTraceTool)PlatformManager.this.reset((DoubleActionTraceTool)tool)).actSecondary(PlatformManager.this.queryCapability(Capability.WORLD_EDITING), PlatformManager.this.getConfiguration(), player, session);
                        }
                    });
                    event.setCancelled(true);
                    return;
                }
                case SECONDARY: {
                    if (player.getItemInHand(HandSide.MAIN_HAND).getType().equals(this.getConfiguration().navigationWand)) {
                        if (this.getConfiguration().navigationWandMaxDistance <= 0) {
                            return;
                        }
                        if (!player.hasPermission("worldedit.navigation.thru.tool")) {
                            return;
                        }
                        if (!player.passThroughForwardWall(40)) {
                            BBC.NAVIGATION_WAND_ERROR.send(player, new Object[0]);
                        }
                        event.setCancelled(true);
                        return;
                    }
                    final Tool tool = session.getTool(player);
                    if (tool == null || !(tool instanceof TraceTool) || !tool.canUse(player)) break;
                    FawePlayer fp = FawePlayer.wrap(player);
                    fp.runAction(new Runnable(){

                        @Override
                        public void run() {
                            ((TraceTool)PlatformManager.this.reset((TraceTool)tool)).actPrimary(PlatformManager.this.queryCapability(Capability.WORLD_EDITING), PlatformManager.this.getConfiguration(), player, session);
                        }
                    }, false, true);
                    event.setCancelled(true);
                    return;
                }
            }
        }
        catch (Throwable e) {
            FaweException faweException = FaweException.get(e);
            if (faweException != null) {
                BBC.WORLDEDIT_CANCEL_REASON.send(player, faweException.getMessage());
            }
            player.printError("Please report this error: [See console]");
            player.printRaw(e.getClass().getName() + ": " + e.getMessage());
            MainUtil.handleError(e);
        }
    }
}

