/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extent;

import com.boydti.fawe.jnbt.anvil.generator.GenBase;
import com.boydti.fawe.jnbt.anvil.generator.Resource;
import com.boydti.fawe.object.extent.LightingExtent;
import com.google.common.base.Preconditions;
import com.sk89q.worldedit.MutableBlockVector;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.Vector2D;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.OperationQueue;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.biome.BaseBiome;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import java.util.List;
import javax.annotation.Nullable;

public class AbstractDelegateExtent
implements LightingExtent {
    private final transient Extent extent;
    private MutableBlockVector mutable = new MutableBlockVector(0, 0, 0);

    public AbstractDelegateExtent(Extent extent) {
        Preconditions.checkNotNull((Object)extent);
        this.extent = extent;
    }

    @Override
    public int getSkyLight(int x, int y, int z) {
        if (this.extent instanceof LightingExtent) {
            return ((LightingExtent)this.extent).getSkyLight(x, y, z);
        }
        return 0;
    }

    @Override
    public int getMaxY() {
        return this.extent.getMaxY();
    }

    @Override
    public BlockType getBlockType(Vector position) {
        return this.extent.getBlockType(position);
    }

    @Override
    public BlockState getFullBlock(Vector position) {
        return this.extent.getFullBlock(position);
    }

    @Override
    public int getBlockLight(int x, int y, int z) {
        if (this.extent instanceof LightingExtent) {
            return ((LightingExtent)this.extent).getBlockLight(x, y, z);
        }
        return this.getBrightness(x, y, z);
    }

    @Override
    public int getOpacity(int x, int y, int z) {
        if (this.extent instanceof LightingExtent) {
            return ((LightingExtent)this.extent).getOpacity(x, y, z);
        }
        return this.getLazyBlock(x, y, z).getBlockType().getMaterial().getLightOpacity();
    }

    @Override
    public int getLight(int x, int y, int z) {
        if (this.extent instanceof LightingExtent) {
            return ((LightingExtent)this.extent).getLight(x, y, z);
        }
        return 0;
    }

    @Override
    public int getBrightness(int x, int y, int z) {
        if (this.extent instanceof LightingExtent) {
            return ((LightingExtent)this.extent).getBrightness(x, y, z);
        }
        return this.getLazyBlock(x, y, z).getBlockType().getMaterial().getLightValue();
    }

    public Extent getExtent() {
        return this.extent;
    }

    @Override
    public BlockState getBlock(Vector position) {
        return this.extent.getLazyBlock(position);
    }

    @Override
    public BlockState getLazyBlock(int x, int y, int z) {
        this.mutable.mutX(x);
        this.mutable.mutY(y);
        this.mutable.mutZ(z);
        return this.extent.getLazyBlock(this.mutable);
    }

    @Override
    public BlockState getLazyBlock(Vector position) {
        return this.extent.getLazyBlock(position);
    }

    @Override
    public boolean setBlock(int x, int y, int z, BlockStateHolder block) throws WorldEditException {
        this.mutable.mutX(x);
        this.mutable.mutY(y);
        this.mutable.mutZ(z);
        return this.setBlock(this.mutable, block);
    }

    @Override
    public boolean setBlock(Vector location, BlockStateHolder block) throws WorldEditException {
        return this.extent.setBlock(location, block);
    }

    @Override
    @Nullable
    public Entity createEntity(Location location, BaseEntity entity) {
        return this.extent.createEntity(location, entity);
    }

    @Override
    public List<? extends Entity> getEntities() {
        return this.extent.getEntities();
    }

    @Override
    public List<? extends Entity> getEntities(Region region) {
        return this.extent.getEntities(region);
    }

    @Override
    public BaseBiome getBiome(Vector2D position) {
        return this.extent.getBiome(position);
    }

    @Override
    public boolean setBiome(Vector2D position, BaseBiome biome) {
        return this.extent.setBiome(position, biome);
    }

    @Override
    public boolean setBiome(int x, int y, int z, BaseBiome biome) {
        return this.extent.setBiome(x, y, z, biome);
    }

    @Override
    public int getHighestTerrainBlock(int x, int z, int minY, int maxY) {
        return this.extent.getHighestTerrainBlock(x, z, minY, maxY);
    }

    @Override
    public Vector getMinimumPoint() {
        return this.extent.getMinimumPoint();
    }

    @Override
    public Vector getMaximumPoint() {
        return this.extent.getMaximumPoint();
    }

    protected Operation commitBefore() {
        return null;
    }

    public String toString() {
        return super.toString() + ":" + this.extent.toString();
    }

    @Override
    public int getNearestSurfaceLayer(int x, int z, int y, int minY, int maxY) {
        return this.extent.getNearestSurfaceLayer(x, z, y, minY, maxY);
    }

    @Override
    public int getNearestSurfaceTerrainBlock(int x, int z, int y, int minY, int maxY, boolean ignoreAir) {
        return this.extent.getNearestSurfaceTerrainBlock(x, z, y, minY, maxY, ignoreAir);
    }

    @Override
    public int getNearestSurfaceTerrainBlock(int x, int z, int y, int minY, int maxY) {
        return this.extent.getNearestSurfaceTerrainBlock(x, z, y, minY, maxY);
    }

    @Override
    public int getNearestSurfaceTerrainBlock(int x, int z, int y, int minY, int maxY, int failedMin, int failedMax) {
        return this.extent.getNearestSurfaceTerrainBlock(x, z, y, minY, maxY, failedMin, failedMax);
    }

    @Override
    public int getNearestSurfaceTerrainBlock(int x, int z, int y, int minY, int maxY, int failedMin, int failedMax, boolean ignoreAir) {
        return this.extent.getNearestSurfaceTerrainBlock(x, z, y, minY, maxY, failedMin, failedMax, ignoreAir);
    }

    @Override
    public void addCaves(Region region) throws WorldEditException {
        this.extent.addCaves(region);
    }

    @Override
    public void generate(Region region, GenBase gen) throws WorldEditException {
        this.extent.generate(region, gen);
    }

    @Override
    public void spawnResource(Region region, Resource gen, int rarity, int frequency) throws WorldEditException {
        this.extent.spawnResource(region, gen, rarity, frequency);
    }

    @Override
    public boolean contains(Vector pt) {
        return this.extent.contains(pt);
    }

    @Override
    public void addOre(Region region, Mask mask, Pattern material, int size, int frequency, int rarity, int minY, int maxY) throws WorldEditException {
        this.extent.addOre(region, mask, material, size, frequency, rarity, minY, maxY);
    }

    @Override
    public void addOres(Region region, Mask mask) throws WorldEditException {
        this.extent.addOres(region, mask);
    }

    @Override
    @Nullable
    public Operation commit() {
        Operation ours = this.commitBefore();
        Operation other = null;
        if (this.extent != this) {
            other = this.extent.commit();
        }
        if (ours != null && other != null) {
            return new OperationQueue(ours, other);
        }
        if (ours != null) {
            return ours;
        }
        if (other != null) {
            return other;
        }
        return null;
    }
}

