/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extent.clipboard;

import com.boydti.fawe.config.Settings;
import com.boydti.fawe.object.clipboard.DiskOptimizedClipboard;
import com.boydti.fawe.object.clipboard.FaweClipboard;
import com.boydti.fawe.object.clipboard.MemoryOptimizedClipboard;
import com.boydti.fawe.object.extent.LightingExtent;
import com.google.common.base.Preconditions;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MutableBlockVector;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.Vector2D;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.biome.BaseBiome;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;

public class BlockArrayClipboard
implements Clipboard,
LightingExtent,
Closeable {
    private Region region;
    public FaweClipboard IMP;
    private Vector size;
    private int mx;
    private int my;
    private int mz;
    private Vector origin;
    private MutableBlockVector mutable = new MutableBlockVector();

    public BlockArrayClipboard(Region region) {
        Preconditions.checkNotNull((Object)region);
        this.region = region.clone();
        this.size = this.getDimensions();
        this.IMP = Settings.IMP.CLIPBOARD.USE_DISK ? new DiskOptimizedClipboard(this.size.getBlockX(), this.size.getBlockY(), this.size.getBlockZ()) : new MemoryOptimizedClipboard(this.size.getBlockX(), this.size.getBlockY(), this.size.getBlockZ());
        this.origin = region.getMinimumPoint();
        this.mx = this.origin.getBlockX();
        this.my = this.origin.getBlockY();
        this.mz = this.origin.getBlockZ();
    }

    public BlockArrayClipboard(Region region, UUID clipboardId) {
        Preconditions.checkNotNull((Object)region);
        this.region = region.clone();
        this.size = this.getDimensions();
        this.IMP = Settings.IMP.CLIPBOARD.USE_DISK ? new DiskOptimizedClipboard(this.size.getBlockX(), this.size.getBlockY(), this.size.getBlockZ(), clipboardId) : new MemoryOptimizedClipboard(this.size.getBlockX(), this.size.getBlockY(), this.size.getBlockZ());
        this.origin = region.getMinimumPoint();
        this.mx = this.origin.getBlockX();
        this.my = this.origin.getBlockY();
        this.mz = this.origin.getBlockZ();
    }

    public BlockArrayClipboard(Region region, FaweClipboard clipboard) {
        Preconditions.checkNotNull((Object)region);
        this.region = region.clone();
        this.size = this.getDimensions();
        this.origin = region.getMinimumPoint();
        this.mx = this.origin.getBlockX();
        this.my = this.origin.getBlockY();
        this.mz = this.origin.getBlockZ();
        this.IMP = clipboard;
    }

    public void init(Region region, FaweClipboard fc) {
        Preconditions.checkNotNull((Object)region);
        Preconditions.checkNotNull((Object)fc);
        this.region = region.clone();
        this.size = this.getDimensions();
        this.IMP = fc;
        this.origin = region.getMinimumPoint();
        this.mx = this.origin.getBlockX();
        this.my = this.origin.getBlockY();
        this.mz = this.origin.getBlockZ();
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    @Override
    public void close() {
        this.IMP.close();
    }

    @Override
    public Region getRegion() {
        return this.region.clone();
    }

    public void setRegion(Region region) {
        this.region = region;
    }

    @Override
    public Vector getOrigin() {
        return this.origin;
    }

    @Override
    public void setOrigin(Vector origin) {
        this.origin = origin;
        this.IMP.setOrigin(origin.subtract(this.region.getMinimumPoint()));
    }

    @Override
    public Vector getDimensions() {
        return this.region.getMaximumPoint().subtract(this.region.getMinimumPoint()).add(1, 1, 1);
    }

    @Override
    public Vector getMinimumPoint() {
        return this.region.getMinimumPoint();
    }

    @Override
    public Vector getMaximumPoint() {
        return this.region.getMaximumPoint();
    }

    @Override
    public List<? extends Entity> getEntities(Region region) {
        ArrayList<Entity> filtered = new ArrayList<Entity>();
        for (Entity entity : this.getEntities()) {
            if (!region.contains(entity.getLocation().toVector())) continue;
            filtered.add(entity);
        }
        return Collections.unmodifiableList(filtered);
    }

    @Override
    public List<? extends Entity> getEntities() {
        return this.IMP.getEntities();
    }

    @Override
    @Nullable
    public Entity createEntity(Location location, BaseEntity entity) {
        return this.IMP.createEntity(location.getExtent(), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch(), entity);
    }

    @Override
    public BlockState getBlock(Vector position) {
        if (this.region.contains(position)) {
            int x = position.getBlockX() - this.mx;
            int y = position.getBlockY() - this.my;
            int z = position.getBlockZ() - this.mz;
            return this.IMP.getBlock(x, y, z);
        }
        return EditSession.nullBlock;
    }

    public BlockState getBlockAbs(int x, int y, int z) {
        return this.IMP.getBlock(x, y, z);
    }

    @Override
    public BlockState getLazyBlock(Vector position) {
        return this.getBlock(position);
    }

    @Override
    public BlockState getFullBlock(Vector position) {
        return this.getLazyBlock(position);
    }

    @Override
    public boolean setBlock(Vector location, BlockStateHolder block) throws WorldEditException {
        if (this.region.contains(location)) {
            int x = location.getBlockX();
            int y = location.getBlockY();
            int z = location.getBlockZ();
            return this.setBlock(x, y, z, block);
        }
        return false;
    }

    public boolean setTile(int x, int y, int z, CompoundTag tag) {
        return this.IMP.setTile(x -= this.mx, y -= this.my, z -= this.mz, tag);
    }

    @Override
    public boolean setBlock(int x, int y, int z, BlockStateHolder block) throws WorldEditException {
        return this.IMP.setBlock(x -= this.mx, y -= this.my, z -= this.mz, block);
    }

    @Override
    public BaseBiome getBiome(Vector2D position) {
        int x = position.getBlockX() - this.mx;
        int z = position.getBlockZ() - this.mz;
        return this.IMP.getBiome(x, z);
    }

    @Override
    public boolean setBiome(Vector2D position, BaseBiome biome) {
        int x = position.getBlockX() - this.mx;
        int z = position.getBlockZ() - this.mz;
        this.IMP.setBiome(x, z, biome.getId());
        return true;
    }

    @Override
    @Nullable
    public Operation commit() {
        return null;
    }

    @Override
    public int getLight(int x, int y, int z) {
        return this.getBlockLight(x, y, z);
    }

    @Override
    public int getSkyLight(int x, int y, int z) {
        return 0;
    }

    @Override
    public int getBlockLight(int x, int y, int z) {
        return this.getBrightness(x, y, z);
    }

    @Override
    public int getOpacity(int x, int y, int z) {
        this.mutable.mutX(x);
        this.mutable.mutY(y);
        this.mutable.mutZ(z);
        return this.getBlock(this.mutable).getBlockType().getMaterial().getLightOpacity();
    }

    @Override
    public int getBrightness(int x, int y, int z) {
        this.mutable.mutX(x);
        this.mutable.mutY(y);
        this.mutable.mutZ(z);
        return this.getBlock(this.mutable).getBlockType().getMaterial().getLightValue();
    }
}

