/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extent.inventory;

import com.boydti.fawe.object.exception.FaweException;
import com.google.common.base.Preconditions;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.AbstractDelegateExtent;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.inventory.BlockBag;
import com.sk89q.worldedit.extent.inventory.BlockBagException;
import com.sk89q.worldedit.extent.inventory.UnplaceableBlockException;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BlockBagExtent
extends AbstractDelegateExtent {
    private final boolean mine;
    private int[] missingBlocks = new int[BlockTypes.size()];
    private BlockBag blockBag;

    public BlockBagExtent(Extent extent, @Nonnull BlockBag blockBag) {
        this(extent, blockBag, false);
    }

    public BlockBagExtent(Extent extent, @Nonnull BlockBag blockBag, boolean mine) {
        super(extent);
        Preconditions.checkNotNull((Object)blockBag);
        this.blockBag = blockBag;
        this.mine = mine;
    }

    @Nullable
    public BlockBag getBlockBag() {
        return this.blockBag;
    }

    public void setBlockBag(@Nullable BlockBag blockBag) {
        this.blockBag = blockBag;
    }

    public Map<BlockType, Integer> popMissing() {
        HashMap<BlockType, Integer> map = new HashMap<BlockType, Integer>();
        for (int i = 0; i < this.missingBlocks.length; ++i) {
            int count = this.missingBlocks[i];
            if (count <= 0) continue;
            map.put(BlockTypes.get(i), count);
        }
        Arrays.fill(this.missingBlocks, 0);
        return map;
    }

    @Override
    public boolean setBlock(Vector pos, BlockStateHolder block) throws WorldEditException {
        return this.setBlock(pos.getBlockX(), pos.getBlockY(), pos.getBlockZ(), block);
    }

    @Override
    public boolean setBlock(int x, int y, int z, BlockStateHolder block) throws WorldEditException {
        BlockState lazyBlock;
        BlockTypes fromType;
        BlockTypes type = block.getBlockType();
        if (!type.getMaterial().isAir()) {
            try {
                this.blockBag.fetchPlacedBlock(block.toImmutableState());
            }
            catch (UnplaceableBlockException e) {
                throw new FaweException.FaweBlockBagException();
            }
            catch (BlockBagException e) {
                int n = type.getInternalId();
                this.missingBlocks[n] = this.missingBlocks[n] + 1;
                throw new FaweException.FaweBlockBagException();
            }
        }
        if (this.mine && !(fromType = (lazyBlock = this.getExtent().getLazyBlock(x, y, z)).getBlockType()).getMaterial().isAir()) {
            try {
                this.blockBag.storeDroppedBlock(fromType.getDefaultState());
            }
            catch (BlockBagException blockBagException) {
                // empty catch block
            }
        }
        return this.getExtent().setBlock(x, y, z, block);
    }
}

