/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.function.entity;

import com.boydti.fawe.util.ReflectionUtils;
import com.google.common.base.Preconditions;
import com.sk89q.jnbt.ByteTag;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.FloatTag;
import com.sk89q.jnbt.IntTag;
import com.sk89q.jnbt.ListTag;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.EntityFunction;
import com.sk89q.worldedit.internal.helper.MCDirections;
import com.sk89q.worldedit.math.transform.Transform;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.util.Location;
import java.util.Arrays;
import java.util.Map;

public class ExtentEntityCopy
implements EntityFunction {
    private final Extent destination;
    private final Vector from;
    private final Vector to;
    private final Transform transform;
    private boolean removing;

    public ExtentEntityCopy(Vector from, Extent destination, Vector to, Transform transform) {
        Preconditions.checkNotNull((Object)from);
        Preconditions.checkNotNull((Object)destination);
        Preconditions.checkNotNull((Object)to);
        Preconditions.checkNotNull((Object)transform);
        this.destination = destination;
        this.from = from;
        this.to = to;
        this.transform = transform;
    }

    public boolean isRemoving() {
        return this.removing;
    }

    public void setRemoving(boolean removing) {
        this.removing = removing;
    }

    @Override
    public boolean apply(Entity entity) throws WorldEditException {
        BaseEntity state = entity.getState();
        if (state != null) {
            boolean success;
            Location newLocation;
            Location location = entity.getLocation();
            Vector pivot = this.from.round().add(0.5, 0.5, 0.5);
            Vector newPosition = this.transform.apply(location.toVector().subtract(pivot));
            if (this.transform.isIdentity()) {
                Vector newDirection = entity.getLocation().getDirection();
                newLocation = new Location(this.destination, newPosition.add(this.to.round().add(0.5, 0.5, 0.5)), newDirection);
            } else {
                Vector newDirection = new Vector(this.transform.apply(location.getDirection())).subtract(this.transform.apply(Vector.ZERO)).normalize();
                newLocation = new Location(this.destination, newPosition.add(this.to.round().add(0.5, 0.5, 0.5)), newDirection);
                state = this.transformNbtData(state);
            }
            boolean bl = success = this.destination.createEntity(newLocation, state) != null;
            if (this.isRemoving()) {
                entity.remove();
            }
            return success;
        }
        return false;
    }

    private BaseEntity transformNbtData(BaseEntity state) {
        CompoundTag tag = state.getNbtData();
        if (tag != null) {
            ListTag rotation;
            boolean changed = false;
            tag = tag.createBuilder().build();
            Map values = ReflectionUtils.getMap(tag.getValue());
            boolean hasTilePosition = tag.containsKey("TileX") && tag.containsKey("TileY") && tag.containsKey("TileZ");
            boolean hasDirection = tag.containsKey("Direction");
            boolean hasLegacyDirection = tag.containsKey("Dir");
            boolean hasFacing = tag.containsKey("Facing");
            if (hasTilePosition) {
                Vector vector;
                Direction newDirection;
                int d;
                Direction direction;
                changed = true;
                Vector tilePosition = new Vector(tag.asInt("TileX"), tag.asInt("TileY"), tag.asInt("TileZ"));
                Vector newTilePosition = this.transform.apply(tilePosition.subtract(this.from)).add(this.to);
                values.put("TileX", new IntTag(newTilePosition.getBlockX()));
                values.put("TileY", new IntTag(newTilePosition.getBlockY()));
                values.put("TileZ", new IntTag(newTilePosition.getBlockZ()));
                if ((hasDirection || hasLegacyDirection || hasFacing) && (direction = MCDirections.fromHanging(d = hasDirection ? tag.asInt("Direction") : (hasLegacyDirection ? MCDirections.fromLegacyHanging((byte)tag.asInt("Dir")) : tag.asInt("Facing")))) != null && (newDirection = Direction.findClosest(vector = this.transform.apply(direction.toVector()).subtract(this.transform.apply(Vector.ZERO)).normalize(), Direction.Flag.CARDINAL)) != null) {
                    byte hangingByte = (byte)MCDirections.toHanging(newDirection);
                    values.put("Direction", new ByteTag(hangingByte));
                    values.put("Facing", new ByteTag(hangingByte));
                    values.put("Dir", new ByteTag(MCDirections.toLegacyHanging(MCDirections.toHanging(newDirection))));
                }
            }
            if ((rotation = tag.getListTag("Rotation")) != null && rotation.getValue().size() >= 2) {
                changed = true;
                double yaw = Math.toRadians(rotation.getFloat(0));
                double pitch = Math.toRadians(rotation.getFloat(1));
                double xz = Math.cos(pitch);
                Vector direction = new Vector(-xz * Math.sin(yaw), -Math.sin(pitch), xz * Math.cos(yaw));
                direction = this.transform.apply(direction);
                FloatTag yawTag = new FloatTag(direction.toYaw());
                FloatTag pitchTag = new FloatTag(direction.toPitch());
                values.put("Rotation", new ListTag<FloatTag>(FloatTag.class, Arrays.asList(yawTag, pitchTag)));
            }
            if (changed) {
                return new BaseEntity(state.getType(), tag);
            }
        }
        return state;
    }
}

