/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.function.mask;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.Vector2D;
import com.sk89q.worldedit.function.mask.AbstractMask;
import com.sk89q.worldedit.function.mask.AbstractMask2D;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.mask.Mask2D;
import javax.annotation.Nullable;

public final class Masks {
    protected static final AlwaysTrue ALWAYS_TRUE = new AlwaysTrue();
    protected static final AlwaysFalse ALWAYS_FALSE = new AlwaysFalse();

    private Masks() {
    }

    public static boolean isNull(Mask mask) {
        return mask == null || mask == ALWAYS_TRUE;
    }

    public static Mask alwaysTrue() {
        return ALWAYS_TRUE;
    }

    public static Mask alwaysFalse() {
        return ALWAYS_FALSE;
    }

    public static Mask2D alwaysTrue2D() {
        return ALWAYS_TRUE;
    }

    public static Mask negate(Mask finalMask) {
        return finalMask.inverse();
    }

    public static Mask2D negate(final Mask2D mask) {
        if (mask instanceof AlwaysTrue) {
            return ALWAYS_FALSE;
        }
        if (mask instanceof AlwaysFalse) {
            return ALWAYS_TRUE;
        }
        Preconditions.checkNotNull((Object)mask);
        return new AbstractMask2D(){

            @Override
            public boolean test(Vector2D vector) {
                return !mask.test(vector);
            }
        };
    }

    public static Mask asMask(final Mask2D mask) {
        return new AbstractMask(){

            @Override
            public boolean test(Vector vector) {
                return mask.test(vector.toVector2D());
            }

            @Override
            @Nullable
            public Mask2D toMask2D() {
                return mask;
            }
        };
    }

    protected static class AlwaysFalse
    implements Mask,
    Mask2D {
        protected AlwaysFalse() {
        }

        @Override
        public boolean test(Vector vector) {
            return false;
        }

        @Override
        public boolean test(Vector2D vector) {
            return false;
        }

        @Override
        @Nullable
        public Mask2D toMask2D() {
            return this;
        }

        @Override
        public Mask and(Mask other) {
            return this;
        }

        @Override
        public Mask or(Mask other) {
            return other;
        }
    }

    protected static class AlwaysTrue
    implements Mask,
    Mask2D {
        protected AlwaysTrue() {
        }

        @Override
        public boolean test(Vector vector) {
            return true;
        }

        @Override
        public boolean test(Vector2D vector) {
            return true;
        }

        @Override
        @Nullable
        public Mask2D toMask2D() {
            return this;
        }

        @Override
        public Mask and(Mask other) {
            return other;
        }

        @Override
        public Mask or(Mask other) {
            return other;
        }
    }
}

