/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.function.operation;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.RunContext;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BlockMapEntryPlacer
implements Operation {
    private final Extent extent;
    private final Iterator<Map.Entry<BlockVector, BlockStateHolder>> iterator;

    public BlockMapEntryPlacer(Extent extent, Iterator<Map.Entry<BlockVector, BlockStateHolder>> iterator) {
        Preconditions.checkNotNull((Object)extent);
        Preconditions.checkNotNull(iterator);
        this.extent = extent;
        this.iterator = iterator;
    }

    @Override
    public Operation resume(RunContext run) throws WorldEditException {
        while (this.iterator.hasNext()) {
            Map.Entry<BlockVector, BlockStateHolder> entry = this.iterator.next();
            this.extent.setBlock(entry.getKey(), entry.getValue());
        }
        return null;
    }

    @Override
    public void cancel() {
    }

    @Override
    public void addStatusMessages(List<String> messages) {
    }
}

