/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.function.operation;

import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.RunContext;

public final class Operations {
    private static RunContext context = new RunContext();

    private Operations() {
    }

    public static void complete(Operation operation) throws WorldEditException {
        while (operation != null) {
            operation = operation.resume(context);
        }
    }

    public static void completeLegacy(Operation operation) throws MaxChangedBlocksException {
        Operations.completeBlindly(operation);
    }

    public static void completeBlindly(Operation operation) {
        try {
            while (operation != null) {
                operation = operation.resume(context);
            }
        }
        catch (WorldEditException e) {
            throw new RuntimeException(e);
        }
    }

    public static void completeSmart(Operation op, Runnable whenDone, boolean threadsafe) {
        Operations.completeBlindly(op);
        if (whenDone != null) {
            whenDone.run();
        }
    }
}

