/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.function.visitor;

import com.boydti.fawe.config.BBC;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.example.MappedFaweQueue;
import com.boydti.fawe.object.FaweQueue;
import com.boydti.fawe.object.HasFaweQueue;
import com.boydti.fawe.object.exception.FaweException;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.function.RegionFunction;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.RunContext;
import com.sk89q.worldedit.regions.Region;
import java.util.Iterator;
import java.util.List;

public class RegionVisitor
implements Operation {
    public final Region region;
    public final Iterable<? extends Vector> iterable;
    public final RegionFunction function;
    private final MappedFaweQueue queue;
    private boolean useCuboidIterator = false;
    public int affected = 0;

    @Deprecated
    public RegionVisitor(Region region, RegionFunction function) {
        this(region, function, (FaweQueue)null);
    }

    public RegionVisitor(Region region, RegionFunction function, EditSession editSession) {
        this(region, function, editSession != null ? editSession.getQueue() : null);
    }

    public RegionVisitor(Region region, RegionFunction function, FaweQueue queue) {
        this((Iterable<? extends Vector>)region, function, (HasFaweQueue)queue);
    }

    public RegionVisitor(Iterable<? extends Vector> iterable, RegionFunction function, HasFaweQueue hasQueue) {
        this.region = iterable instanceof Region ? (Region)iterable : null;
        this.iterable = iterable;
        this.function = function;
        this.queue = hasQueue != null && hasQueue.getQueue() instanceof MappedFaweQueue ? (MappedFaweQueue)hasQueue.getQueue() : null;
    }

    public int getAffected() {
        return this.affected;
    }

    @Override
    public Operation resume(RunContext run) throws WorldEditException {
        if (this.queue != null && Settings.IMP.QUEUE.PRELOAD_CHUNKS > 1) {
            Iterator<? extends Vector> trailIter = this.iterable.iterator();
            Iterator<? extends Vector> iterator = this.iterable.iterator();
            int lastTrailChunkX = Integer.MIN_VALUE;
            int lastTrailChunkZ = Integer.MIN_VALUE;
            int lastLeadChunkX = Integer.MIN_VALUE;
            int lastLeadChunkZ = Integer.MIN_VALUE;
            int loadingTarget = Settings.IMP.QUEUE.PRELOAD_CHUNKS;
            try {
                while (true) {
                    Vector pt = trailIter.next();
                    this.apply(pt);
                    int cx = pt.getBlockX() >> 4;
                    int cz = pt.getBlockZ() >> 4;
                    if (cx != lastTrailChunkX || cz != lastTrailChunkZ) {
                        int amount;
                        lastTrailChunkX = cx;
                        lastTrailChunkZ = cz;
                        if (lastLeadChunkX == Integer.MIN_VALUE) {
                            lastLeadChunkX = cx;
                            lastLeadChunkZ = cz;
                            amount = loadingTarget;
                        } else {
                            amount = 1;
                        }
                        int count = 0;
                        while (count < amount) {
                            Vector v = iterator.next();
                            int vcx = v.getBlockX() >> 4;
                            int vcz = v.getBlockZ() >> 4;
                            if (vcx != lastLeadChunkX || vcz != lastLeadChunkZ) {
                                lastLeadChunkX = vcx;
                                lastLeadChunkZ = vcz;
                                this.queue.queueChunkLoad(vcx, vcz);
                                ++count;
                            }
                            iterator.next();
                            iterator.next();
                            iterator.next();
                            iterator.next();
                            iterator.next();
                            iterator.next();
                            iterator.next();
                            iterator.next();
                            iterator.next();
                            iterator.next();
                            iterator.next();
                            iterator.next();
                            iterator.next();
                            iterator.next();
                            iterator.next();
                        }
                    }
                    this.apply(trailIter.next());
                    this.apply(trailIter.next());
                    this.apply(trailIter.next());
                    this.apply(trailIter.next());
                    this.apply(trailIter.next());
                    this.apply(trailIter.next());
                    this.apply(trailIter.next());
                    this.apply(trailIter.next());
                    this.apply(trailIter.next());
                    this.apply(trailIter.next());
                    this.apply(trailIter.next());
                    this.apply(trailIter.next());
                    this.apply(trailIter.next());
                    this.apply(trailIter.next());
                    this.apply(trailIter.next());
                }
            }
            catch (FaweException e) {
                throw new RuntimeException(e);
            }
            catch (Throwable e) {
                try {
                    while (true) {
                        this.apply(trailIter.next());
                        this.apply(trailIter.next());
                    }
                }
                catch (FaweException e2) {
                    throw new RuntimeException(e2);
                }
                catch (Throwable throwable) {}
            }
        } else {
            for (Vector vector : this.iterable) {
                this.apply(vector);
            }
        }
        return null;
    }

    private void apply(Vector pt) throws WorldEditException {
        if (this.function.apply(pt)) {
            ++this.affected;
        }
    }

    @Override
    public void cancel() {
    }

    @Override
    public void addStatusMessages(List<String> messages) {
        messages.add(BBC.VISITOR_BLOCK.format(this.getAffected()));
    }
}

