/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.regions.shape;

import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.internal.expression.runtime.ExpressionEnvironment;

public class WorldEditExpressionEnvironment
implements ExpressionEnvironment {
    private final Vector unit;
    private final Vector zero2;
    private Vector current = new Vector();
    private Extent extent;

    public WorldEditExpressionEnvironment(EditSession editSession, Vector unit, Vector zero) {
        this((Extent)editSession, unit, zero);
    }

    public WorldEditExpressionEnvironment(Extent extent, Vector unit, Vector zero) {
        this.extent = extent;
        this.unit = unit;
        this.zero2 = zero.add(0.5, 0.5, 0.5);
    }

    public BlockVector toWorld(double x, double y, double z) {
        return new Vector(x, y, z).multiply(this.unit).add(this.zero2).toBlockPoint();
    }

    public Vector toWorldRel(double x, double y, double z) {
        return this.current.add(x, y, z);
    }

    @Override
    public int getBlockType(double x, double y, double z) {
        return this.extent.getBlock(this.toWorld(x, y, z)).getBlockType().getLegacyCombinedId() >> 4;
    }

    @Override
    public int getBlockData(double x, double y, double z) {
        return this.extent.getBlock(this.toWorld(x, y, z)).getBlockType().getLegacyCombinedId() & 0xF;
    }

    @Override
    public int getBlockTypeAbs(double x, double y, double z) {
        return this.extent.getBlock(this.toWorld(x, y, z)).getBlockType().getLegacyCombinedId() >> 4;
    }

    @Override
    public int getBlockDataAbs(double x, double y, double z) {
        return this.extent.getBlock(this.toWorld(x, y, z)).getBlockType().getLegacyCombinedId() & 0xF;
    }

    @Override
    public int getBlockTypeRel(double x, double y, double z) {
        return this.extent.getBlock(this.toWorld(x, y, z)).getBlockType().getLegacyCombinedId() >> 4;
    }

    @Override
    public int getBlockDataRel(double x, double y, double z) {
        return this.extent.getBlock(this.toWorld(x, y, z)).getBlockType().getLegacyCombinedId() & 0xF;
    }

    public void setCurrentBlock(Vector current) {
        this.current = current;
    }
}

